/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.GlobalRef;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Type;

public class Global {
    private final String name;
    private final Linkage linkage;
    private final Constant value;
    private final Type type;
    private final boolean constant;
    private final String section;

    public Global(String name, Type type) {
        this(name, Linkage.external, type, false);
    }

    public Global(String name, Type type, boolean constant) {
        this(name, Linkage.external, type, constant);
    }

    public Global(String name, Linkage linkage, Type type, boolean constant) {
        this.name = name;
        this.linkage = linkage;
        this.value = null;
        this.type = type;
        this.constant = constant;
        this.section = null;
    }

    public Global(String name, Constant value) {
        this(name, null, value, false, null);
    }

    public Global(String name, Constant value, boolean constant) {
        this(name, null, value, constant, null);
    }

    public Global(String name, Linkage linkage, Constant value) {
        this(name, linkage, value, false, null);
    }

    public Global(String name, Linkage linkage, Constant value, boolean constant) {
        this(name, linkage, value, constant, null);
    }

    public Global(String name, Constant value, boolean constant, String section) {
        this(name, null, value, constant, section);
    }

    public Global(String name, Linkage linkage, Constant value, boolean constant, String section) {
        this.name = name;
        this.linkage = linkage;
        this.value = value;
        this.type = value.getType();
        this.constant = constant;
        this.section = section;
    }

    public GlobalRef ref() {
        return new GlobalRef(this);
    }

    public String getName() {
        return this.name;
    }

    public PointerType getType() {
        return new PointerType(this.type);
    }

    public String getDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("@\"");
        sb.append(this.name);
        sb.append("\" = ");
        if (this.linkage != null) {
            sb.append((Object)this.linkage);
            sb.append(' ');
        }
        if (this.constant) {
            sb.append("constant ");
        } else {
            sb.append("global ");
        }
        sb.append(this.type);
        if (this.value != null) {
            sb.append(' ');
            sb.append(this.value);
        }
        if (this.section != null) {
            sb.append(", section \"");
            sb.append(this.section);
            sb.append('\"');
        }
        return sb.toString();
    }

    public String toString() {
        return "@\"" + this.name + "\"";
    }
}

