/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.robovm.compiler.llvm.BasicBlock;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;

public class Phi
extends Instruction {
    private final Variable result;
    private final VariableRef[] vars;

    public Phi(Variable result, VariableRef ... vars) {
        if (vars.length < 2) {
            throw new IllegalArgumentException("At least two variables expected");
        }
        Type t = result.getType();
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i].getType().equals(t)) continue;
            throw new IllegalArgumentException("Type mismatch in variable " + vars[i]);
        }
        this.result = result;
        this.vars = vars;
    }

    @Override
    public Set<Variable> getWritesTo() {
        return Collections.singleton(this.result);
    }

    @Override
    public Set<VariableRef> getReadsFrom() {
        return new HashSet<VariableRef>(Arrays.asList(this.vars));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.result.toString());
        sb.append(" = phi ");
        sb.append(this.result.getType().toString());
        for (int i = 0; i < this.vars.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("[ ");
            sb.append(this.vars[i].toString());
            sb.append(", ");
            BasicBlock bb = this.basicBlock.getFunction().getDefinedIn(this.vars[i]);
            sb.append('%');
            sb.append(bb.getName());
            sb.append(" ]");
        }
        return sb.toString();
    }
}

