/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm.debug.dwarf;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.robovm.compiler.llvm.Metadata;

public class DIHeader
extends Metadata {
    private final List<String> values = new ArrayList<String>();

    public DIHeader add(String v) {
        this.values.add(DIHeader.escape(v));
        return this;
    }

    public DIHeader add(int v) {
        this.values.add(Integer.toString(v));
        return this;
    }

    public DIHeader add(long v) {
        this.values.add(Long.toString(v));
        return this;
    }

    public DIHeader add(boolean v) {
        this.values.add(v ? "1" : "0");
        return this;
    }

    public String toString() {
        return "!\"" + StringUtils.join(this.values, (String)"\\00") + "\"";
    }

    private static String escape(String s) {
        byte[] bytes;
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes = s.getBytes()) {
            if (b < 32 || b > 126 || b == 34 || b == 92) {
                sb.append(String.format("\\%02X", b));
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }
}

