/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.desugar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;
import org.robovm.compiler.plugin.PluginArgument;
import org.robovm.compiler.plugin.PluginArguments;
import soot.Body;
import soot.IntType;
import soot.Local;
import soot.PatchingChain;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;

public class ByteBufferJava9ApiPlugin
extends AbstractCompilerPlugin {
    private static final String JAVA_NIO_BYTEBUFFER = "java.nio.ByteBuffer";
    private static final String JAVA_NIO_BUFFER = "java.nio.Buffer";
    private static final String ARG_KEY_ENABLE_PLUGIN = "enableJdk9ByteBufferApi";
    private Boolean enabled;

    @Override
    public PluginArguments getArguments() {
        ArrayList<PluginArgument> args = new ArrayList<PluginArgument>();
        args.add(new PluginArgument(ARG_KEY_ENABLE_PLUGIN, "false", "Flag: disables Java9 changes to java.nio.ByteBuffer"));
        return new PluginArguments("desugar", args);
    }

    private boolean isEnabled(Config config) {
        if (this.enabled == null) {
            this.enabled = this.argumentValue(this.parseArguments(config), ARG_KEY_ENABLE_PLUGIN, true);
        }
        return this.enabled;
    }

    @Override
    public void beforeConfig(Config.Builder builder, Config config) throws IOException {
        super.beforeConfig(builder, config);
        this.enabled = null;
    }

    @Override
    public void beforeClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder) throws IOException {
        if (this.isEnabled(config) && this.isAcceptableByteBuffer(clazz.getSootClass())) {
            SootClass sootClass = clazz.getSootClass();
            this.injectMethod(sootClass, "flip", false);
            this.injectMethod(sootClass, "clear", false);
            this.injectMethod(sootClass, "mark", false);
            this.injectMethod(sootClass, "reset", false);
            this.injectMethod(sootClass, "rewind", false);
            this.injectMethod(sootClass, "position", true);
            this.injectMethod(sootClass, "limit", true);
            config.getVTableCache().remove(sootClass);
        }
    }

    private boolean isAcceptableByteBuffer(SootClass sootClass) {
        return JAVA_NIO_BYTEBUFFER.equals(sootClass.getName()) && JAVA_NIO_BUFFER.equals(sootClass.getSuperclass().getName());
    }

    private void injectMethod(SootClass bbSootClass, String name, boolean withIntParam) {
        String paramSignature = withIntParam ? "(int)" : "()";
        String subSignature = "java.nio.ByteBuffer " + name + paramSignature;
        if (this.findMethod(bbSootClass, subSignature) == null) {
            subSignature = "java.nio.Buffer " + name + paramSignature;
            SootMethod zuperMethod = this.findMethod(bbSootClass.getSuperclass(), subSignature);
            if (zuperMethod == null) {
                throw new IllegalArgumentException("java.nio.Buffer: missing method " + subSignature);
            }
            List<Object> paramTypes = withIntParam ? Collections.singletonList(IntType.v()) : Collections.emptyList();
            SootMethod m = new SootMethod(name, paramTypes, (Type)bbSootClass.getType(), 1);
            Jimple j = Jimple.v();
            JimpleBody body = j.newBody(m);
            PatchingChain units = body.getUnits();
            Local thiz = j.newLocal("$this", (Type)bbSootClass.getType());
            body.getLocals().add((Object)thiz);
            units.add((Unit)j.newIdentityStmt((Value)thiz, (Value)j.newThisRef(bbSootClass.getType())));
            if (withIntParam) {
                Local i = j.newLocal("$i", (Type)IntType.v());
                body.getLocals().add((Object)i);
                units.add((Unit)j.newIdentityStmt((Value)i, (Value)j.newParameterRef((Type)IntType.v(), 0)));
                units.add((Unit)j.newInvokeStmt((Value)j.newSpecialInvokeExpr(thiz, zuperMethod.makeRef(), (Value)i)));
            } else {
                units.add((Unit)j.newInvokeStmt((Value)j.newSpecialInvokeExpr(thiz, zuperMethod.makeRef())));
            }
            units.add((Unit)j.newReturnStmt((Value)thiz));
            m.setActiveBody((Body)body);
            bbSootClass.addMethod(m);
        }
    }

    private SootMethod findMethod(SootClass sootClass, String subSignature) {
        return sootClass.getMethods().stream().filter(method -> subSignature.equals(method.getSubSignature())).findFirst().orElse(null);
    }
}

