/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.ios;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.io.output.NullOutputStream;
import org.robovm.compiler.log.ErrorOutputStream;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.target.Launcher;
import org.robovm.compiler.target.ios.DeviceType;
import org.robovm.compiler.target.ios.IOSSimulatorLaunchParameters;
import org.robovm.compiler.util.Executor;
import org.robovm.compiler.util.io.OpenOnWriteFileOutputStream;

public class SimLauncherProcess
extends Process
implements Launcher {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final AtomicInteger threadCounter = new AtomicInteger();
    private final Logger log;
    private final DeviceType deviceType;
    private final String watchAppName;
    private final File wd;
    private final String bundleId;
    private final File appDir;
    private final List<String> arguments;
    private HashMap<String, String> env;
    private Thread launcherThread;
    private volatile boolean finished = false;
    private volatile int exitCode = -1;
    private OutputStream errStream;
    private OutputStream outStream;
    final InputStream waitInputStream = new InputStream(){

        @Override
        public int read() throws IOException {
            try {
                SimLauncherProcess.this.countDownLatch.await();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            return -1;
        }
    };

    public SimLauncherProcess(Logger log, File appDir, String bundleId, IOSSimulatorLaunchParameters launchParameters) {
        this.log = log;
        this.deviceType = launchParameters.getDeviceType();
        this.watchAppName = launchParameters.getPairedWatchAppName();
        this.wd = launchParameters.getWorkingDirectory();
        this.appDir = appDir;
        this.bundleId = bundleId;
        this.arguments = new ArrayList<String>(launchParameters.getArguments(true));
        if (launchParameters.getEnvironment() != null) {
            this.env = new HashMap();
            for (Map.Entry<String, String> entry : launchParameters.getEnvironment().entrySet()) {
                this.env.put("SIMCTL_CHILD_" + entry.getKey(), entry.getValue());
            }
        }
        this.outStream = System.out;
        this.errStream = System.err;
        if (launchParameters.getStdoutFifo() != null) {
            this.outStream = new OpenOnWriteFileOutputStream(launchParameters.getStdoutFifo());
        }
        if (launchParameters.getStderrFifo() != null) {
            this.errStream = new OpenOnWriteFileOutputStream(launchParameters.getStderrFifo());
        }
    }

    @Override
    public Process execAsync() throws IOException {
        this.launcherThread = new Thread("SimLauncherThread-" + this.threadCounter.getAndIncrement()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Executor executor;
                    DeviceType freshState = SimLauncherProcess.this.deviceType.refresh();
                    if (freshState != null && "shutdown".equals(freshState.getState().toLowerCase())) {
                        SimLauncherProcess.this.log.info("Booting simulator %s", SimLauncherProcess.this.deviceType.getUdid());
                        executor = new Executor(SimLauncherProcess.this.log, "xcrun");
                        executor.args("simctl", "boot", SimLauncherProcess.this.deviceType.getUdid());
                        executor.exec();
                    }
                    SimLauncherProcess.this.log.info("Showing simulator %s", SimLauncherProcess.this.deviceType.getUdid());
                    executor = new Executor(SimLauncherProcess.this.log, "open");
                    executor.args("-a", "Simulator", "--args", "-CurrentDeviceUDID", SimLauncherProcess.this.deviceType.getUdid());
                    executor.exec();
                    SimLauncherProcess.this.log.info("Deploying app %s to simulator %s", SimLauncherProcess.this.appDir.getAbsolutePath(), SimLauncherProcess.this.deviceType.getUdid());
                    executor = new Executor(SimLauncherProcess.this.log, "xcrun");
                    executor.args("simctl", "install", SimLauncherProcess.this.deviceType.getUdid(), SimLauncherProcess.this.appDir.getAbsolutePath());
                    executor.exec();
                    if (SimLauncherProcess.this.watchAppName != null && freshState != null && freshState.getPair() != null) {
                        DeviceType watchDeviceType = freshState.getPair();
                        if ("shutdown".equals(watchDeviceType.getState().toLowerCase())) {
                            SimLauncherProcess.this.log.info("Booting watch simulator %s", watchDeviceType.getUdid());
                            executor = new Executor(SimLauncherProcess.this.log, "xcrun");
                            executor.args("simctl", "boot", watchDeviceType.getUdid());
                            executor.exec();
                        }
                        SimLauncherProcess.this.log.info("Showing watch simulator %s", watchDeviceType.getUdid());
                        executor = new Executor(SimLauncherProcess.this.log, "open");
                        executor.args("-a", "Simulator", "--args", "-CurrentDeviceUDID", watchDeviceType.getUdid());
                        executor.exec();
                        File watchAppDir = new File(SimLauncherProcess.this.appDir, "Watch/" + SimLauncherProcess.this.watchAppName);
                        SimLauncherProcess.this.log.info("Deploying app %s to watch simulator %s", watchAppDir.getAbsolutePath(), watchDeviceType.getUdid());
                        executor = new Executor(SimLauncherProcess.this.log, "xcrun");
                        executor.args("simctl", "install", watchDeviceType.getUdid(), watchAppDir.getAbsolutePath());
                        executor.exec();
                    }
                    SimLauncherProcess.this.log.info("Launching app %s on simulator %s", SimLauncherProcess.this.appDir.getAbsolutePath(), SimLauncherProcess.this.deviceType.getUdid());
                    executor = new Executor(SimLauncherProcess.this.log, "xcrun");
                    ArrayList<Object> args = new ArrayList<Object>();
                    args.add("simctl");
                    args.add("launch");
                    args.add("--console");
                    args.add(SimLauncherProcess.this.deviceType.getUdid());
                    args.add(SimLauncherProcess.this.bundleId);
                    args.addAll(SimLauncherProcess.this.arguments);
                    executor.args(args);
                    if (SimLauncherProcess.this.env != null) {
                        executor.env(SimLauncherProcess.this.env);
                    }
                    executor.wd(SimLauncherProcess.this.wd).out(SimLauncherProcess.this.outStream).err(SimLauncherProcess.this.errStream).closeOutputStreams(true).inheritEnv(false);
                    executor.exec();
                    SimLauncherProcess.this.exitCode = 0;
                }
                catch (ExecuteException e) {
                    SimLauncherProcess.this.exitCode = e.getExitValue();
                    if (SimLauncherProcess.this.exitCode == -559038737) {
                        SimLauncherProcess.this.exitCode = 0;
                    }
                }
                catch (Throwable t) {
                    SimLauncherProcess.this.log.error("AppLauncher failed with an exception:", t.getMessage());
                    t.printStackTrace(new PrintStream(new ErrorOutputStream(SimLauncherProcess.this.log), true));
                }
                finally {
                    SimLauncherProcess.this.finished = true;
                    SimLauncherProcess.this.countDownLatch.countDown();
                }
            }
        };
        this.launcherThread.start();
        return this;
    }

    @Override
    public OutputStream getOutputStream() {
        return new NullOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.waitInputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.waitInputStream;
    }

    @Override
    public int waitFor() throws InterruptedException {
        this.countDownLatch.await();
        return this.exitCode;
    }

    @Override
    public int exitValue() {
        if (!this.finished) {
            throw new IllegalThreadStateException("Not terminated");
        }
        return this.exitCode;
    }

    @Override
    public void destroy() {
        try {
            this.launcherThread.interrupt();
            this.launcherThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

