/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.trampoline;

import org.robovm.compiler.Symbols;
import org.robovm.compiler.trampoline.Trampoline;

public abstract class FieldAccessor
extends Trampoline {
    private static final long serialVersionUID = 1L;
    protected final String fieldName;
    protected final String fieldDesc;

    protected FieldAccessor(String callingClass, String targetClass, String fieldName, String fieldDesc) {
        super(callingClass, targetClass);
        this.fieldName = fieldName;
        this.fieldDesc = fieldDesc;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldDesc() {
        return this.fieldDesc;
    }

    public abstract boolean isGetter();

    public abstract boolean isStatic();

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fieldDesc == null ? 0 : this.fieldDesc.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldAccessor other = (FieldAccessor)obj;
        if (this.fieldDesc == null ? other.fieldDesc != null : !this.fieldDesc.equals(other.fieldDesc)) {
            return false;
        }
        return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
    }

    @Override
    public int compareTo(Trampoline o) {
        int c = super.compareTo(o);
        if (c == 0 && o instanceof FieldAccessor && (c = this.fieldName.compareTo(((FieldAccessor)o).fieldName)) == 0) {
            c = this.fieldDesc.compareTo(((FieldAccessor)o).fieldDesc);
        }
        return c;
    }

    @Override
    public String toString() {
        return Symbols.trampolineFieldSymbol(this, this.getCallingClass(), this.getTarget(), this.getFieldName(), this.getFieldDesc());
    }
}

