/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.io;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;

public class HfsCompressor {
    private static volatile boolean isAvailable;
    private static volatile boolean isLoaded;

    private static synchronized void loadLib(Config config) {
        if (isLoaded) {
            return;
        }
        if (System.getenv("ROBOVM_DISABLE_COMPRESSION") != null) {
            isLoaded = true;
            return;
        }
        String archProp = System.getProperty("os.arch").toLowerCase();
        String arch = archProp.matches("amd64|x86[-_]64") ? "x86_64" : (archProp.matches("aarch64|arm64") ? "arm64" : null);
        if (arch != null) {
            String hfscompressorLib = new File(config.getHome().getBinDir(), "libhfscompressor-" + arch + ".dylib").getAbsolutePath();
            try {
                System.load(hfscompressorLib);
                isAvailable = true;
            }
            catch (Throwable t) {
                config.getLogger().error("Failed to load %s", hfscompressorLib);
            }
        }
        isLoaded = true;
    }

    public void compress(File file, byte[] data, Config config) throws IOException, InterruptedException {
        if (OS.getDefaultOS() == OS.macosx) {
            HfsCompressor.loadLib(config);
        }
        if (isAvailable) {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new CompilerException("Couldn't create directory for " + file.getAbsolutePath());
            }
            HfsCompressor.loadLib(config);
            if (!HfsCompressor.compressNative(file.getAbsolutePath(), data, data.length)) {
                config.getLogger().debug("Couldn't compress file %s", file.getAbsolutePath());
                FileUtils.writeByteArrayToFile((File)file, (byte[])data);
            }
        } else {
            FileUtils.writeByteArrayToFile((File)file, (byte[])data);
        }
    }

    public static native boolean compressNative(String var0, byte[] var1, int var2);
}

