/*
 * Copyright (C) 2012 RoboVM AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl-2.0.html>.
 */
package org.robovm.compiler.config;

import org.robovm.llvm.Target;

/**
 * @author niklas
 *
 */
public enum OS {
    linux("linux",  "unknown","linux"),
    macosx("macosx", "apple", "10.9"),
    ios("ios", "apple", "8.0");
    
    public enum Family {linux, darwin}

    private final String llvmName;
    private final String vendor;
    private final String minVersion;

    private OS(String llvmName, String vendor, String minVersion) {
        this.llvmName = llvmName;
        this.vendor = vendor;
        this.minVersion = minVersion;
    }

    public String getLlvmName() {
        return llvmName;
    }

    public String getVendor() {
        return vendor;
    }

    public String getMinVersion() {
        return minVersion;
    }
    
    public Family getFamily() {
        return this == linux ? Family.linux : Family.darwin;
    }
    
    public static OS getDefaultOS() {
        String hostTriple = Target.getHostTriple();
        if (hostTriple.contains("linux")) {
            return OS.linux;
        }
        if (hostTriple.contains("darwin") || hostTriple.contains("apple")) {
            return OS.macosx;
        }
        throw new IllegalArgumentException("Unrecognized OS in host triple: " + hostTriple);
    }
}
