/*
 * Copyright (C) 2014 RoboVM AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl-2.0.html>.
 */
package org.robovm.compiler.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

import org.robovm.compiler.Linker;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.Config.Builder;
import org.robovm.compiler.llvm.Function;

import org.robovm.llvm.ObjectFile;
import soot.SootMethod;

/**
 * Abstract implementation for {@link CompilerPlugin} with empty implementations
 * for all methods.
 */
public abstract class AbstractCompilerPlugin extends CompilerPlugin {
    @Override
    public PluginArguments getArguments() {
        return new PluginArguments("", Collections.<PluginArgument> emptyList());
    }

    @Override
    public void beforeConfig(Builder builder, Config config) throws IOException {}

    @Override
    public void helloClass(Config config, Clazz clazz) {}

    @Override
    public void beforeClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder)
            throws IOException {}

    @Override
    public void beforeMethod(Config config, Clazz clazz, SootMethod method,
            ModuleBuilder moduleBuilder) throws IOException {}

    @Override
    public void afterClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder)
            throws IOException {}

    @Override
    public void afterMethod(Config config, Clazz clazz, SootMethod method,
            ModuleBuilder moduleBuilder, Function function) throws IOException {}

    @Override
    public void afterClassDependenciesResolved(Config config, Clazz clazz) {}

    @Override
    public void afterObjectFile(Config config, Clazz clazz, File objectFile, ObjectFile objectFileData) throws IOException {}

    @Override
    public void beforeLinker(Config config, Linker linker, Set<Clazz> classes) throws IOException {}

    @Override
    public void afterLinker(Config config, File executable) throws IOException {}
}
