/*
 * Copyright (C) 2014 RoboVM AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl-2.0.html>.
 */
package org.robovm.compiler.util.generic;

import org.robovm.compiler.Types;

import soot.RefType;
import soot.SootClass;
import soot.SootResolver;


/**
 * {@link Type} implementation which wraps a {@link soot.Type}.
 */
public class SootTypeType implements Type {
    private final soot.Type type;

    public SootTypeType(String name) {
        this(SootResolver.v().makeClassRef(name).getType());
    }

    public SootTypeType(soot.Type type) {
        this.type = type;
    }

    public soot.Type getSootType() {
        return type;
    }

    public SootClass getSootClass() {
        return ((RefType) type).getSootClass();
    }

    @Override
    public String toString() {
        return type.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((type == null) ? 0 : type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        SootTypeType other = (SootTypeType) obj;
        if (type == null) {
            if (other.type != null) {
                return false;
            }
        } else if (!type.equals(other.type)) {
            return false;
        }
        return true;
    }

    @Override
    public String toGenericSignature() {
        return Types.getDescriptor(type);
    }
}
