/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.robovm.compiler.AbstractMethodCompiler;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.AttributesEncoder;
import org.robovm.compiler.BridgeMethodCompiler;
import org.robovm.compiler.BroMethodCompiler;
import org.robovm.compiler.CallbackMethodCompiler;
import org.robovm.compiler.ClassCompilerListener;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.GlobalValueMethodCompiler;
import org.robovm.compiler.ITable;
import org.robovm.compiler.MethodCompiler;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.NativeMethodCompiler;
import org.robovm.compiler.StructMemberMethodCompiler;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.TrampolineCompiler;
import org.robovm.compiler.Types;
import org.robovm.compiler.VTable;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.ClazzInfo;
import org.robovm.compiler.clazz.Dependency;
import org.robovm.compiler.clazz.MethodInfo;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.llvm.Alias;
import org.robovm.compiler.llvm.AliasRef;
import org.robovm.compiler.llvm.And;
import org.robovm.compiler.llvm.ArrayConstant;
import org.robovm.compiler.llvm.ArrayConstantBuilder;
import org.robovm.compiler.llvm.ArrayType;
import org.robovm.compiler.llvm.Bitcast;
import org.robovm.compiler.llvm.Br;
import org.robovm.compiler.llvm.ByteArrayConstant;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.Fence;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionDeclaration;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.Getelementptr;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.GlobalRef;
import org.robovm.compiler.llvm.Icmp;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.Load;
import org.robovm.compiler.llvm.NullConstant;
import org.robovm.compiler.llvm.Ordering;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.Store;
import org.robovm.compiler.llvm.StructureConstant;
import org.robovm.compiler.llvm.StructureConstantBuilder;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;
import org.robovm.compiler.plugin.CompilerPlugin;
import org.robovm.compiler.plugin.objc.ObjCMemberPlugin;
import org.robovm.compiler.trampoline.Checkcast;
import org.robovm.compiler.trampoline.Instanceof;
import org.robovm.compiler.trampoline.Invoke;
import org.robovm.compiler.trampoline.Invokeinterface;
import org.robovm.compiler.trampoline.Invokevirtual;
import org.robovm.compiler.trampoline.Trampoline;
import org.robovm.compiler.util.io.HfsCompressor;
import org.robovm.debugger.debuginfo.DebuggerDebugObjectFileInfo;
import org.robovm.llvm.Context;
import org.robovm.llvm.LineInfo;
import org.robovm.llvm.Module;
import org.robovm.llvm.ObjectFile;
import org.robovm.llvm.PassManager;
import org.robovm.llvm.PassManagerBuilder;
import org.robovm.llvm.Symbol;
import org.robovm.llvm.Target;
import org.robovm.llvm.TargetMachine;
import org.robovm.llvm.binding.Attribute;
import org.robovm.llvm.binding.CodeGenFileType;
import org.robovm.llvm.binding.CodeGenOptLevel;
import org.robovm.llvm.binding.RelocMode;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.Modifier;
import soot.PrimType;
import soot.RefLikeType;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.VoidType;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.internal.JReturnVoidStmt;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.Host;
import soot.tagkit.Tag;

public class ClassCompiler {
    private static final int DUMMY_METHOD_SIZE = 28036591;
    public static final int CI_PUBLIC = 1;
    public static final int CI_FINAL = 2;
    public static final int CI_INTERFACE = 4;
    public static final int CI_ABSTRACT = 8;
    public static final int CI_SYNTHETIC = 16;
    public static final int CI_ANNOTATION = 32;
    public static final int CI_ENUM = 64;
    public static final int CI_ATTRIBUTES = 128;
    public static final int CI_ERROR = 256;
    public static final int CI_INITIALIZED = 512;
    public static final int CI_FINALIZABLE = 1024;
    public static final int CI_ERROR_TYPE_NONE = 0;
    public static final int CI_ERROR_TYPE_NO_CLASS_DEF_FOUND = 1;
    public static final int CI_ERROR_TYPE_ILLEGAL_ACCESS = 2;
    public static final int CI_ERROR_TYPE_INCOMPATIBLE_CLASS_CHANGE = 3;
    public static final int FI_ACCESS_MASK = 3;
    public static final int FI_PUBLIC = 1;
    public static final int FI_PRIVATE = 2;
    public static final int FI_PROTECTED = 3;
    public static final int FI_STATIC = 4;
    public static final int FI_FINAL = 8;
    public static final int FI_VOLATILE = 16;
    public static final int FI_TRANSIENT = 32;
    public static final int FI_SYNTHETIC = 64;
    public static final int FI_ENUM = 128;
    public static final int FI_ATTRIBUTES = 256;
    public static final int MI_ACCESS_MASK = 3;
    public static final int MI_PUBLIC = 1;
    public static final int MI_PRIVATE = 2;
    public static final int MI_PROTECTED = 3;
    public static final int MI_STATIC = 4;
    public static final int MI_FINAL = 8;
    public static final int MI_SYNCHRONIZED = 16;
    public static final int MI_BRIDGE = 32;
    public static final int MI_VARARGS = 64;
    public static final int MI_NATIVE = 128;
    public static final int MI_ABSTRACT = 256;
    public static final int MI_STRICT = 512;
    public static final int MI_SYNTHETIC = 1024;
    public static final int MI_ATTRIBUTES = 2048;
    public static final int MI_BRO_BRIDGE = 4096;
    public static final int MI_BRO_CALLBACK = 8192;
    public static final int MI_COMPACT_DESC = 16384;
    public static final int DESC_B = 1;
    public static final int DESC_C = 2;
    public static final int DESC_D = 3;
    public static final int DESC_F = 4;
    public static final int DESC_I = 5;
    public static final int DESC_J = 6;
    public static final int DESC_S = 7;
    public static final int DESC_Z = 8;
    public static final int DESC_V = 9;
    private SootClass sootClass;
    private ModuleBuilder mb;
    private Map<Trampoline, List<SootMethod>> trampolines;
    private Set<String> catches;
    private List<SootField> classFields;
    private List<SootField> instanceFields;
    private StructureType classType;
    private StructureType instanceType;
    private final Config config;
    private final MethodCompiler javaMethodCompiler;
    private final BroMethodCompiler bridgeMethodCompiler;
    private final CallbackMethodCompiler callbackMethodCompiler;
    private final NativeMethodCompiler nativeMethodCompiler;
    private final StructMemberMethodCompiler structMemberMethodCompiler;
    private final GlobalValueMethodCompiler globalValueMethodCompiler;
    private final AttributesEncoder attributesEncoder;
    private final TrampolineCompiler trampolineResolver;
    private final ObjCMemberPlugin.MethodCompiler objcMethodCompiler;
    private final ByteArrayOutputStream output = new ByteArrayOutputStream(0x400000);

    public ClassCompiler(Config config) {
        this.config = config;
        this.javaMethodCompiler = new MethodCompiler(config);
        this.bridgeMethodCompiler = new BridgeMethodCompiler(config);
        this.callbackMethodCompiler = new CallbackMethodCompiler(config);
        this.nativeMethodCompiler = new NativeMethodCompiler(config);
        this.structMemberMethodCompiler = new StructMemberMethodCompiler(config);
        this.globalValueMethodCompiler = new GlobalValueMethodCompiler(config);
        this.attributesEncoder = new AttributesEncoder();
        this.trampolineResolver = new TrampolineCompiler(config);
        this.objcMethodCompiler = new ObjCMemberPlugin.MethodCompiler(config);
    }

    public boolean mustCompile(Clazz clazz) {
        File oFile = this.config.getOFile(clazz);
        if (!oFile.exists() || oFile.lastModified() < clazz.lastModified() || oFile.length() == 0L) {
            return true;
        }
        ClazzInfo ci = clazz.getClazzInfo();
        if (ci == null) {
            return true;
        }
        Set<Dependency> dependencies = ci.getAllDependencies();
        for (Dependency dep : dependencies) {
            Clazz depClazz = this.config.getClazzes().load(dep.getClassName());
            if (depClazz == null) {
                if (dep.getPath() == null) continue;
                return true;
            }
            if (dep.getPath() == null) {
                return true;
            }
            if (!dep.getPath().equals(depClazz.getPath().getFile().getAbsolutePath())) {
                return true;
            }
            if (depClazz.isInBootClasspath() != dep.isInBootClasspath()) {
                return true;
            }
            if (depClazz.lastModified() <= oFile.lastModified()) continue;
            return true;
        }
        return dependencies.isEmpty();
    }

    public void compile(Clazz clazz, Executor executor, ClassCompilerListener listener) throws IOException {
        this.reset();
        Arch arch = this.config.getArch();
        OS os = this.config.getOs();
        try {
            this.config.getLogger().info("Compiling %s (%s %s %s)", new Object[]{clazz, os, arch, this.config.isDebug() ? "debug" : "release"});
            this.output.reset();
            this.compile(clazz, this.output);
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        ArrayList<String> cCode = new ArrayList<String>();
        cCode.addAll(this.bridgeMethodCompiler.getCWrapperFunctions());
        cCode.addAll(this.callbackMethodCompiler.getCWrapperFunctions());
        ClassCompiler.scheduleMachineCodeGeneration(executor, listener, this.config, clazz, this.output.toByteArray(), cCode);
    }

    private static void scheduleMachineCodeGeneration(Executor executor, final ClassCompilerListener listener, final Config config, final Clazz clazz, final byte[] llData, final List<String> cCode) {
        block2: {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        ClassCompiler.generateMachineCode(config, clazz, llData, cCode);
                        listener.success(clazz);
                    }
                    catch (Throwable t) {
                        listener.failure(clazz, t);
                    }
                }
            };
            try {
                executor.execute(task);
            }
            catch (RejectedExecutionException e) {
                if (executor instanceof ExecutorService && ((ExecutorService)executor).isShutdown()) break block2;
                task.run();
            }
        }
    }

    private static void generateMachineCode(Config config, Clazz clazz, byte[] llData, List<String> cCode) throws IOException {
        if (config.isDumpIntermediates()) {
            File llFile = config.getLlFile(clazz);
            llFile.getParentFile().mkdirs();
            FileUtils.writeByteArrayToFile((File)llFile, (byte[])llData);
            File cFile = config.getCFile(clazz);
            if (cCode.isEmpty()) {
                cFile.delete();
            } else {
                FileUtils.writeLines((File)cFile, (String)"ascii", cCode);
            }
        }
        File oFile = config.getOFile(clazz);
        try (Context context = new Context();
             Module module = Module.parseIR((Context)context, (byte[])llData, (String)clazz.getClassName());){
            if (!cCode.isEmpty()) {
                int size = 0;
                for (String string : cCode) {
                    size += string.length();
                }
                StringBuilder sb = new StringBuilder(size);
                for (String string : cCode) {
                    sb.append(string);
                }
                try (Module module2 = Module.parseClangString((Context)context, (String)sb.toString(), (String)(clazz.getClassName() + ".c"), (String)config.getClangTriple());){
                    module.link(module2);
                    for (org.robovm.llvm.Function f1 : module2.getFunctions()) {
                        String name = f1.getName();
                        org.robovm.llvm.Function f2 = module.getFunctionByName(name);
                        if (!Symbols.isBridgeCSymbol(name) && !Symbols.isCallbackCSymbol(name) && !Symbols.isCallbackInnerCSymbol(name)) continue;
                        f2.setLinkage(org.robovm.llvm.binding.Linkage.PrivateLinkage);
                        if (!Symbols.isCallbackInnerCSymbol(name)) continue;
                        f2.removeAttribute(Attribute.NoInlineAttribute);
                        f2.addAttribute(Attribute.AlwaysInlineAttribute);
                    }
                }
            }
            try (PassManager passManager = ClassCompiler.createPassManager(config);){
                passManager.run(module);
            }
            if (config.isDumpIntermediates()) {
                File bcFile = config.getBcFile(clazz);
                bcFile.getParentFile().mkdirs();
                module.writeBitcode(bcFile);
            }
            String triple = config.getTriple();
            Target target = Target.lookupTarget((String)triple);
            try (TargetMachine targetMachine = target.createTargetMachine(triple, config.getArch().getLlvmCpu(), null, (CodeGenOptLevel)(config.isDebug() ? CodeGenOptLevel.CodeGenLevelNone : null), RelocMode.RelocPIC, null);){
                ModuleBuilder linesMb;
                targetMachine.setAsmVerbosityDefault(true);
                targetMachine.setFunctionSections(true);
                targetMachine.setDataSections(true);
                targetMachine.getOptions().setNoFramePointerElim(true);
                targetMachine.getOptions().setPositionIndependentExecutable(!config.isDebug());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(262144);
                targetMachine.emit(module, (OutputStream)byteArrayOutputStream, CodeGenFileType.AssemblyFile);
                byte[] asm = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.reset();
                ClassCompiler.patchAsmWithFunctionSizes(config, clazz, new ByteArrayInputStream(asm), byteArrayOutputStream);
                asm = byteArrayOutputStream.toByteArray();
                if (config.isDumpIntermediates()) {
                    File sFile = config.getSFile(clazz);
                    sFile.getParentFile().mkdirs();
                    FileUtils.writeByteArrayToFile((File)sFile, (byte[])asm);
                }
                oFile.getParentFile().mkdirs();
                ByteArrayOutputStream oFileBytes = new ByteArrayOutputStream();
                targetMachine.assemble(asm, clazz.getClassName(), (OutputStream)oFileBytes);
                new HfsCompressor().compress(oFile, oFileBytes.toByteArray(), config);
                ModuleBuilder debugInfoMb = null;
                try (ObjectFile objectFile = ObjectFile.load((File)oFile);){
                    for (CompilerPlugin plugin : config.getCompilerPlugins()) {
                        plugin.afterObjectFile(config, clazz, oFile, objectFile);
                    }
                    linesMb = ClassCompiler.buildLineNumberData(config, clazz, objectFile);
                    if (config.isDebug()) {
                        debugInfoMb = ClassCompiler.buildDebugInfoData(config, clazz, objectFile);
                    }
                }
                if (linesMb != null) {
                    File linesLlFile = config.isDumpIntermediates() ? config.getLinesLlFile(clazz) : null;
                    File linesOFile = config.getLinesOFile(clazz);
                    ClassCompiler.createObjectFileFromData(config, context, targetMachine, linesMb, clazz.getClassName() + ".lines", linesLlFile, linesOFile);
                } else {
                    File linesOFile = config.getLinesOFile(clazz);
                    if (linesOFile.exists()) {
                        linesOFile.delete();
                    }
                }
                if (debugInfoMb != null) {
                    File debugInfoLlFile = config.isDumpIntermediates() ? config.getDebugInfoLlFile(clazz) : null;
                    File debugInfoOFile = config.getDebugInfoOFile(clazz);
                    ClassCompiler.createObjectFileFromData(config, context, targetMachine, debugInfoMb, clazz.getClassName() + ".debuginfo", debugInfoLlFile, debugInfoOFile);
                } else {
                    File debugInfoOFile = config.getDebugInfoOFile(clazz);
                    if (debugInfoOFile.exists()) {
                        debugInfoOFile.delete();
                    }
                }
            }
        }
        catch (Throwable t) {
            if (oFile.exists()) {
                oFile.delete();
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new CompilerException(t);
        }
    }

    private static void createObjectFileFromData(Config config, Context context, TargetMachine targetMachine, ModuleBuilder mb, String dataName, File llFile, File oFile) throws IOException, InterruptedException {
        byte[] data = mb.build().toString().getBytes(StandardCharsets.UTF_8);
        if (llFile != null) {
            llFile.getParentFile().mkdirs();
            FileUtils.writeByteArrayToFile((File)llFile, (byte[])data);
        }
        try (Module module = Module.parseIR((Context)context, (byte[])data, (String)dataName);){
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            targetMachine.emit(module, (OutputStream)bytes, CodeGenFileType.ObjectFile);
            new HfsCompressor().compress(oFile, bytes.toByteArray(), config);
        }
    }

    private static ModuleBuilder buildLineNumberData(Config config, Clazz clazz, ObjectFile objectFile) {
        ModuleBuilder linesMb = null;
        String symbolPrefix = config.getOs().getFamily() == OS.Family.darwin ? "_" : "";
        symbolPrefix = symbolPrefix + "[J]";
        for (Symbol symbol : objectFile.getSymbols()) {
            int addressOffsetSize;
            List lineInfos;
            if (symbol.getSize() <= 0L || !symbol.getName().startsWith(symbolPrefix) || (lineInfos = objectFile.getLineInfos(symbol)).isEmpty()) continue;
            Collections.sort(lineInfos, new Comparator<LineInfo>(){

                @Override
                public int compare(LineInfo o1, LineInfo o2) {
                    return Long.compare(o1.getAddress(), o2.getAddress());
                }
            });
            long baseAddress = symbol.getAddress();
            int firstLineNumber = ((LineInfo)lineInfos.get(0)).getLineNumber();
            long maxAddressOffset = 0L;
            long maxLineOffset = 0L;
            for (LineInfo lineInfo : lineInfos) {
                maxAddressOffset = Math.max(maxAddressOffset, lineInfo.getAddress() - baseAddress);
                maxLineOffset = Math.max(maxLineOffset, (long)(lineInfo.getLineNumber() - firstLineNumber));
            }
            int n = (maxAddressOffset & 0xFFFFFFFFFFFFFF00L) == 0L ? 1 : (addressOffsetSize = (maxAddressOffset & 0xFFFFFFFFFFFF0000L) == 0L ? 2 : 4);
            int lineOffsetSize = (maxLineOffset & 0xFFFFFFFFFFFFFF00L) == 0L ? 1 : ((maxLineOffset & 0xFFFFFFFFFFFF0000L) == 0L ? 2 : 4);
            int addressOffsetTableSize = addressOffsetSize * (lineInfos.size() - 1);
            int addressOffsetPadding = lineOffsetSize - (addressOffsetTableSize & lineOffsetSize - 1) & lineOffsetSize - 1;
            addressOffsetTableSize += addressOffsetPadding;
            int flags = 0;
            flags = addressOffsetSize - 1;
            flags <<= 2;
            flags |= lineOffsetSize - 1;
            flags <<= 28;
            StructureConstantBuilder builder = new StructureConstantBuilder();
            builder.add(new IntegerConstant(flags |= lineInfos.size() - 1 & 0xFFFFFFF)).add(new IntegerConstant(firstLineNumber));
            for (LineInfo lineInfo : lineInfos.subList(1, lineInfos.size())) {
                if (addressOffsetSize == 1) {
                    builder.add(new IntegerConstant((byte)(lineInfo.getAddress() - baseAddress)));
                    continue;
                }
                if (addressOffsetSize == 2) {
                    builder.add(new IntegerConstant((short)(lineInfo.getAddress() - baseAddress)));
                    continue;
                }
                builder.add(new IntegerConstant((int)(lineInfo.getAddress() - baseAddress)));
            }
            for (int i = 0; i < addressOffsetPadding; ++i) {
                builder.add(new IntegerConstant(0));
            }
            for (LineInfo lineInfo : lineInfos.subList(1, lineInfos.size())) {
                if (lineOffsetSize == 1) {
                    builder.add(new IntegerConstant((byte)(lineInfo.getLineNumber() - firstLineNumber)));
                    continue;
                }
                if (lineOffsetSize == 2) {
                    builder.add(new IntegerConstant((short)(lineInfo.getLineNumber() - firstLineNumber)));
                    continue;
                }
                builder.add(new IntegerConstant(lineInfo.getLineNumber() - firstLineNumber));
            }
            String methodName = symbol.getName().substring(symbol.getName().lastIndexOf(46) + 1);
            methodName = methodName.substring(0, methodName.indexOf(40));
            String methodDesc = symbol.getName().substring(symbol.getName().lastIndexOf(40));
            String linetableSymbol = Symbols.linetableSymbol(clazz.getInternalName(), methodName, methodDesc);
            if (linesMb == null) {
                linesMb = new ModuleBuilder();
            }
            linesMb.addGlobal(new Global(linetableSymbol, builder.build(), true));
        }
        if (linesMb != null) {
            ClassCompiler.emitBitcodeSection(config, linesMb);
        }
        return linesMb;
    }

    private static ModuleBuilder buildDebugInfoData(Config config, Clazz clazz, ObjectFile objectFile) throws IOException {
        ModuleBuilder debugInfoMb = null;
        DebuggerDebugObjectFileInfo.RawData debugInfo = clazz.getAttachment(DebuggerDebugObjectFileInfo.RawData.class);
        if (debugInfo != null) {
            byte[] debugDataBytes = DebuggerDebugObjectFileInfo.dumpDebugInfo((DebuggerDebugObjectFileInfo.RawData)debugInfo);
            String debugInfoSymbol = Symbols.debugInfoSymbol(clazz.getInternalName());
            debugInfoMb = new ModuleBuilder();
            Global debugInfoSymbolGlobal = new Global(debugInfoSymbol, new ByteArrayConstant(debugDataBytes), true);
            debugInfoMb.addGlobal(debugInfoSymbolGlobal);
            ArrayList<ConstantBitcast> usedGlobalValues = new ArrayList<ConstantBitcast>();
            usedGlobalValues.add(new ConstantBitcast(debugInfoSymbolGlobal.ref(), Type.I8_PTR));
            ArrayConstant usedValuesArr = new ArrayConstant(new ArrayType(usedGlobalValues.size(), Type.I8_PTR), usedGlobalValues.toArray(new Value[0]));
            Global usedGlobal = new Global("llvm.used", Linkage.appending, usedValuesArr, false, "llvm.metadata");
            debugInfoMb.addGlobal(usedGlobal);
            if (config.isDumpIntermediates()) {
                File f = new File(config.getDebugInfoOFile(clazz).getAbsolutePath() + ".dump");
                DebuggerDebugObjectFileInfo.dumpDebugInfoAsText((DebuggerDebugObjectFileInfo.RawData)debugInfo, (File)f);
            }
        }
        return debugInfoMb;
    }

    private static PassManager createPassManager(Config config) {
        PassManager passManager = new PassManager();
        if (config.isDebug()) {
            passManager.addAlwaysInlinerPass();
        } else {
            try (PassManagerBuilder builder = new PassManagerBuilder();){
                builder.setSetOptLevel(2);
                builder.setDisableTailCalls(true);
                builder.useAlwaysInliner(true);
                builder.populateModulePassManager(passManager);
            }
        }
        return passManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void patchAsmWithFunctionSizes(Config config, Clazz clazz, InputStream inStream, OutputStream outStream) throws IOException {
        String labelPrefix = config.getOs().getFamily() == OS.Family.darwin ? "_" : "";
        String localLabelPrefix = config.getOs().getFamily() == OS.Family.darwin ? "L" : ".L";
        HashSet<String> functionNames = new HashSet<String>();
        for (SootMethod method : clazz.getSootClass().getMethods()) {
            if (method.isAbstract()) continue;
            String name = labelPrefix + Symbols.methodSymbol(method);
            functionNames.add(name);
        }
        String infoStructLabel = labelPrefix + Symbols.infoStructSymbol(clazz.getInternalName());
        Pattern methodImplPattern = Pattern.compile("\\s*\\.(?:quad|long)\\s+\"?(" + Pattern.quote(labelPrefix + Symbols.methodSymbolPrefix(clazz.getInternalName())) + "[^\\s\"]+)\"?.*");
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            in = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));
            out = new BufferedWriter(new OutputStreamWriter(outStream, StandardCharsets.UTF_8));
            String line = null;
            String currentFunction = null;
            while ((line = in.readLine()) != null) {
                if (currentFunction == null) {
                    out.write(line);
                    out.write(10);
                    int colon = line.indexOf(58);
                    if (colon == -1) continue;
                    String label = line.substring(0, colon);
                    if (label.startsWith("\"") && label.endsWith("\"")) {
                        label = label.substring(1, label.length() - 1);
                    }
                    if (functionNames.contains(label)) {
                        currentFunction = label;
                        continue;
                    }
                    if (!label.equals(infoStructLabel)) continue;
                    break;
                }
                if (line.trim().equals(".cfi_endproc") || line.trim().startsWith(".section") || line.trim().startsWith(".globl")) {
                    out.write("\"");
                    out.write(localLabelPrefix);
                    out.write(currentFunction);
                    out.write("_end\":\n\n");
                    currentFunction = null;
                    out.write(line);
                    out.write(10);
                    continue;
                }
                out.write(line);
                out.write(10);
            }
            while ((line = in.readLine()) != null) {
                String functionName;
                out.write(line);
                out.write(10);
                Matcher matcher = methodImplPattern.matcher(line);
                if (!matcher.matches() || !functionNames.contains(functionName = matcher.group(1))) continue;
                line = in.readLine();
                if (line.contains(String.valueOf(28036591))) {
                    out.write("\t.long\t");
                    out.write("\"" + localLabelPrefix + functionName + "_end\" - \"" + functionName + "\"");
                    out.write(10);
                    continue;
                }
                out.write(line);
                out.write(10);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Writer)out);
    }

    private void reset() {
        this.output.reset();
        this.sootClass = null;
        this.mb = null;
        this.trampolines = null;
        this.catches = null;
        this.classFields = null;
        this.instanceFields = null;
        this.classType = null;
        this.instanceType = null;
    }

    /*
     * WARNING - void declaration
     */
    private void compile(Clazz clazz, OutputStream out) throws IOException {
        void var6_19;
        MethodInfo mi;
        ClazzInfo ci = clazz.resetClazzInfo();
        this.mb = new ModuleBuilder();
        for (CompilerPlugin compilerPlugin : this.config.getCompilerPlugins()) {
            compilerPlugin.helloClass(this.config, clazz);
        }
        for (CompilerPlugin compilerPlugin : this.config.getCompilerPlugins()) {
            compilerPlugin.beforeClass(this.config, clazz, this.mb);
        }
        this.javaMethodCompiler.reset(clazz);
        this.bridgeMethodCompiler.reset(clazz);
        this.callbackMethodCompiler.reset(clazz);
        this.nativeMethodCompiler.reset(clazz);
        this.structMemberMethodCompiler.reset(clazz);
        this.globalValueMethodCompiler.reset(clazz);
        this.sootClass = clazz.getSootClass();
        this.trampolines = new HashMap<Trampoline, List<SootMethod>>();
        this.catches = new HashSet<String>();
        this.classFields = Types.getClassFields(this.config.getOs(), this.config.getArch(), this.sootClass);
        this.instanceFields = Types.getInstanceFields(this.config.getOs(), this.config.getArch(), this.sootClass);
        this.classType = Types.getClassType(this.mb, this.config.getOs(), this.config.getArch(), this.sootClass);
        this.instanceType = Types.getInstanceType(this.config.getOs(), this.config.getArch(), this.sootClass);
        this.attributesEncoder.encode(this.mb, this.sootClass);
        if (!this.sootClass.declaresMethodByName("<clinit>") && ClassCompiler.hasConstantValueTags(this.classFields)) {
            SootMethod clinit = new SootMethod("<clinit>", Collections.EMPTY_LIST, (soot.Type)VoidType.v(), 8);
            JimpleBody body = Jimple.v().newBody(clinit);
            clinit.setActiveBody((Body)body);
            body.getUnits().add((Unit)new JReturnVoidStmt());
            this.sootClass.addMethod(clinit);
        }
        if (Types.isStruct(this.sootClass)) {
            SootMethod _sizeOf = new SootMethod("_sizeOf", Collections.EMPTY_LIST, (soot.Type)IntType.v(), 260);
            this.sootClass.addMethod(_sizeOf);
            SootMethod sizeOf = new SootMethod("sizeOf", Collections.EMPTY_LIST, (soot.Type)IntType.v(), 265);
            this.sootClass.addMethod(sizeOf);
            SootMethod sootMethod = new SootMethod("$attr$stretMetadata", Collections.EMPTY_LIST, (soot.Type)IntType.v(), 265);
            this.sootClass.addMethod(sootMethod);
            SootMethod offset = new SootMethod("offsetOf", Collections.singletonList(IntType.v()), (soot.Type)IntType.v(), 265);
            this.sootClass.addMethod(offset);
        }
        this.mb.addInclude(this.getClass().getClassLoader().getResource(String.format("header-%s-%s.ll", new Object[]{this.config.getOs().getFamily(), this.config.getArch().getCpuArch()})));
        this.mb.addInclude(this.getClass().getClassLoader().getResource("header.ll"));
        this.mb.addFunction(this.createLdcClass());
        this.mb.addFunction(this.createLdcClassWrapper());
        Function allocator = this.createAllocator();
        this.mb.addFunction(allocator);
        this.mb.addFunction(this.createClassInitWrapperFunction(allocator.ref()));
        for (SootField sootField : this.sootClass.getFields()) {
            Function getter = ClassCompiler.createFieldGetter(sootField, this.classFields, this.classType, this.instanceFields, this.instanceType);
            Function setter = ClassCompiler.createFieldSetter(sootField, this.classFields, this.classType, this.instanceFields, this.instanceType);
            this.mb.addFunction(getter);
            this.mb.addFunction(setter);
            if (!sootField.isStatic() || sootField.isPrivate()) continue;
            this.mb.addFunction(this.createClassInitWrapperFunction(getter.ref()));
            if (sootField.isFinal()) continue;
            this.mb.addFunction(this.createClassInitWrapperFunction(setter.ref()));
        }
        ci.initClassInfo();
        for (SootMethod sootMethod : this.sootClass.getMethods()) {
            for (CompilerPlugin compilerPlugin : this.config.getCompilerPlugins()) {
                compilerPlugin.beforeMethod(this.config, clazz, sootMethod, this.mb);
            }
            String name = sootMethod.getName();
            Function function = null;
            if (Annotations.hasBridgeAnnotation(sootMethod)) {
                function = !this.isJvmSyntheticBridgeMethod(sootMethod) ? this.bridgeMethod(sootMethod) : this.method(sootMethod);
            } else if (Annotations.hasGlobalValueAnnotation(sootMethod)) {
                function = this.globalValueMethod(sootMethod);
            } else if (Types.isStruct(this.sootClass) && ("_sizeOf".equals(name) || "sizeOf".equals(name) || "offsetOf".equals(name) || "$attr$stretMetadata".equals(name) || Annotations.hasStructMemberAnnotation(sootMethod))) {
                function = this.structMember(sootMethod);
            } else if (sootMethod.isNative()) {
                function = this.nativeMethod(sootMethod);
            } else if (this.objcMethodCompiler.willCompile(sootMethod)) {
                function = this.objcPublishMethod(sootMethod);
            } else if (!sootMethod.isAbstract()) {
                function = this.method(sootMethod);
            }
            if (Annotations.hasCallbackAnnotation(sootMethod)) {
                this.callbackMethod(sootMethod);
            }
            if (!(name.equals("<clinit>") || name.equals("<init>") || sootMethod.isPrivate() || sootMethod.isStatic() || Modifier.isFinal((int)sootMethod.getModifiers()) || Modifier.isFinal((int)this.sootClass.getModifiers()))) {
                this.createLookupFunction(sootMethod);
            }
            if (sootMethod.isStatic() && !name.equals("<clinit>")) {
                String fnName = sootMethod.isSynchronized() ? Symbols.synchronizedWrapperSymbol(sootMethod) : Symbols.methodSymbol(sootMethod);
                FunctionRef fn = new FunctionRef(fnName, Types.getFunctionType(sootMethod));
                this.mb.addFunction(this.createClassInitWrapperFunction(fn));
            }
            for (CompilerPlugin compilerPlugin : this.config.getCompilerPlugins()) {
                if (function == null) continue;
                compilerPlugin.afterMethod(this.config, clazz, sootMethod, this.mb, function);
            }
        }
        for (Trampoline trampoline : this.trampolines.keySet()) {
            HashSet<String> deps = new HashSet<String>();
            HashSet<Triple<String, String, String>> mDeps = new HashSet<Triple<String, String, String>>();
            this.trampolineResolver.compile(this.mb, clazz, trampoline, deps, mDeps);
            for (SootMethod m : this.trampolines.get(trampoline)) {
                mi = ci.getMethod(m.getName(), Types.getDescriptor(m));
                mi.addClassDependencies(deps, false);
                mi.addInvokeMethodDependencies(mDeps, false);
            }
        }
        Map<SootMethod, Set<SootMethod>> overriddenMethods = this.getOverriddenMethods(this.sootClass);
        for (SootMethod from : overriddenMethods.keySet()) {
            Iterator<CompilerPlugin> mi2 = ci.getMethod(from.getName(), Types.getDescriptor(from));
            for (SootMethod to : overriddenMethods.get(from)) {
                ((MethodInfo)((Object)mi2)).addSuperMethodDependency(Types.getInternalName(to.getDeclaringClass()), to.getName(), Types.getDescriptor(to), false);
            }
        }
        if (this.sootClass.hasSuperclass()) {
            for (SootClass interfaze : this.getImmediateInterfaces(this.sootClass)) {
                for (SootMethod m : interfaze.getMethods()) {
                    if (m.isStatic()) continue;
                    try {
                        this.sootClass.getMethod(m.getName(), m.getParameterTypes());
                    }
                    catch (RuntimeException e) {
                        SootMethod superMethod = null;
                        SootClass sc = this.sootClass.getSuperclass();
                        while (sc.hasSuperclass()) {
                            try {
                                SootMethod candidate = sc.getMethod(m.getName(), m.getParameterTypes());
                                if (!candidate.isStatic()) {
                                    superMethod = candidate;
                                    break;
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                            sc = sc.getSuperclass();
                        }
                        if (superMethod == null) continue;
                        ci.addSuperMethodDependency(Types.getInternalName(superMethod.getDeclaringClass()), superMethod.getName(), Types.getDescriptor(superMethod), false);
                    }
                }
            }
        }
        Object var6_16 = null;
        try {
            if (!this.sootClass.isInterface()) {
                this.config.getVTableCache().get(this.sootClass);
            }
            Global global = new Global(Symbols.infoStructSymbol(clazz.getInternalName()), Linkage.weak, this.createClassInfoStruct());
        }
        catch (IllegalArgumentException e) {
            Global global = new Global(Symbols.infoStructSymbol(clazz.getInternalName()), Type.I8_PTR, true);
        }
        this.mb.addGlobal((Global)var6_19);
        this.mb.addAlias(new Alias(var6_19.getName() + "_i8ptr", Linkage._private, new ConstantBitcast(var6_19.ref(), Type.I8_PTR)));
        Function infoFn = FunctionBuilder.infoStruct(this.sootClass);
        infoFn.add(new Ret(new ConstantBitcast(var6_19.ref(), Type.I8_PTR_PTR)));
        this.mb.addFunction(infoFn);
        for (CompilerPlugin compilerPlugin : this.config.getCompilerPlugins()) {
            compilerPlugin.afterClass(this.config, clazz, this.mb);
        }
        ClassCompiler.emitBitcodeSection(this.config, this.mb);
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        this.mb.build().write(writer);
        writer.flush();
        ci.setCatchNames(this.catches);
        ci.addClassDependency("java/lang/Object", false);
        if (this.sootClass.hasSuperclass() && !this.sootClass.isInterface()) {
            ci.addClassDependency(Types.getInternalName(this.sootClass.getSuperclass()), false);
        }
        for (SootClass iface : this.sootClass.getInterfaces()) {
            ci.addClassDependency(Types.getInternalName(iface), false);
        }
        for (SootField f : this.sootClass.getFields()) {
            ClassCompiler.addClassDependencyIfNeeded(clazz, f.getType(), false);
        }
        for (SootMethod m : this.sootClass.getMethods()) {
            mi = ci.getMethod(m.getName(), Types.getDescriptor(m));
            ClassCompiler.addClassDependencyIfNeeded(clazz, mi, m.getReturnType(), false);
            List paramTypes = m.getParameterTypes();
            for (soot.Type type : paramTypes) {
                ClassCompiler.addClassDependencyIfNeeded(clazz, mi, type, false);
            }
        }
        ci.addClassDependencies(this.attributesEncoder.getDependencies(), false);
        ci.addClassDependencies(this.catches, false);
        for (Trampoline t : this.trampolines.keySet()) {
            if (t instanceof Checkcast) {
                ci.addCheckcast(t.getTarget());
                continue;
            }
            if (t instanceof Instanceof) {
                ci.addInstanceof(t.getTarget());
                continue;
            }
            if (!(t instanceof Invokevirtual) && !(t instanceof Invokeinterface)) continue;
            ci.addInvoke(t.getTarget() + "." + ((Invoke)t).getMethodName() + ((Invoke)t).getMethodDesc());
        }
        clazz.saveClazzInfo();
    }

    static void emitBitcodeSection(Config config, ModuleBuilder mb) {
        if (mb != null && config.shouldEmitBitcode()) {
            mb.addGlobal(new Global("robovm.bitcode", Linkage.appending, new IntegerConstant(0), true, "__LLVM,__asm"));
        }
    }

    private boolean isJvmSyntheticBridgeMethod(SootMethod method) {
        int BRIDGE = 64;
        int SYNTHETIC = 4096;
        return !method.isAbstract() && !method.isNative() && (method.getModifiers() & 0x40) == 64 && (method.getModifiers() & 0x1000) == 4096;
    }

    private static void addClassDependencyIfNeeded(Clazz clazz, soot.Type type, boolean weak) {
        if (type instanceof RefLikeType) {
            ClassCompiler.addClassDependencyIfNeeded(clazz, Types.getDescriptor(type), weak);
        }
    }

    private static void addClassDependencyIfNeeded(Clazz clazz, String desc, boolean weak) {
        if (!(Types.isPrimitive(desc) || Types.isArray(desc) && Types.isPrimitiveBaseType(desc))) {
            String internalName;
            String string = internalName = Types.isArray(desc) ? Types.getBaseType(desc) : Types.getInternalNameFromDescriptor(desc);
            if (!clazz.getInternalName().equals(internalName)) {
                clazz.getClazzInfo().addClassDependency(internalName, weak);
            }
        }
    }

    private static void addClassDependencyIfNeeded(Clazz clazz, MethodInfo mi, soot.Type type, boolean weak) {
        if (type instanceof RefLikeType) {
            ClassCompiler.addClassDependencyIfNeeded(clazz, mi, Types.getDescriptor(type), weak);
        }
    }

    private static void addClassDependencyIfNeeded(Clazz clazz, MethodInfo mi, String desc, boolean weak) {
        if (!(Types.isPrimitive(desc) || Types.isArray(desc) && Types.isPrimitiveBaseType(desc))) {
            String internalName;
            String string = internalName = Types.isArray(desc) ? Types.getBaseType(desc) : Types.getInternalNameFromDescriptor(desc);
            if (!clazz.getInternalName().equals(internalName)) {
                mi.addClassDependency(internalName, weak);
            }
        }
    }

    private Map<SootMethod, Set<SootMethod>> getOverriddenMethods(SootClass sc) {
        HashMap<SootMethod, Set<SootMethod>> result = new HashMap<SootMethod, Set<SootMethod>>();
        for (SootMethod m : sc.getMethods()) {
            if (m.isStatic() || m.isPrivate() || m.getName().equals("<init>")) continue;
            result.put(m, new HashSet());
        }
        this.findOverriddenSuperMethods(sc, sc, result);
        return result;
    }

    private void findOverriddenSuperMethods(SootClass childClass, SootClass sc, Map<SootMethod, Set<SootMethod>> result) {
        if (sc != childClass) {
            for (SootMethod superMethod : sc.getMethods()) {
                if (superMethod.isStatic() || superMethod.isPrivate() || superMethod.getName().equals("<init>") || !superMethod.isPublic() && !superMethod.isProtected() && !childClass.getPackageName().equals(sc.getPackageName())) continue;
                for (SootMethod childMethod : result.keySet()) {
                    if (!childMethod.getName().equals(superMethod.getName()) || !childMethod.getParameterTypes().equals(superMethod.getParameterTypes())) continue;
                    result.get(childMethod).add(superMethod);
                }
            }
        }
        for (SootClass interfaze : sc.getInterfaces()) {
            this.findOverriddenSuperMethods(childClass, interfaze, result);
        }
        if (sc.hasSuperclass()) {
            this.findOverriddenSuperMethods(childClass, sc.getSuperclass(), result);
        }
    }

    private Set<SootClass> getImmediateInterfaces(SootClass sc) {
        HashSet<SootClass> result = new HashSet<SootClass>();
        result.addAll((Collection<SootClass>)sc.getInterfaces());
        for (SootClass interfaze : sc.getInterfaces()) {
            result.addAll(this.getImmediateInterfaces(interfaze));
        }
        return result;
    }

    private void createLookupFunction(SootMethod m) {
        Function function = FunctionBuilder.lookup(m, true);
        this.mb.addFunction(function);
        Variable reserved0 = function.newVariable(Type.I8_PTR_PTR);
        function.add(new Getelementptr(reserved0, (Value)function.getParameterRef(0), 0, 4));
        Variable reserved1 = function.newVariable(Type.I8_PTR_PTR);
        function.add(new Getelementptr(reserved1, (Value)function.getParameterRef(0), 0, 5));
        function.add(new Store(this.getString(m.getName()), reserved0.ref()));
        function.add(new Store(this.getString(Types.getDescriptor(m)), reserved1.ref()));
        if (!this.sootClass.isInterface()) {
            int vtableIndex = 0;
            try {
                VTable vtable = this.config.getVTableCache().get(this.sootClass);
                vtableIndex = vtable.getEntry(m).getIndex();
            }
            catch (IllegalArgumentException vtable) {
                // empty catch block
            }
            Value classPtr = Functions.call(function, (Value)Functions.OBJECT_CLASS, function.getParameterRef(1));
            Value vtablePtr = Functions.call(function, (Value)Functions.CLASS_VITABLE, classPtr);
            Variable funcPtrPtr = function.newVariable(Type.I8_PTR_PTR);
            function.add(new Getelementptr(funcPtrPtr, vtablePtr, 0, 1, vtableIndex));
            Variable funcPtr = function.newVariable(Type.I8_PTR);
            function.add(new Load(funcPtr, funcPtrPtr.ref()));
            Variable f = function.newVariable(function.getType());
            function.add(new Bitcast(f, funcPtr.ref(), f.getType()));
            Value result = Functions.tailcall(function, f.ref(), function.getParameterRefs());
            function.add(new Ret(result));
        } else {
            ITable itable = this.config.getITableCache().get(this.sootClass);
            ITable.Entry entry = itable.getEntry(m);
            ArrayList<Value> args = new ArrayList<Value>();
            args.add(function.getParameterRef(0));
            args.add(ClassCompiler.getInfoStruct(function, this.sootClass));
            args.add(function.getParameterRef(1));
            args.add(new IntegerConstant(entry.getIndex()));
            Value fptr = Functions.call(function, (Value)Functions.BC_LOOKUP_INTERFACE_METHOD_IMPL, args);
            Variable f = function.newVariable(function.getType());
            function.add(new Bitcast(f, fptr, f.getType()));
            Value result = Functions.tailcall(function, f.ref(), function.getParameterRefs());
            function.add(new Ret(result));
        }
    }

    private Constant createVTableStruct() {
        VTable vtable = this.config.getVTableCache().get(this.sootClass);
        String name = Symbols.vtableSymbol(Types.getInternalName(this.sootClass));
        for (VTable.Entry entry : vtable.getEntries()) {
            FunctionRef fref = entry.getFunctionRef();
            if (fref == null || this.mb.hasSymbol(fref.getName())) continue;
            this.mb.addFunctionDeclaration(new FunctionDeclaration(fref));
        }
        Global vtableStruct = new Global(name, Linkage._private, vtable.getStruct(), true);
        this.mb.addGlobal(vtableStruct);
        return new ConstantBitcast(vtableStruct.ref(), Type.I8_PTR);
    }

    private Constant createITableStruct() {
        ITable itable = this.config.getITableCache().get(this.sootClass);
        String name = Symbols.itableSymbol(Types.getInternalName(this.sootClass));
        Global itableStruct = new Global(name, Linkage._private, itable.getStruct(), true);
        this.mb.addGlobal(itableStruct);
        return new ConstantBitcast(itableStruct.ref(), Type.I8_PTR);
    }

    private Constant createITablesStruct() {
        if (!this.sootClass.isInterface()) {
            HashSet<SootClass> interfaces = new HashSet<SootClass>();
            ClassCompiler.collectInterfaces(this.sootClass, interfaces);
            ArrayList<ConstantBitcast> tables = new ArrayList<ConstantBitcast>();
            int i = 0;
            for (SootClass ifs : interfaces) {
                ITable itable = this.config.getITableCache().get(ifs);
                if (itable.size() <= 0) continue;
                String name = Symbols.itableSymbol(Types.getInternalName(this.sootClass), i++);
                String typeInfoName = Symbols.typeInfoSymbol(Types.getInternalName(ifs));
                if (!this.mb.hasSymbol(typeInfoName)) {
                    this.mb.addGlobal(new Global(typeInfoName, Linkage.external, Type.I8_PTR, true));
                }
                Global itableStruct = new Global(name, Linkage._private, new StructureConstantBuilder().add(this.mb.getGlobalRef(typeInfoName)).add(itable.getStruct(this.mb, this.sootClass)).build(), true);
                this.mb.addGlobal(itableStruct);
                tables.add(new ConstantBitcast(itableStruct.ref(), Type.I8_PTR));
            }
            if (tables.isEmpty()) {
                return new NullConstant(Type.I8_PTR);
            }
            Global itablesStruct = new Global(Symbols.itablesSymbol(Types.getInternalName(this.sootClass)), Linkage._private, new StructureConstantBuilder().add(new IntegerConstant((short)tables.size())).add((Value)tables.get(0)).add(new ArrayConstantBuilder(Type.I8_PTR).add(tables).build()).build());
            this.mb.addGlobal(itablesStruct);
            return new ConstantBitcast(itablesStruct.ref(), Type.I8_PTR);
        }
        return new NullConstant(Type.I8_PTR);
    }

    private StructureConstant createClassInfoStruct() {
        int flags = 0;
        if (Modifier.isPublic((int)this.sootClass.getModifiers())) {
            flags |= 1;
        }
        if (Modifier.isFinal((int)this.sootClass.getModifiers())) {
            flags |= 2;
        }
        if (Modifier.isInterface((int)this.sootClass.getModifiers())) {
            flags |= 4;
        }
        if (Modifier.isAbstract((int)this.sootClass.getModifiers())) {
            flags |= 8;
        }
        if ((this.sootClass.getModifiers() & 0x1000) > 0) {
            flags |= 0x10;
        }
        if (Modifier.isAnnotation((int)this.sootClass.getModifiers())) {
            flags |= 0x20;
        }
        if (Modifier.isEnum((int)this.sootClass.getModifiers())) {
            flags |= 0x40;
        }
        if (this.attributesEncoder.classHasAttributes()) {
            flags |= 0x80;
        }
        if (ClassCompiler.hasFinalizer(this.sootClass)) {
            flags |= 0x400;
        }
        StructureConstantBuilder header = new StructureConstantBuilder();
        header.add(new NullConstant(Type.I8_PTR));
        header.add(new IntegerConstant(flags));
        header.add(this.getString(Types.getInternalName(this.sootClass)));
        if (this.sootClass.declaresMethod("<clinit>", Collections.emptyList(), (soot.Type)VoidType.v())) {
            SootMethod method = this.sootClass.getMethod("<clinit>", Collections.emptyList(), (soot.Type)VoidType.v());
            header.add(new FunctionRef(Symbols.methodSymbol(method), Types.getFunctionType(method)));
        } else {
            header.add(new NullConstant(Type.I8_PTR));
        }
        this.mb.addGlobal(new Global(Symbols.typeInfoSymbol(Types.getInternalName(this.sootClass)), Linkage.external, Type.I8_PTR, true));
        header.add(new GlobalRef(Symbols.typeInfoSymbol(Types.getInternalName(this.sootClass)), Type.I8_PTR));
        if (!this.sootClass.isInterface()) {
            header.add(this.createVTableStruct());
        } else {
            header.add(this.createITableStruct());
        }
        header.add(this.createITablesStruct());
        header.add(Types.sizeof(this.classType));
        header.add(Types.sizeof(this.instanceType));
        if (!this.instanceFields.isEmpty()) {
            header.add(Types.offsetof(this.instanceType, 1, 1));
        } else {
            header.add(Types.sizeof(this.instanceType));
        }
        header.add(new IntegerConstant((short)ClassCompiler.countReferences(this.classFields)));
        header.add(new IntegerConstant((short)ClassCompiler.countReferences(this.instanceFields)));
        StructureConstantBuilder body = new StructureConstantBuilder();
        body.add(new IntegerConstant((short)this.sootClass.getInterfaceCount()));
        body.add(new IntegerConstant((short)this.sootClass.getFieldCount()));
        body.add(new IntegerConstant((short)this.sootClass.getMethodCount()));
        if (!this.sootClass.isInterface()) {
            body.add(this.getStringOrNull(this.sootClass.hasSuperclass() ? Types.getInternalName(this.sootClass.getSuperclass()) : null));
        }
        if (this.attributesEncoder.classHasAttributes()) {
            body.add(new ConstantBitcast(this.attributesEncoder.getClassAttributes().ref(), Type.I8_PTR));
        }
        for (SootClass s : this.sootClass.getInterfaces()) {
            body.add(this.getString(Types.getInternalName(s)));
        }
        for (SootField f : this.sootClass.getFields()) {
            int index;
            flags = 0;
            soot.Type t = f.getType();
            if (t instanceof PrimType) {
                if (t.equals(BooleanType.v())) {
                    flags |= 8;
                } else if (t.equals(ByteType.v())) {
                    flags |= 1;
                } else if (t.equals(ShortType.v())) {
                    flags |= 7;
                } else if (t.equals(CharType.v())) {
                    flags |= 2;
                } else if (t.equals(IntType.v())) {
                    flags |= 5;
                } else if (t.equals(LongType.v())) {
                    flags |= 6;
                } else if (t.equals(FloatType.v())) {
                    flags |= 4;
                } else if (t.equals(DoubleType.v())) {
                    flags |= 3;
                }
                flags <<= 12;
            }
            if (Modifier.isPublic((int)f.getModifiers())) {
                flags |= 1;
            } else if (Modifier.isPrivate((int)f.getModifiers())) {
                flags |= 2;
            } else if (Modifier.isProtected((int)f.getModifiers())) {
                flags |= 3;
            }
            if (Modifier.isStatic((int)f.getModifiers())) {
                flags |= 4;
            }
            if (Modifier.isFinal((int)f.getModifiers())) {
                flags |= 8;
            }
            if (Modifier.isVolatile((int)f.getModifiers())) {
                flags |= 0x10;
            }
            if (Modifier.isTransient((int)f.getModifiers())) {
                flags |= 0x20;
            }
            if ((f.getModifiers() & 0x1000) > 0) {
                flags |= 0x40;
            }
            if (Modifier.isEnum((int)f.getModifiers())) {
                flags |= 0x80;
            }
            if (this.attributesEncoder.fieldHasAttributes(f)) {
                flags |= 0x100;
            }
            body.add(new IntegerConstant((short)flags));
            body.add(this.getString(f.getName()));
            if (!(t instanceof PrimType)) {
                body.add(this.getString(Types.getDescriptor(f)));
            }
            if (f.isStatic()) {
                index = this.classFields.indexOf(f);
                body.add(Types.offsetof(this.classType, 1, index, 1));
            } else {
                index = this.instanceFields.indexOf(f);
                body.add(Types.offsetof(this.instanceType, 1, 1 + index, 1));
            }
            if (!this.attributesEncoder.fieldHasAttributes(f)) continue;
            body.add(new ConstantBitcast(this.attributesEncoder.getFieldAttributes(f).ref(), Type.I8_PTR));
        }
        VTable vtable = !this.sootClass.isInterface() ? this.config.getVTableCache().get(this.sootClass) : null;
        ITable itable = this.sootClass.isInterface() ? this.config.getITableCache().get(this.sootClass) : null;
        for (SootMethod m : this.sootClass.getMethods()) {
            Object entry;
            soot.Type t = m.getReturnType();
            flags = 0;
            if (Modifier.isPublic((int)m.getModifiers())) {
                flags |= 1;
            } else if (Modifier.isPrivate((int)m.getModifiers())) {
                flags |= 2;
            } else if (Modifier.isProtected((int)m.getModifiers())) {
                flags |= 3;
            }
            if (Modifier.isStatic((int)m.getModifiers())) {
                flags |= 4;
            }
            if (Modifier.isFinal((int)m.getModifiers())) {
                flags |= 8;
            }
            if (Modifier.isSynchronized((int)m.getModifiers())) {
                flags |= 0x10;
            }
            if ((m.getModifiers() & 0x40) > 0) {
                flags |= 0x20;
            }
            if ((m.getModifiers() & 0x80) > 0) {
                flags |= 0x40;
            }
            if (Modifier.isNative((int)m.getModifiers()) && !Types.isStruct(this.sootClass) && !Annotations.hasStructMemberAnnotation(m)) {
                flags |= 0x80;
            }
            if (Modifier.isAbstract((int)m.getModifiers())) {
                flags |= 0x100;
            }
            if (Modifier.isStrictFP((int)m.getModifiers())) {
                flags |= 0x200;
            }
            if ((m.getModifiers() & 0x1000) > 0) {
                flags |= 0x400;
            }
            if (this.attributesEncoder.methodHasAttributes(m)) {
                flags |= 0x800;
            }
            if (Annotations.hasBridgeAnnotation(m) && !this.isJvmSyntheticBridgeMethod(m) || Annotations.hasGlobalValueAnnotation(m)) {
                flags |= 0x1000;
            }
            if (Annotations.hasCallbackAnnotation(m)) {
                flags |= 0x2000;
            }
            if ((t instanceof PrimType || t == VoidType.v()) && m.getParameterCount() == 0) {
                flags |= 0x4000;
            }
            body.add(new IntegerConstant((short)flags));
            IntegerConstant viTableIndex = new IntegerConstant(-1);
            if (vtable != null) {
                entry = vtable.getEntry(m);
                if (entry != null) {
                    viTableIndex = new IntegerConstant((short)((VTable.Entry)entry).getIndex());
                }
            } else {
                entry = itable.getEntry(m);
                if (entry != null) {
                    viTableIndex = new IntegerConstant((short)((ITable.Entry)entry).getIndex());
                }
            }
            body.add(viTableIndex);
            body.add(this.getString(m.getName()));
            if ((flags & 0x4000) > 0) {
                int desc = 0;
                if (t.equals(BooleanType.v())) {
                    desc = 8;
                } else if (t.equals(ByteType.v())) {
                    desc = 1;
                } else if (t.equals(ShortType.v())) {
                    desc = 7;
                } else if (t.equals(CharType.v())) {
                    desc = 2;
                } else if (t.equals(IntType.v())) {
                    desc = 5;
                } else if (t.equals(LongType.v())) {
                    desc = 6;
                } else if (t.equals(FloatType.v())) {
                    desc = 4;
                } else if (t.equals(DoubleType.v())) {
                    desc = 3;
                } else if (t.equals(VoidType.v())) {
                    desc = 9;
                }
                body.add(new IntegerConstant((byte)desc));
            } else {
                body.add(this.getString(Types.getDescriptor(m)));
            }
            if (this.attributesEncoder.methodHasAttributes(m)) {
                body.add(new ConstantBitcast(this.attributesEncoder.getMethodAttributes(m).ref(), Type.I8_PTR));
            }
            if (!m.isAbstract()) {
                body.add(new ConstantBitcast(new FunctionRef(Symbols.methodSymbol(m), Types.getFunctionType(m)), Type.I8_PTR));
                body.add(new IntegerConstant(28036591));
                if (m.isSynchronized()) {
                    body.add(new ConstantBitcast(new FunctionRef(Symbols.synchronizedWrapperSymbol(m), Types.getFunctionType(m)), Type.I8_PTR));
                }
                if ((flags & 0x80) == 0) {
                    Global linetableGlobal = new Global(Symbols.linetableSymbol(m), Linkage.weak, new IntegerConstant(-1));
                    this.mb.addGlobal(linetableGlobal);
                    body.add(linetableGlobal.ref());
                }
            }
            if (Annotations.hasBridgeAnnotation(m) && !this.isJvmSyntheticBridgeMethod(m)) {
                if (!Annotations.readBooleanElem(Annotations.getAnnotation((Host)m, "Lorg/robovm/rt/bro/annotation/Bridge;"), "dynamic", false)) {
                    body.add(new GlobalRef(Symbols.bridgePtrSymbol(m), Type.I8_PTR));
                } else {
                    body.add(new NullConstant(Type.I8_PTR));
                }
            } else if (Annotations.hasGlobalValueAnnotation(m)) {
                body.add(new GlobalRef(Symbols.globalValuePtrSymbol(m), Type.I8_PTR));
            }
            if (!Annotations.hasCallbackAnnotation(m)) continue;
            body.add(new AliasRef(Symbols.callbackPtrSymbol(m), Type.I8_PTR));
        }
        StructureConstant infoStruct = new StructureConstantBuilder().add(header.build()).add(body.build()).build("InfoStruct");
        this.mb.addType(infoStruct.getType());
        return infoStruct;
    }

    private Function compileMethod(AbstractMethodCompiler methodCompiler, SootMethod method) {
        Function fn = methodCompiler.compile(this.mb, method);
        for (Trampoline t : methodCompiler.getTrampolines()) {
            List<SootMethod> l = this.trampolines.get(t);
            if (l == null) {
                l = new ArrayList<SootMethod>();
                this.trampolines.put(t, l);
            }
            l.add(method);
        }
        this.catches.addAll(methodCompiler.getCatches());
        return fn;
    }

    private Function nativeMethod(SootMethod method) {
        return this.compileMethod(this.nativeMethodCompiler, method);
    }

    private Function bridgeMethod(SootMethod method) {
        return this.compileMethod(this.bridgeMethodCompiler, method);
    }

    private Function callbackMethod(SootMethod method) {
        return this.compileMethod(this.callbackMethodCompiler, method);
    }

    private Function structMember(SootMethod method) {
        return this.compileMethod(this.structMemberMethodCompiler, method);
    }

    private Function globalValueMethod(SootMethod method) {
        return this.compileMethod(this.globalValueMethodCompiler, method);
    }

    private Function objcPublishMethod(SootMethod method) {
        return this.compileMethod(this.objcMethodCompiler, method);
    }

    private Function method(SootMethod method) {
        return this.compileMethod(this.javaMethodCompiler, method);
    }

    private Function createAllocator() {
        Function fn = FunctionBuilder.allocator(this.sootClass);
        Value info = ClassCompiler.getInfoStruct(fn, this.sootClass);
        Value result = Functions.call(fn, (Value)Functions.BC_ALLOCATE, fn.getParameterRef(0), info);
        fn.add(new Ret(result));
        return fn;
    }

    private Function createLdcClass() {
        Function fn = FunctionBuilder.ldcInternal(this.sootClass);
        Value info = ClassCompiler.getInfoStruct(fn, this.sootClass);
        Value result = Functions.call(fn, (Value)Functions.BC_LDC_CLASS, fn.getParameterRef(0), info);
        fn.add(new Ret(result));
        return fn;
    }

    private Function createLdcClassWrapper() {
        Function fn = FunctionBuilder.ldcExternal(this.sootClass);
        Value info = ClassCompiler.getInfoStruct(fn, this.sootClass);
        Value result = Functions.call(fn, (Value)Functions.LDC_CLASS_WRAPPER, fn.getParameterRef(0), info);
        fn.add(new Ret(result));
        return fn;
    }

    static Function createFieldGetter(SootField field, List<SootField> classFields, StructureType classType, List<SootField> instanceFields, StructureType instanceType) {
        Function fn = FunctionBuilder.getter(field);
        return ClassCompiler.createFieldGetter(fn, field, classFields, classType, instanceFields, instanceType);
    }

    static Function createFieldGetter(Function fn, SootField field, List<SootField> classFields, StructureType classType, List<SootField> instanceFields, StructureType instanceType) {
        Value fieldPtr = null;
        fieldPtr = field.isStatic() ? ClassCompiler.getClassFieldPtr(fn, field, classFields, classType) : ClassCompiler.getInstanceFieldPtr(fn, fn.getParameterRef(1), field, instanceFields, instanceType);
        Variable result = fn.newVariable(Types.getType(field.getType()));
        if (Modifier.isVolatile((int)field.getModifiers())) {
            fn.add(new Fence(Ordering.seq_cst));
            if (LongType.v().equals((Object)field.getType())) {
                fn.add(new Load(result, fieldPtr, false, Ordering.monotonic, 8));
            } else {
                fn.add(new Load(result, fieldPtr));
            }
        } else {
            fn.add(new Load(result, fieldPtr));
        }
        fn.add(new Ret(new VariableRef(result)));
        return fn;
    }

    static Function createFieldSetter(SootField field, List<SootField> classFields, StructureType classType, List<SootField> instanceFields, StructureType instanceType) {
        Function fn = FunctionBuilder.setter(field);
        return ClassCompiler.createFieldSetter(fn, field, classFields, classType, instanceFields, instanceType);
    }

    static Function createFieldSetter(Function fn, SootField field, List<SootField> classFields, StructureType classType, List<SootField> instanceFields, StructureType instanceType) {
        Value fieldPtr = null;
        VariableRef value = null;
        if (field.isStatic()) {
            fieldPtr = ClassCompiler.getClassFieldPtr(fn, field, classFields, classType);
            value = fn.getParameterRef(1);
        } else {
            fieldPtr = ClassCompiler.getInstanceFieldPtr(fn, fn.getParameterRef(1), field, instanceFields, instanceType);
            value = fn.getParameterRef(2);
        }
        if (Modifier.isVolatile((int)field.getModifiers()) || !field.isStatic() && Modifier.isFinal((int)field.getModifiers())) {
            if (LongType.v().equals((Object)field.getType())) {
                fn.add(new Store(value, fieldPtr, false, Ordering.monotonic, 8));
            } else {
                fn.add(new Store(value, fieldPtr));
            }
            fn.add(new Fence(Ordering.seq_cst));
        } else {
            fn.add(new Store(value, fieldPtr));
        }
        fn.add(new Ret());
        return fn;
    }

    private Function createClassInitWrapperFunction(FunctionRef targetFn) {
        Function fn = FunctionBuilder.clinitWrapper(targetFn);
        Value info = ClassCompiler.getInfoStruct(fn, this.sootClass);
        Variable infoHeader = fn.newVariable(new PointerType(new StructureType(Type.I8_PTR, Type.I32)));
        fn.add(new Bitcast(infoHeader, info, infoHeader.getType()));
        Variable infoHeaderFlags = fn.newVariable(new PointerType(Type.I32));
        fn.add(new Getelementptr(infoHeaderFlags, (Value)infoHeader.ref(), 0, 1));
        Variable flags = fn.newVariable(Type.I32);
        fn.add(new Load(flags, infoHeaderFlags.ref()));
        Variable initializedFlag = fn.newVariable(Type.I32);
        fn.add(new And(initializedFlag, flags.ref(), new IntegerConstant(512)));
        Variable initialized = fn.newVariable(Type.I1);
        fn.add(new Icmp(initialized, Icmp.Condition.eq, initializedFlag.ref(), new IntegerConstant(512)));
        Label trueLabel = new Label();
        Label falseLabel = new Label();
        fn.add(new Br(initialized.ref(), fn.newBasicBlockRef(trueLabel), fn.newBasicBlockRef(falseLabel)));
        fn.newBasicBlock(trueLabel);
        Value result = Functions.call(fn, (Value)targetFn, fn.getParameterRefs());
        fn.add(new Ret(result));
        fn.newBasicBlock(falseLabel);
        Functions.call(fn, (Value)Functions.BC_INITIALIZE_CLASS, fn.getParameterRef(0), info);
        fn.add(new Br(fn.newBasicBlockRef(trueLabel)));
        return fn;
    }

    private static int countReferences(List<SootField> l) {
        int count = 0;
        for (SootField f : l) {
            if (!(f.getType() instanceof RefLikeType)) continue;
            ++count;
        }
        return count;
    }

    private static void collectInterfaces(SootClass clazz, Set<SootClass> interfaces) {
        if (clazz.hasSuperclass()) {
            ClassCompiler.collectInterfaces(clazz.getSuperclass(), interfaces);
        }
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        for (SootClass sc : clazz.getInterfaces()) {
            ClassCompiler.collectInterfaces(sc, interfaces);
        }
    }

    private static boolean hasConstantValueTags(List<SootField> classFields) {
        for (SootField field : classFields) {
            for (Tag tag : field.getTags()) {
                if (!(tag instanceof ConstantValueTag)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasFinalizer(SootClass clazz) {
        if (clazz.isInterface() || !clazz.hasSuperclass()) {
            return false;
        }
        return clazz.declaresMethod("finalize", Collections.emptyList(), (soot.Type)VoidType.v());
    }

    private Constant getString(String string) {
        return this.mb.getString(string);
    }

    private Constant getStringOrNull(String string) {
        return this.mb.getStringOrNull(string);
    }

    static Value getClassFieldPtr(Function f, SootField field, List<SootField> classFields, StructureType classType) {
        Value info = ClassCompiler.getInfoStruct(f, field.getDeclaringClass());
        Variable base = f.newVariable(Type.I8_PTR);
        f.add(new Load(base, info));
        return Types.getFieldPtr(f, new VariableRef(base), Types.offsetof(classType, 1, classFields.indexOf(field), 1), Types.getType(field.getType()));
    }

    static Value getInfoStruct(Function f, SootClass sootClass) {
        return Functions.call(f, (Value)FunctionBuilder.infoStruct(sootClass).ref(), new Value[0]);
    }

    static Value getInstanceFieldPtr(Function f, Value base, SootField field, List<SootField> instanceFields, StructureType instanceType) {
        return Types.getFieldPtr(f, base, Types.offsetof(instanceType, 1, 1 + instanceFields.indexOf(field), 1), Types.getType(field.getType()));
    }
}

