/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.robovm.compiler.Strings;
import org.robovm.compiler.llvm.Alias;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.ConstantGetelementptr;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionDeclaration;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.GlobalRef;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.Metadata;
import org.robovm.compiler.llvm.Module;
import org.robovm.compiler.llvm.NamedMetadata;
import org.robovm.compiler.llvm.NullConstant;
import org.robovm.compiler.llvm.StringConstant;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.UnnamedMetadata;
import org.robovm.compiler.llvm.UserType;

public class ModuleBuilder {
    private final List<URL> includes = new ArrayList<URL>();
    private final List<Global> globals = new ArrayList<Global>();
    private final List<Alias> aliases = new ArrayList<Alias>();
    private final List<Function> functions = new ArrayList<Function>();
    private final List<FunctionDeclaration> functionDeclarations = new ArrayList<FunctionDeclaration>();
    private final List<UserType> types = new ArrayList<UserType>();
    private final List<String> asm = new ArrayList<String>();
    private final Map<String, NamedMetadata> namedMetadata = new TreeMap<String, NamedMetadata>();
    private final Map<Integer, UnnamedMetadata> unnamedMetadata = new TreeMap<Integer, UnnamedMetadata>();
    private final Set<String> symbols = new HashSet<String>();
    private int counter = 0;
    private Map<String, Global> strings = new HashMap<String, Global>();

    public void addInclude(URL resource) {
        this.includes.add(resource);
    }

    public void addFunction(Function f) {
        if (this.symbols.contains(f.getName())) {
            throw new IllegalArgumentException("Symbol " + f.getName() + " already defined");
        }
        this.functions.add(f);
        this.symbols.add(f.getName());
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    public boolean hasSymbol(String name) {
        return this.symbols.contains(name);
    }

    public void addGlobal(Global global) {
        if (this.symbols.contains(global.getName())) {
            throw new IllegalArgumentException("Symbol " + global.getName() + " already defined");
        }
        this.globals.add(global);
        this.symbols.add(global.getName());
    }

    public GlobalRef getGlobalRef(String name) {
        for (Global g : this.globals) {
            if (!name.equals(g.getName())) continue;
            return g.ref();
        }
        throw new IllegalArgumentException("Global with name " + name + " not found");
    }

    public void addNamedMetadata(NamedMetadata md) {
        if (this.namedMetadata.containsKey(md.getName())) {
            throw new IllegalArgumentException("Named metadata " + md.getName() + " already defined");
        }
        this.namedMetadata.put(md.getName(), md);
    }

    public UnnamedMetadata newUnnamedMetadata() {
        return this.newUnnamedMetadata(null);
    }

    public UnnamedMetadata newUnnamedMetadata(Metadata value) {
        UnnamedMetadata md = new UnnamedMetadata(this.unnamedMetadata.size(), value);
        this.unnamedMetadata.put(md.getIndex(), md);
        return md;
    }

    public Global newGlobal(Constant value) {
        return this.newGlobal(value, false);
    }

    public Global newGlobal(Constant value, boolean constant) {
        Global global = new Global("g" + this.counter++, Linkage._private, value, constant);
        this.addGlobal(global);
        return global;
    }

    public void addAlias(Alias alias) {
        if (this.symbols.contains(alias.getName())) {
            throw new IllegalArgumentException("Symbol " + alias.getName() + " already defined");
        }
        this.aliases.add(alias);
        this.symbols.add(alias.getName());
    }

    public void addType(UserType type) {
        if (!type.hasAlias()) {
            throw new IllegalArgumentException("Expected type alias !");
        }
        this.types.add(type);
    }

    public void addAsm(String s) {
        this.asm.add(s);
    }

    public void addFunctionDeclaration(FunctionDeclaration fd) {
        if (this.symbols.contains(fd.getName())) {
            throw new IllegalArgumentException("Symbol " + fd.getName() + " already defined");
        }
        this.functionDeclarations.add(fd);
        this.symbols.add(fd.getName());
    }

    public Constant getString(String string) {
        Global g = this.strings.get(string);
        if (g == null) {
            byte[] modUtf8 = Strings.stringToModifiedUtf8Z(string);
            g = new Global(Strings.getStringVarName(modUtf8), Linkage.weak, new StringConstant(modUtf8), true);
            this.addGlobal(g);
            this.strings.put(string, g);
        }
        return new ConstantGetelementptr(new GlobalRef(g), 0, 0);
    }

    public Constant getStringOrNull(String string) {
        if (string == null) {
            return new NullConstant(Type.I8_PTR);
        }
        return this.getString(string);
    }

    public Module build() {
        return new Module(this.includes, this.types, this.globals, this.aliases, this.functionDeclarations, this.asm, this.functions, this.namedMetadata.values(), this.unnamedMetadata.values());
    }
}

