/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.HashMap;
import org.robovm.compiler.Bro;
import org.robovm.compiler.BroMethodCompiler;
import org.robovm.compiler.Functions;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.Bitcast;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.Getelementptr;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.Inttoptr;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Load;
import org.robovm.compiler.llvm.PackedStructureType;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Switch;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Unreachable;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;
import org.robovm.compiler.llvm.VectorStructureType;
import soot.SootMethod;
import soot.VoidType;

public class StructMemberMethodCompiler
extends BroMethodCompiler {
    public static final String STRUCT_ATTRIBUTES_METHOD = "$attr$stretMetadata";
    private StructureType structType;

    public StructMemberMethodCompiler(Config config) {
        super(config);
    }

    @Override
    public void reset(Clazz clazz) {
        super.reset(clazz);
        this.structType = null;
        if (Types.isStruct(this.sootClass)) {
            this.structType = this.getStructType(this.sootClass);
        }
    }

    @Override
    protected Function doCompile(ModuleBuilder moduleBuilder, SootMethod method) {
        if ("_sizeOf".equals(method.getName()) || "sizeOf".equals(method.getName())) {
            return this.structSizeOf(moduleBuilder, method);
        }
        if ("offsetOf".equals(method.getName())) {
            return this.structOffsetOf(moduleBuilder, method);
        }
        if (STRUCT_ATTRIBUTES_METHOD.equals(method.getName())) {
            return this.stretMeta(moduleBuilder, method);
        }
        return this.structMember(moduleBuilder, method);
    }

    private Function structSizeOf(ModuleBuilder moduleBuilder, SootMethod method) {
        Function fn = this.createMethodFunction(method);
        moduleBuilder.addFunction(fn);
        fn.add(new Ret(Types.sizeof(this.structType)));
        return fn;
    }

    private Function structOffsetOf(ModuleBuilder moduleBuilder, SootMethod method) {
        Function fn = this.createMethodFunction(method);
        moduleBuilder.addFunction(fn);
        int[] offsets = this.getStructMemberOffsets(this.structType);
        if (offsets.length > 0) {
            Label[] switchLabels = new Label[offsets.length];
            HashMap<IntegerConstant, BasicBlockRef> targets = new HashMap<IntegerConstant, BasicBlockRef>();
            for (int idx = 0; idx < offsets.length; ++idx) {
                switchLabels[idx] = new Label(idx);
                targets.put(new IntegerConstant(idx), fn.newBasicBlockRef(switchLabels[idx]));
            }
            VariableRef idxValue = fn.getParameterRef(1);
            Label def = new Label(-1);
            fn.add(new Switch(idxValue, fn.newBasicBlockRef(def), targets));
            for (int idx = 0; idx < offsets.length; ++idx) {
                fn.newBasicBlock(switchLabels[idx]);
                fn.add(new Ret(new IntegerConstant(offsets[idx])));
            }
            fn.newBasicBlock(def);
        }
        Functions.call(fn, (Value)Functions.BC_THROW_ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION, fn.getParameterRef(0), new IntegerConstant(offsets.length), fn.getParameterRef(1));
        fn.add(new Unreachable());
        return fn;
    }

    private Function stretMeta(ModuleBuilder moduleBuilder, SootMethod method) {
        Function fn = this.createMethodFunction(method);
        moduleBuilder.addFunction(fn);
        fn.add(new Ret(new IntegerConstant(this.structType.getAttributes())));
        return fn;
    }

    private Function structMember(ModuleBuilder moduleBuilder, SootMethod method) {
        Function function = this.createMethodFunction(method);
        moduleBuilder.addFunction(function);
        Variable handleI64 = function.newVariable(Type.I64);
        function.add(new Load(handleI64, Types.getFieldPtr(function, function.getParameterRef(1), Types.offsetof(new StructureType(Types.DATA_OBJECT, new StructureType(Type.I64)), 1, 0), Type.I64)));
        Variable handlePtr = function.newVariable(new PointerType(this.structType));
        function.add(new Inttoptr(handlePtr, handleI64.ref(), handlePtr.getType()));
        int offset = Bro.getStructMemberOffset(method) + this.structType.getOwnMembersOffset();
        Type memberType = this.getStructMemberType(method);
        Variable memberPtr = function.newVariable(new PointerType(memberType));
        Type structMemberType = this.structType.getTypeAt(offset);
        if (!memberType.equals(structMemberType)) {
            Variable tmp = function.newVariable(new PointerType(structMemberType));
            if (this.structType instanceof PackedStructureType && structMemberType instanceof PackedStructureType) {
                PackedStructureType packedMember = (PackedStructureType)structMemberType;
                if (packedMember.getTypeCount() != 2 || !packedMember.getTypeAt(0).equals(memberType)) {
                    throw new IllegalArgumentException("Internal error: method and struct member type missmatch. " + method);
                }
                function.add(new Getelementptr(tmp, (Value)handlePtr.ref(), 0, offset));
            } else if (this.structType instanceof VectorStructureType && ((VectorStructureType)this.structType).isVectorArray()) {
                function.add(new Getelementptr(tmp, (Value)handlePtr.ref(), 0, 0, offset));
            } else {
                function.add(new Getelementptr(tmp, (Value)handlePtr.ref(), 0, offset));
            }
            function.add(new Bitcast(memberPtr, tmp.ref(), memberPtr.getType()));
        } else if (this.structType instanceof VectorStructureType && ((VectorStructureType)this.structType).isVectorArray()) {
            function.add(new Getelementptr(memberPtr, (Value)handlePtr.ref(), 0, 0, offset));
        } else {
            function.add(new Getelementptr(memberPtr, (Value)handlePtr.ref(), 0, offset));
        }
        VariableRef env = function.getParameterRef(0);
        if (method.getParameterCount() == 0) {
            Value result = this.loadValueForGetter(method, function, memberType, memberPtr.ref(), function.getParameterRef(0), true, 2L);
            function.add(new Ret(result));
        } else {
            VariableRef value = function.getParameterRef(2);
            this.storeValueForSetter(method, function, memberType, memberPtr.ref(), env, value, 2L);
            if (method.getReturnType().equals(VoidType.v())) {
                function.add(new Ret());
            } else {
                function.add(new Ret(function.getParameterRef(1)));
            }
        }
        return function;
    }
}

