/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public final class Version
implements Comparable<Version> {
    public final int[] parts;
    public final int build;
    public final BuildType buildType;
    private static String versionString = null;
    private static Version version = null;
    private static String PROPERTIES_RESOURCE = "/META-INF/robovm/version.properties";

    public Version(BuildType buildType, int buildPart, int ... parts) {
        this.buildType = buildType;
        this.build = buildPart;
        this.parts = parts;
    }

    public Version(int ... parts) {
        this(BuildType.Release, 1, parts);
    }

    @Override
    public int compareTo(Version other) {
        int diff = this.buildType.compareTo(other.buildType);
        if (diff != 0) {
            return diff;
        }
        int commonPart = Math.min(this.parts.length, other.parts.length);
        for (int i = 0; i < commonPart; ++i) {
            diff = this.parts[i] - other.parts[i];
            if (diff == 0) continue;
            return diff;
        }
        diff = this.parts.length - other.parts.length;
        if (diff != 0) {
            return diff;
        }
        return this.build - other.build;
    }

    public int[] getParts() {
        return this.parts;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public int getMajor() {
        return this.parts[0];
    }

    public int getMinor() {
        return this.parts.length > 1 ? this.parts[1] : 0;
    }

    public int getRevision() {
        return this.parts.length > 2 ? this.parts[2] : 0;
    }

    public int getBuild() {
        return this.build;
    }

    public static Version parse(String v) {
        String buildPart = "";
        BuildType buildType = BuildType.Release;
        if (v.endsWith(BuildType.Snapshot.suffix)) {
            buildPart = "";
            v = v.substring(0, v.indexOf(BuildType.Snapshot.suffix));
            buildType = BuildType.Snapshot;
        } else if (v.contains(BuildType.Alpha.suffix)) {
            buildPart = v.substring(v.lastIndexOf(45) + 1);
            v = v.substring(0, v.indexOf(BuildType.Alpha.suffix));
            buildType = BuildType.Alpha;
        } else if (v.contains(BuildType.Beta.suffix)) {
            buildPart = v.substring(v.lastIndexOf(45) + 1);
            v = v.substring(0, v.indexOf(BuildType.Beta.suffix));
            buildType = BuildType.Beta;
        } else if (v.contains(BuildType.RC.suffix)) {
            buildPart = v.substring(v.lastIndexOf(45) + 1);
            v = v.substring(0, v.indexOf(BuildType.RC.suffix));
            buildType = BuildType.RC;
        }
        String[] tokens = v.split("\\.");
        int[] parts = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            parts[i] = Integer.parseInt(tokens[i]);
        }
        int build = buildPart.isEmpty() ? 0 : Integer.parseInt(buildPart);
        return new Version(buildType, build, parts);
    }

    public static Version parseOrNull(String v) {
        try {
            return Version.parse(v);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return StringUtils.join((int[])this.parts, (char)'.') + this.buildType.suffixWithBuild(this.build);
    }

    public static String getCompilerVersion() {
        String string;
        block9: {
            if (versionString != null) {
                return versionString;
            }
            InputStream is = Version.class.getResourceAsStream(PROPERTIES_RESOURCE);
            try {
                Properties props = new Properties();
                props.load(is);
                string = versionString = props.getProperty("version");
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return string;
    }

    public static boolean isOlderThan(String version, String otherVersion) {
        return Version.parse(version).compareTo(Version.parse(otherVersion)) < 0;
    }

    public static void main(String[] args) {
        System.out.println(Version.parse("1.0.0-alpha-01"));
    }

    static enum BuildType {
        Snapshot("-SNAPSHOT"),
        Alpha("-alpha-"),
        Beta("-beta-"),
        RC("-rc-"),
        Release(null);

        private final String suffix;

        private BuildType(String suffix) {
            this.suffix = suffix;
        }

        String suffixWithBuild(int build) {
            switch (this) {
                case Snapshot: {
                    return this.suffix;
                }
                case Alpha: 
                case Beta: 
                case RC: {
                    return this.suffix + build;
                }
            }
            return "";
        }
    }
}

