/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robovm.compiler.llvm.BasicBlock;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.FunctionAttribute;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.ParameterAttribute;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;
import org.robovm.compiler.llvm.Writable;

public class Function
implements Writable {
    private final String name;
    private final Linkage linkage;
    private final FunctionAttribute[] attributes;
    private final ParameterAttribute[][] parameterAttributes;
    private final String section;
    private final FunctionType type;
    private final Map<Label, BasicBlock> basicBlockMap = new HashMap<Label, BasicBlock>();
    private final List<BasicBlock> basicBlockList = new ArrayList<BasicBlock>();
    private final Map<String, Variable> variablesMap = new HashMap<String, Variable>();
    private int counter = 0;
    private final String[] parameterNames;

    public Function(Linkage linkage, FunctionAttribute[] attributes, String section, String name, FunctionType type, String ... parameterNames) {
        this.linkage = linkage;
        this.attributes = attributes;
        this.section = section;
        this.name = name;
        this.type = type;
        if (parameterNames == null || parameterNames.length == 0 && type.getParameterTypes().length > 0) {
            parameterNames = new String[type.getParameterTypes().length];
            for (int i = 0; i < parameterNames.length; ++i) {
                parameterNames[i] = "p" + i;
            }
        }
        this.parameterNames = parameterNames;
        this.parameterAttributes = new ParameterAttribute[type.getParameterTypes().length][];
    }

    public FunctionRef ref() {
        return new FunctionRef(this);
    }

    public String getName() {
        return this.name;
    }

    public FunctionType getType() {
        return this.type;
    }

    public VariableRef getParameterRef(int index) {
        return new VariableRef(this.parameterNames[index], this.type.getParameterTypes()[index]);
    }

    public VariableRef[] getParameterRefs() {
        VariableRef[] result = new VariableRef[this.parameterNames.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getParameterRef(i);
        }
        return result;
    }

    public String[] getParameterNames() {
        return (String[])this.parameterNames.clone();
    }

    public void setParameterAttributes(int paramIndex, ParameterAttribute ... attributes) {
        this.parameterAttributes[paramIndex] = (ParameterAttribute[])attributes.clone();
    }

    String getLabel(BasicBlock bb) {
        return "label" + this.basicBlockList.indexOf(bb);
    }

    String getLabel(BasicBlockRef ref) {
        return this.getLabel(this.basicBlockMap.get(ref.getLabel()));
    }

    public BasicBlock newBasicBlock(Label label) {
        BasicBlock block = this.basicBlockMap.get(label);
        if (block != null) {
            throw new IllegalArgumentException("BasicBlock with label " + label + " already exists");
        }
        block = new BasicBlock(this, label);
        this.basicBlockMap.put(label, block);
        this.basicBlockList.add(block);
        return block;
    }

    public BasicBlockRef newBasicBlockRef(Label label) {
        return new BasicBlockRef(this, label);
    }

    public BasicBlock getCurrentBasicBlock() {
        if (this.basicBlockList.isEmpty()) {
            return this.newBasicBlock(new Label());
        }
        return this.basicBlockList.get(this.basicBlockList.size() - 1);
    }

    public List<BasicBlock> getBasicBlocks() {
        return this.basicBlockList;
    }

    public BasicBlock getBasicBlock(Label label) {
        return this.basicBlockMap.get(label);
    }

    public Variable newVariable(Type type) {
        return this.newVariable("t" + this.counter++, type);
    }

    public Variable newVariable(String name, Type type) {
        if (this.variablesMap.containsKey(name)) {
            throw new IllegalArgumentException("Variable with name '" + name + "' already exists");
        }
        Variable v = new Variable(name, type);
        this.variablesMap.put(name, v);
        return v;
    }

    public BasicBlock getDefinedIn(VariableRef ref) {
        Variable var = new Variable(ref);
        for (BasicBlock bb : this.basicBlockList) {
            if (!bb.getWritesTo().contains(var)) continue;
            return bb;
        }
        throw new IllegalStateException("Variable " + var + " not defined");
    }

    public Instruction add(Instruction instruction) {
        this.getCurrentBasicBlock().add(instruction);
        return instruction;
    }

    public String getSignature() {
        String sig = this.type.getReturnType().toString() + " (";
        Type[] parameterTypes = this.type.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                sig = sig + ", ";
            }
            sig = sig + parameterTypes[i].toString();
            if (this.parameterAttributes[i] == null) continue;
            for (ParameterAttribute attrib : this.parameterAttributes[i]) {
                sig = sig + ' ';
                sig = sig + attrib.toString();
            }
        }
        if (this.type.isVarargs()) {
            sig = sig + ", ...";
        }
        sig = sig + ")";
        return sig;
    }

    @Override
    public void write(Writer writer) throws IOException {
        Type returnType = this.type.getReturnType();
        Type[] parameterTypes = this.type.getParameterTypes();
        writer.write("define ");
        if (this.linkage != null) {
            writer.write(this.linkage.toString());
            writer.write(32);
        }
        returnType.write(writer);
        writer.write(" @\"");
        writer.write(this.name);
        writer.write("\"(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                writer.write(", ");
            }
            parameterTypes[i].write(writer);
            if (this.parameterAttributes[i] != null) {
                ParameterAttribute[] parameterAttributeArray = this.parameterAttributes[i];
                int n = parameterAttributeArray.length;
                for (int j = 0; j < n; ++j) {
                    ParameterAttribute attrib = parameterAttributeArray[j];
                    writer.write(32);
                    writer.write(attrib.toString());
                }
            }
            writer.write(" %");
            writer.write(this.parameterNames[i]);
        }
        if (this.type.isVarargs()) {
            writer.write(", ...");
        }
        writer.write(")");
        if (this.attributes != null && this.attributes.length > 0) {
            for (FunctionAttribute attr : this.attributes) {
                writer.write(32);
                writer.write(attr.toString());
            }
        }
        if (this.section != null) {
            writer.write(" section \"");
            writer.write(this.section);
            writer.write(34);
        }
        writer.write(" {\n");
        for (BasicBlock bb : this.basicBlockList) {
            bb.write(writer);
        }
        writer.write("}\n");
    }

    public String toString() {
        return this.toString(this::write);
    }
}

