/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm.debug.dwarf;

import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.llvm.MetadataNode;
import org.robovm.compiler.llvm.MetadataNodeBuilder;
import org.robovm.compiler.llvm.debug.dwarf.DIBaseItem;
import org.robovm.compiler.llvm.debug.dwarf.DIHeader;

public class DICompositeType
extends DIBaseItem {
    private int typeTag;
    private String typeName;
    private int definitionLineNo;
    private int sizeInBits;
    private int allignmentInBits;
    private int offsetsInBits;
    private int flags;
    private int runtimeLangs;
    private DIBaseItem file;
    private DIBaseItem fileContext;
    private DIBaseItem derivedType;
    private DIBaseItem memberTypes;

    public DICompositeType(ModuleBuilder builder) {
        super(builder);
    }

    private MetadataNode build() {
        MetadataNodeBuilder builder = new MetadataNodeBuilder();
        builder.add(new DIHeader().add(this.typeTag).add(this.typeName != null ? this.typeName : "").add(this.definitionLineNo).add(this.sizeInBits).add(this.allignmentInBits).add(this.offsetsInBits).add(this.flags).add(this.runtimeLangs));
        builder.add(this.file != null ? this.file.get() : null);
        builder.add(this.fileContext != null ? this.fileContext.get() : null);
        builder.add(this.derivedType != null ? this.derivedType.get() : null);
        builder.add(this.memberTypes != null ? this.memberTypes.get() : null);
        builder.add(null);
        builder.add(null);
        builder.add(null);
        return builder.build();
    }

    public String toString() {
        return this.build().toString();
    }

    public DICompositeType setTypeTag(int typeTag) {
        this.typeTag = typeTag;
        return this;
    }

    public DICompositeType setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public DICompositeType setDefinitionLineNo(int definitionLineNo) {
        this.definitionLineNo = definitionLineNo;
        return this;
    }

    public DICompositeType setSizeInBits(int sizeInBits) {
        this.sizeInBits = sizeInBits;
        return this;
    }

    public DICompositeType setAllignmentInBits(int allignmentInBits) {
        this.allignmentInBits = allignmentInBits;
        return this;
    }

    public DICompositeType setOffsetsInBits(int offsetsInBits) {
        this.offsetsInBits = offsetsInBits;
        return this;
    }

    public DICompositeType setFlags(int flags) {
        this.flags = flags;
        return this;
    }

    public DICompositeType setRuntimeLangs(int runtimeLangs) {
        this.runtimeLangs = runtimeLangs;
        return this;
    }

    public DICompositeType setFile(DIBaseItem file) {
        this.file = file;
        return this;
    }

    public DICompositeType setFileContext(DIBaseItem fileContext) {
        this.fileContext = fileContext;
        return this;
    }

    public DICompositeType setDerivedType(DIBaseItem derivedType) {
        this.derivedType = derivedType;
        return this;
    }

    public DICompositeType setMemberTypes(DIBaseItem memberTypes) {
        this.memberTypes = memberTypes;
        return this;
    }
}

