/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.objc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;
import org.robovm.compiler.plugin.objc.TypeEncoder;
import org.robovm.compiler.util.generic.GenericArrayType;
import org.robovm.compiler.util.generic.ImplForArray;
import org.robovm.compiler.util.generic.ImplForType;
import org.robovm.compiler.util.generic.ListOfTypes;
import org.robovm.compiler.util.generic.ParameterizedType;
import org.robovm.compiler.util.generic.SootClassType;
import org.robovm.compiler.util.generic.SootMethodType;
import org.robovm.compiler.util.generic.SootTypeType;
import org.robovm.compiler.util.generic.TypeVariable;
import org.robovm.compiler.util.generic.WildcardType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.PrimType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.VoidType;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.Host;

public class ObjCBlockPlugin
extends AbstractCompilerPlugin {
    public static final String OBJC_PACKAGE = "org/robovm/objc";
    public static final String OBJC_ANNOTATIONS_PACKAGE = "org/robovm/objc/annotation";
    public static final String BLOCK = "Lorg/robovm/objc/annotation/Block;";
    public static final String TYPE_ENCODING = "Lorg/robovm/objc/annotation/TypeEncoding;";
    public static final String RUNNABLE_AS_OBJC_BLOCK_MARSHALER = "org/robovm/objc/RunnableAsObjCBlockMarshaler";
    static Pattern BLOCK_ANNOTATION_PATTERN = Pattern.compile("@[\\w\\d_]+\\s*");
    static Map<String, String> BLOCK_ANNOTATIONS = new HashMap<String, String>();
    private SootClass org_robovm_objc_ObjCBlock = null;
    private SootClass java_lang_Boolean = null;
    private SootClass java_lang_Byte = null;
    private SootClass java_lang_Short = null;
    private SootClass java_lang_Character = null;
    private SootClass java_lang_Integer = null;
    private SootClass java_lang_Long = null;
    private SootClass java_lang_Float = null;
    private SootClass java_lang_Double = null;
    private boolean initialized = false;
    private Config config;

    private void init() {
        if (this.initialized) {
            return;
        }
        SootResolver r = SootResolver.v();
        this.org_robovm_objc_ObjCBlock = r.makeClassRef("org.robovm.objc.ObjCBlock");
        this.java_lang_Boolean = r.makeClassRef("java.lang.Boolean");
        this.java_lang_Byte = r.makeClassRef("java.lang.Byte");
        this.java_lang_Short = r.makeClassRef("java.lang.Short");
        this.java_lang_Character = r.makeClassRef("java.lang.Character");
        this.java_lang_Integer = r.makeClassRef("java.lang.Integer");
        this.java_lang_Long = r.makeClassRef("java.lang.Long");
        this.java_lang_Float = r.makeClassRef("java.lang.Float");
        this.java_lang_Double = r.makeClassRef("java.lang.Double");
    }

    @Override
    public void beforeClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder) throws IOException {
        this.config = config;
        this.init();
        SootClass sootClass = clazz.getSootClass();
        if (!sootClass.isInterface()) {
            HashMap<String, Integer> blockTypeIds = new HashMap<String, Integer>();
            for (SootMethod method : sootClass.getMethods()) {
                int[] indexes;
                if ((!method.isNative() || !Annotations.hasBridgeAnnotation(method) && !Annotations.hasGlobalValueAnnotation(method)) && !Annotations.hasCallbackAnnotation(method) && !Annotations.hasStructMemberAnnotation(method) || (indexes = this.getBlockParameterIndexes(method)) == null && !Annotations.hasAnnotation((Host)method, BLOCK)) continue;
                this.transformMethod(config, clazz, method, indexes, blockTypeIds);
            }
        }
    }

    private int[] getBlockParameterIndexes(SootMethod method) {
        int[] indexes = null;
        int paramCount = method.getParameterCount();
        int idxCount = 0;
        for (int i = 0; i < paramCount; ++i) {
            if (!Annotations.hasParameterAnnotation(method, i, BLOCK)) continue;
            if (indexes == null) {
                indexes = new int[paramCount];
                Arrays.fill(indexes, -1);
            }
            indexes[idxCount++] = i;
        }
        return indexes;
    }

    private void transformMethod(Config config, Clazz clazz, SootMethod blockMethod, int[] blockParamIndexes, Map<String, Integer> blockTypeIds) throws IOException {
        SootMethodType blockMethodType = new SootMethodType(blockMethod);
        if (blockParamIndexes != null) {
            int idx;
            org.robovm.compiler.util.generic.Type[] genericParameterTypes = blockMethodType.getGenericParameterTypes();
            for (int i = 0; i < blockParamIndexes.length && (idx = blockParamIndexes[i]) != -1; ++i) {
                SootMethod targetMethod = ObjCBlockPlugin.getBlockTargetMethod(blockMethod, idx);
                org.robovm.compiler.util.generic.Type[] actualGenericTypes = ObjCBlockPlugin.resolveTargetMethodSignature(blockMethod, targetMethod, genericParameterTypes[idx]);
                soot.Type[] actualRawTypes = ObjCBlockPlugin.toRawTypes(actualGenericTypes);
                soot.Type[] unboxedTypes = this.unboxTypes(actualRawTypes);
                String[][] targetMethodAnnotations = ObjCBlockPlugin.parseTargetMethodAnnotations(targetMethod, Annotations.readStringElem(Annotations.getParameterAnnotation(blockMethod, idx, BLOCK), "value", ""));
                String marshaler = this.createBlockMarshaler(config, clazz, targetMethod, actualGenericTypes, actualRawTypes, unboxedTypes, blockTypeIds, targetMethodAnnotations);
                ObjCBlockPlugin.addMarshalerAnnotation(blockMethod, idx, marshaler);
            }
        }
        if (Annotations.hasAnnotation((Host)blockMethod, BLOCK)) {
            SootMethod targetMethod = ObjCBlockPlugin.getBlockTargetMethod(blockMethod);
            org.robovm.compiler.util.generic.Type[] actualGenericTypes = ObjCBlockPlugin.resolveTargetMethodSignature(blockMethod, targetMethod, blockMethodType.getGenericReturnType());
            soot.Type[] actualRawTypes = ObjCBlockPlugin.toRawTypes(actualGenericTypes);
            soot.Type[] unboxedTypes = this.unboxTypes(actualRawTypes);
            String[][] targetMethodAnnotations = ObjCBlockPlugin.parseTargetMethodAnnotations(targetMethod, Annotations.readStringElem(Annotations.getAnnotation((Host)blockMethod, BLOCK), "value", ""));
            String marshaler = this.createBlockMarshaler(config, clazz, targetMethod, actualGenericTypes, actualRawTypes, unboxedTypes, blockTypeIds, targetMethodAnnotations);
            ObjCBlockPlugin.addMarshalerAnnotation(blockMethod, marshaler);
        }
    }

    private static int parseAnnotations(SootMethod m, String originalValue, String value, TreeSet<String> values) {
        Matcher matcher = BLOCK_ANNOTATION_PATTERN.matcher(value);
        int pos = 0;
        while (matcher.find() && matcher.start() == pos) {
            String anno = BLOCK_ANNOTATIONS.get(matcher.group().trim());
            if (anno == null) {
                throw new CompilerException("Unsupported annotation \"" + matcher.group().trim() + "\" in @Block annotation value \"" + originalValue + "\" on method " + m);
            }
            values.add(anno);
            pos = matcher.end();
        }
        return pos;
    }

    protected static String[][] parseTargetMethodAnnotations(SootMethod m, String value) {
        return ObjCBlockPlugin.parseTargetMethodAnnotations(m, m.getParameterCount(), value);
    }

    protected static String[][] parseTargetMethodAnnotations(SootMethod m, int paramCount, String value) {
        String originalValue = value;
        value = value.trim();
        String[][] result = new String[paramCount + 1][];
        if (value.length() == 0) {
            Arrays.fill((Object[])result, new String[0]);
        } else {
            TreeSet<String> values = new TreeSet<String>();
            int pos = ObjCBlockPlugin.parseAnnotations(m, originalValue, value, values);
            result[0] = new String[values.size()];
            values.toArray(result[0]);
            if (pos < value.length()) {
                if (value.charAt(pos) != '(') {
                    throw new CompilerException("Error in @Block annotation value \"" + originalValue + "\" on method " + m + ". Expected '(' but got '" + value.charAt(pos) + "'.");
                }
                if (pos + 1 == value.length()) {
                    throw new CompilerException("Error in @Block annotation value \"" + originalValue + "\" on method " + m + ". Expected a ')' at end of value but got end of string.");
                }
                if ((value = value.substring(pos + 1).trim()).charAt(value.length() - 1) != ')') {
                    throw new CompilerException("Error in @Block annotation value \"" + originalValue + "\" on method " + m + ". Expected a ')' at end of value but got '" + value.charAt(value.length() - 1) + "'.");
                }
                if ((value = value.substring(0, value.length() - 1).trim()).length() > 0 || paramCount > 0) {
                    String[] parts = value.split(",", paramCount + 1);
                    if (parts.length != paramCount) {
                        throw new CompilerException("Error in @Block annotation value \"" + originalValue + "\" on method " + m + ". Expected " + paramCount + " parameters");
                    }
                    for (int i = 0; i < parts.length; ++i) {
                        String p = parts[i].trim();
                        pos = ObjCBlockPlugin.parseAnnotations(m, originalValue, p, values = new TreeSet());
                        if (pos != p.length()) {
                            throw new CompilerException("Error in @Block annotation value \"" + originalValue + "\" on method " + m + ". Expected a ',' after parameter " + (i + 1) + " but got '" + p.charAt(pos) + "'.");
                        }
                        result[i + 1] = new String[values.size()];
                        values.toArray(result[i + 1]);
                    }
                }
            }
        }
        return result;
    }

    static void addMarshalerAnnotation(SootMethod method, String marshalerName) {
        AnnotationTag annotationTag = new AnnotationTag("Lorg/robovm/rt/bro/annotation/Marshaler;", 1);
        annotationTag.addElem((AnnotationElem)new AnnotationClassElem("L" + marshalerName + ";", 'c', "value"));
        Annotations.addRuntimeVisibleAnnotation((Host)method, annotationTag);
    }

    static void addMarshalerAnnotation(SootMethod method, int paramIndex, String marshalerName) {
        AnnotationTag annotationTag = new AnnotationTag("Lorg/robovm/rt/bro/annotation/Marshaler;", 1);
        annotationTag.addElem((AnnotationElem)new AnnotationClassElem("L" + marshalerName + ";", 'c', "value"));
        Annotations.addRuntimeVisibleParameterAnnotation(method, paramIndex, annotationTag);
    }

    private String getBlockMarshalerName(Clazz clazz, int id) {
        return clazz.getInternalName() + "$$BlockMarshaler" + id;
    }

    private String createBlockMarshaler(Config config, Clazz clazz, SootMethod targetMethod, org.robovm.compiler.util.generic.Type[] actualGenericTypes, soot.Type[] actualRawTypes, soot.Type[] unboxedTypes, Map<String, Integer> blockTypeIds, String[][] targetMethodAnnotations) throws IOException {
        if (targetMethod.getDeclaringClass().getName().equals("java.lang.Runnable") && targetMethod.getName().equals("run")) {
            return RUNNABLE_AS_OBJC_BLOCK_MARSHALER;
        }
        String targetMethodKey = this.getTargetMethodKey(targetMethod, actualRawTypes, targetMethodAnnotations);
        Integer id = blockTypeIds.get(targetMethodKey);
        if (id != null) {
            return this.getBlockMarshalerName(clazz, id);
        }
        id = blockTypeIds.size();
        blockTypeIds.put(targetMethodKey, id);
        final String blockMarshalerName = this.getBlockMarshalerName(clazz, id);
        final String targetInterfaceName = Types.getInternalName(targetMethod.getDeclaringClass());
        Clazz templateMarshaler = config.getClazzes().load(RUNNABLE_AS_OBJC_BLOCK_MARSHALER);
        final HashSet<String> usedBoxMethods = new HashSet<String>();
        final HashSet<String> usedUnboxMethods = new HashSet<String>();
        ClassWriter cw = new ClassWriter(1);
        this.generateTargetMethod(blockMarshalerName, targetMethod, actualGenericTypes, actualRawTypes, unboxedTypes, usedBoxMethods, usedUnboxMethods, cw);
        this.generateBridgeMethod(actualGenericTypes, unboxedTypes, targetMethodAnnotations, cw);
        this.generateCallbackMethod(blockMarshalerName, targetMethod, actualGenericTypes, actualRawTypes, unboxedTypes, usedBoxMethods, usedUnboxMethods, targetMethodAnnotations, cw);
        ClassReader classReader = new ClassReader(templateMarshaler.getBytes());
        classReader.accept(new ClassVisitor(262144, (ClassVisitor)cw){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, blockMarshalerName, signature, superName, new String[]{targetInterfaceName});
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
            }

            public void visitSource(String source, String debug) {
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                switch (name) {
                    case "run": 
                    case "invoke": 
                    case "invoked": {
                        return null;
                    }
                    case "box": {
                        if (usedBoxMethods.contains(desc)) break;
                        return null;
                    }
                    case "unbox": {
                        if (usedUnboxMethods.contains(desc)) break;
                        return null;
                    }
                }
                desc = desc.replace("java/lang/Runnable", targetInterfaceName);
                signature = null;
                return new MethodVisitor(262144, super.visitMethod(access, name, desc, signature, exceptions)){

                    public void visitLdcInsn(Object cst) {
                        String internalName;
                        if (cst instanceof Type && ((Type)cst).getSort() == 10 && ObjCBlockPlugin.RUNNABLE_AS_OBJC_BLOCK_MARSHALER.equals(internalName = ((Type)cst).getInternalName())) {
                            cst = Type.getObjectType((String)blockMarshalerName);
                        }
                        super.visitLdcInsn(cst);
                    }

                    public void visitTypeInsn(int opcode, String type) {
                        if (ObjCBlockPlugin.RUNNABLE_AS_OBJC_BLOCK_MARSHALER.equals(type)) {
                            type = blockMarshalerName;
                        } else if ("java/lang/Runnable".equals(type)) {
                            type = targetInterfaceName;
                        }
                        super.visitTypeInsn(opcode, type);
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        if (ObjCBlockPlugin.RUNNABLE_AS_OBJC_BLOCK_MARSHALER.equals(owner)) {
                            owner = blockMarshalerName;
                        }
                        super.visitFieldInsn(opcode, owner, name, desc);
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        if (ObjCBlockPlugin.RUNNABLE_AS_OBJC_BLOCK_MARSHALER.equals(owner)) {
                            owner = blockMarshalerName;
                        }
                        super.visitMethodInsn(opcode, owner, name, desc);
                    }

                    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                    }

                    public void visitLineNumber(int line, Label start) {
                    }
                };
            }
        }, 0);
        cw.visitInnerClass(blockMarshalerName, clazz.getInternalName(), blockMarshalerName.substring(clazz.getInternalName().length() + 1), 9);
        cw.visitEnd();
        File f = clazz.getPath().getGeneratedClassFile(blockMarshalerName);
        FileUtils.writeByteArrayToFile((File)f, (byte[])cw.toByteArray());
        f.setLastModified(clazz.lastModified());
        return blockMarshalerName;
    }

    private void generateBridgeMethod(org.robovm.compiler.util.generic.Type[] actualGenericTypes, soot.Type[] unboxedTypes, String[][] targetMethodAnnotations, ClassWriter cw) {
        ArrayList<org.robovm.compiler.util.generic.Type> genericParamTypes = new ArrayList<org.robovm.compiler.util.generic.Type>();
        genericParamTypes.add(new SootTypeType((soot.Type)LongType.v()));
        genericParamTypes.add(new SootTypeType((soot.Type)this.org_robovm_objc_ObjCBlock.getType()));
        for (int i = 1; i < unboxedTypes.length; ++i) {
            org.robovm.compiler.util.generic.Type t = unboxedTypes[i] instanceof PrimType ? new SootTypeType(unboxedTypes[i]) : actualGenericTypes[i];
            genericParamTypes.add(t);
        }
        org.robovm.compiler.util.generic.Type genericReturnType = unboxedTypes[0] instanceof PrimType ? new SootTypeType(unboxedTypes[0]) : actualGenericTypes[0];
        ArrayList<soot.Type> rawParamTypes = new ArrayList<soot.Type>();
        rawParamTypes.add((soot.Type)LongType.v());
        rawParamTypes.add((soot.Type)this.org_robovm_objc_ObjCBlock.getType());
        rawParamTypes.addAll(Arrays.asList(unboxedTypes).subList(1, unboxedTypes.length));
        String name = "invoke";
        String signature = this.getGenericSignature(genericParamTypes, genericReturnType);
        String desc = Types.getDescriptor(rawParamTypes, unboxedTypes[0]);
        MethodVisitor mv = cw.visitMethod(266, name, desc, signature, null);
        AnnotationVisitor av = mv.visitAnnotation("Lorg/robovm/rt/bro/annotation/Bridge;", true);
        av.visit("dynamic", (Object)true);
        av.visitEnd();
        for (String s : targetMethodAnnotations[0]) {
            mv.visitAnnotation(s, true).visitEnd();
        }
        for (int i = 1; i < targetMethodAnnotations.length; ++i) {
            for (String s : targetMethodAnnotations[i]) {
                mv.visitParameterAnnotation(i + 1, s, true).visitEnd();
            }
        }
        mv.visitParameterAnnotation(0, "Lorg/robovm/rt/bro/annotation/Pointer;", true).visitEnd();
        mv.visitEnd();
    }

    private void generateCallbackMethod(String owner, SootMethod targetMethod, org.robovm.compiler.util.generic.Type[] actualGenericTypes, soot.Type[] actualRawTypes, soot.Type[] unboxedTypes, Set<String> usedBoxMethods, Set<String> usedUnboxMethods, String[][] targetMethodAnnotations, ClassWriter cw) {
        String targetInterfaceName = Types.getInternalName(targetMethod.getDeclaringClass());
        ArrayList<org.robovm.compiler.util.generic.Type> genericParamTypes = new ArrayList<org.robovm.compiler.util.generic.Type>();
        genericParamTypes.add(new SootTypeType((soot.Type)this.org_robovm_objc_ObjCBlock.getType()));
        for (int i = 1; i < unboxedTypes.length; ++i) {
            org.robovm.compiler.util.generic.Type t = unboxedTypes[i] instanceof PrimType ? new SootTypeType(unboxedTypes[i]) : actualGenericTypes[i];
            genericParamTypes.add(t);
        }
        org.robovm.compiler.util.generic.Type genericReturnType = unboxedTypes[0] instanceof PrimType ? new SootTypeType(unboxedTypes[0]) : actualGenericTypes[0];
        ArrayList<soot.Type> rawParamTypes = new ArrayList<soot.Type>();
        rawParamTypes.add((soot.Type)this.org_robovm_objc_ObjCBlock.getType());
        rawParamTypes.addAll(Arrays.asList(unboxedTypes).subList(1, unboxedTypes.length));
        String name = "invoked";
        String signature = this.getGenericSignature(genericParamTypes, genericReturnType);
        String desc = Types.getDescriptor(rawParamTypes, unboxedTypes[0]);
        MethodVisitor mv = cw.visitMethod(10, name, desc, signature, null);
        mv.visitAnnotation("Lorg/robovm/rt/bro/annotation/Callback;", true).visitEnd();
        SootMethod methodForEncoder = new SootMethod(name, rawParamTypes, unboxedTypes[0]);
        methodForEncoder.setDeclaringClass(targetMethod.getDeclaringClass());
        methodForEncoder.setDeclared(true);
        for (String s : targetMethodAnnotations[0]) {
            mv.visitAnnotation(s, true).visitEnd();
            Annotations.addRuntimeVisibleAnnotation((Host)methodForEncoder, s);
        }
        for (int i = 1; i < targetMethodAnnotations.length; ++i) {
            for (String s : targetMethodAnnotations[i]) {
                mv.visitParameterAnnotation(i, s, true).visitEnd();
                Annotations.addRuntimeVisibleParameterAnnotation(methodForEncoder, i, s);
            }
        }
        TypeEncoder encoder = new TypeEncoder();
        String typeEncoding = encoder.encode(methodForEncoder, !this.config.getArch().is32Bit());
        AnnotationVisitor av = mv.visitAnnotation(TYPE_ENCODING, true);
        av.visit("value", (Object)typeEncoding);
        av.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "org/robovm/objc/ObjCBlock", "object", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, targetInterfaceName);
        int i = 1;
        int var = 1;
        while (i < actualRawTypes.length) {
            soot.Type from = unboxedTypes[i];
            if (from == LongType.v()) {
                mv.visitVarInsn(22, var);
                ++var;
            } else if (from == FloatType.v()) {
                mv.visitVarInsn(23, var);
            } else if (from == DoubleType.v()) {
                mv.visitVarInsn(24, var);
                ++var;
            } else if (from instanceof PrimType) {
                mv.visitVarInsn(21, var);
            } else {
                mv.visitVarInsn(25, var);
            }
            soot.Type to = actualRawTypes[i];
            if (from != to) {
                String boxDesc = Types.getDescriptor(Collections.singletonList(from), to);
                usedBoxMethods.add(boxDesc);
                mv.visitMethodInsn(184, owner, "box", boxDesc);
            }
            ++i;
            ++var;
        }
        mv.visitMethodInsn(185, targetInterfaceName, targetMethod.getName(), Types.getDescriptor(targetMethod));
        if (unboxedTypes[0] != actualRawTypes[0]) {
            mv.visitTypeInsn(192, Types.getInternalName(actualRawTypes[0]));
            String unboxDesc = Types.getDescriptor(Collections.singletonList(actualRawTypes[0]), unboxedTypes[0]);
            usedUnboxMethods.add(unboxDesc);
            mv.visitMethodInsn(184, owner, "unbox", unboxDesc);
        }
        if (unboxedTypes[0] == VoidType.v()) {
            mv.visitInsn(177);
        } else if (unboxedTypes[0] == LongType.v()) {
            mv.visitInsn(173);
        } else if (unboxedTypes[0] == FloatType.v()) {
            mv.visitInsn(174);
        } else if (unboxedTypes[0] == DoubleType.v()) {
            mv.visitInsn(175);
        } else if (unboxedTypes[0] instanceof PrimType) {
            mv.visitInsn(172);
        } else {
            mv.visitInsn(176);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private String getGenericSignature(List<org.robovm.compiler.util.generic.Type> genericParamTypes, org.robovm.compiler.util.generic.Type genericReturnType) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (org.robovm.compiler.util.generic.Type t : genericParamTypes) {
            sb.append(t.toGenericSignature());
        }
        sb.append(")");
        sb.append(genericReturnType.toGenericSignature());
        String s = sb.toString();
        if (s.contains("<")) {
            return s;
        }
        return null;
    }

    private void generateTargetMethod(String owner, SootMethod targetMethod, org.robovm.compiler.util.generic.Type[] actualGenericTypes, soot.Type[] actualRawTypes, soot.Type[] unboxedTypes, Set<String> usedBoxMethods, Set<String> usedUnboxMethods, ClassWriter cw) {
        String name = targetMethod.getName();
        String signature = this.getGenericSignature(Arrays.asList(actualGenericTypes).subList(1, actualGenericTypes.length), actualGenericTypes[0]);
        String desc = Types.getDescriptor(targetMethod);
        MethodVisitor mv = cw.visitMethod(1, name, desc, signature, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, owner, "objCBlock", "L" + Types.getInternalName(this.org_robovm_objc_ObjCBlock) + ";");
        mv.visitMethodInsn(182, Types.getInternalName(this.org_robovm_objc_ObjCBlock), "invoke", "()J");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, owner, "objCBlock", "L" + Types.getInternalName(this.org_robovm_objc_ObjCBlock) + ";");
        int i = 1;
        int var = 1;
        while (i < actualRawTypes.length) {
            soot.Type from = actualRawTypes[i];
            if (from == LongType.v()) {
                mv.visitVarInsn(22, var);
                ++var;
            } else if (from == FloatType.v()) {
                mv.visitVarInsn(23, var);
            } else if (from == DoubleType.v()) {
                mv.visitVarInsn(24, var);
                ++var;
            } else if (from instanceof PrimType) {
                mv.visitVarInsn(21, var);
            } else {
                mv.visitVarInsn(25, var);
            }
            soot.Type to = unboxedTypes[i];
            if (from != to) {
                mv.visitTypeInsn(192, Types.getInternalName(from));
                String unboxDesc = Types.getDescriptor(Collections.singletonList(from), to);
                usedUnboxMethods.add(unboxDesc);
                mv.visitMethodInsn(184, owner, "unbox", unboxDesc);
            }
            ++i;
            ++var;
        }
        ArrayList<soot.Type> paramTypes = new ArrayList<soot.Type>();
        paramTypes.add((soot.Type)LongType.v());
        paramTypes.add((soot.Type)this.org_robovm_objc_ObjCBlock.getType());
        paramTypes.addAll(Arrays.asList(unboxedTypes).subList(1, unboxedTypes.length));
        mv.visitMethodInsn(184, owner, "invoke", Types.getDescriptor(paramTypes, unboxedTypes[0]));
        if (unboxedTypes[0] != actualRawTypes[0]) {
            String boxDesc = Types.getDescriptor(Collections.singletonList(unboxedTypes[0]), actualRawTypes[0]);
            usedBoxMethods.add(boxDesc);
            mv.visitMethodInsn(184, owner, "box", boxDesc);
        }
        if (actualRawTypes[0] == VoidType.v()) {
            mv.visitInsn(177);
        } else if (actualRawTypes[0] == LongType.v()) {
            mv.visitInsn(173);
        } else if (actualRawTypes[0] == FloatType.v()) {
            mv.visitInsn(174);
        } else if (actualRawTypes[0] == DoubleType.v()) {
            mv.visitInsn(175);
        } else if (actualRawTypes[0] instanceof PrimType) {
            mv.visitInsn(172);
        } else {
            mv.visitInsn(176);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected String getTargetMethodKey(SootMethod targetMethod, soot.Type[] actualTypes, String[][] targetMethodAnnotations) {
        StringBuilder key = new StringBuilder(Symbols.methodSymbol(Types.getInternalName(targetMethod.getDeclaringClass()), targetMethod.getName(), Arrays.asList(actualTypes).subList(1, actualTypes.length), actualTypes[0]));
        for (String[] a : targetMethodAnnotations) {
            key.append(',');
            for (String s : a) {
                key.append(s);
            }
        }
        return key.toString();
    }

    private soot.Type unboxType(soot.Type t) {
        if (t instanceof RefType) {
            SootClass c = ((RefType)t).getSootClass();
            if (c.equals(this.java_lang_Boolean)) {
                return BooleanType.v();
            }
            if (c.equals(this.java_lang_Byte)) {
                return ByteType.v();
            }
            if (c.equals(this.java_lang_Short)) {
                return ShortType.v();
            }
            if (c.equals(this.java_lang_Character)) {
                return CharType.v();
            }
            if (c.equals(this.java_lang_Integer)) {
                return IntType.v();
            }
            if (c.equals(this.java_lang_Long)) {
                return LongType.v();
            }
            if (c.equals(this.java_lang_Float)) {
                return FloatType.v();
            }
            if (c.equals(this.java_lang_Double)) {
                return DoubleType.v();
            }
        }
        return t;
    }

    private soot.Type[] unboxTypes(soot.Type[] actualTypes) {
        soot.Type[] unboxed = actualTypes;
        for (int i = 0; i < actualTypes.length; ++i) {
            soot.Type t = this.unboxType(actualTypes[i]);
            if (t == actualTypes[i]) continue;
            if (unboxed == actualTypes) {
                unboxed = new soot.Type[actualTypes.length];
                System.arraycopy(actualTypes, 0, unboxed, 0, actualTypes.length);
            }
            unboxed[i] = t;
        }
        return unboxed;
    }

    private static List<SootMethod> collectAbstractMethods(SootClass interfaze) {
        ArrayList<SootMethod> result = new ArrayList<SootMethod>();
        for (SootMethod m : interfaze.getMethods()) {
            if (!m.isAbstract()) continue;
            result.add(m);
        }
        for (SootClass c : interfaze.getInterfaces()) {
            result.addAll(ObjCBlockPlugin.collectAbstractMethods(c));
        }
        return result;
    }

    protected static SootMethod getBlockTargetMethod(SootMethod method, int paramIndex) {
        soot.Type type = method.getParameterType(paramIndex);
        if (!(type instanceof RefType)) {
            throw new CompilerException("@Block annotated parameter " + (paramIndex + 1) + " of method " + method + " must be of interface type");
        }
        SootClass blockType = ((RefType)type).getSootClass();
        if (!blockType.isInterface()) {
            throw new CompilerException("@Block annotated parameter " + (paramIndex + 1) + " of method " + method + " must be of interface type");
        }
        List<SootMethod> allMethods = ObjCBlockPlugin.collectAbstractMethods(blockType);
        if (allMethods.isEmpty()) {
            throw new CompilerException("No abstract method found in interface " + blockType + " used in @Block annotated parameter " + (paramIndex + 1) + " of method " + method);
        }
        if (allMethods.size() > 1) {
            throw new CompilerException("More than 1 abstract method found in interface " + blockType + " used in @Block annotated parameter " + (paramIndex + 1) + " of method " + method);
        }
        return allMethods.get(0);
    }

    protected static SootMethod getBlockTargetMethod(SootMethod method) {
        soot.Type type = method.getReturnType();
        if (!(type instanceof RefType)) {
            throw new CompilerException("@Block annotated return type of method " + method + " must be of interface type");
        }
        SootClass blockType = ((RefType)type).getSootClass();
        if (!blockType.isInterface()) {
            throw new CompilerException("@Block annotated parameter return type of method " + method + " must be of interface type");
        }
        List<SootMethod> allMethods = ObjCBlockPlugin.collectAbstractMethods(blockType);
        if (allMethods.isEmpty()) {
            throw new CompilerException("No abstract method found in interface " + blockType + " used in @Block annotated return type of method " + method);
        }
        if (allMethods.size() > 1) {
            throw new CompilerException("More than 1 abstract method found in interface " + blockType + " used in @Block annotated return type of method " + method);
        }
        return allMethods.get(0);
    }

    protected static org.robovm.compiler.util.generic.Type[] resolveTargetMethodSignature(SootMethod blockMethod, SootMethod targetMethod, org.robovm.compiler.util.generic.Type blockParamType) {
        if (targetMethod.getTag("SignatureTag") == null) {
            org.robovm.compiler.util.generic.Type[] result = new org.robovm.compiler.util.generic.Type[targetMethod.getParameterCount() + 1];
            result[0] = new SootTypeType(targetMethod.getReturnType());
            for (int i = 1; i < result.length; ++i) {
                result[i] = new SootTypeType(targetMethod.getParameterType(i - 1));
            }
            return result;
        }
        SootClassType base = new SootClassType(targetMethod.getDeclaringClass());
        TypeVariable<?>[] typeParameters = base.getTypeParameters();
        SootClassType offspring = null;
        org.robovm.compiler.util.generic.Type[] actualArgs = null;
        if (blockParamType instanceof SootClassType) {
            offspring = (SootClassType)blockParamType;
            actualArgs = new org.robovm.compiler.util.generic.Type[]{};
        } else if (blockParamType instanceof ParameterizedType) {
            offspring = (SootClassType)((ParameterizedType)blockParamType).getRawType();
            actualArgs = ((ParameterizedType)blockParamType).getActualTypeArguments();
        }
        org.robovm.compiler.util.generic.Type[] resolvedArgs = ObjCBlockPlugin.resolveActualTypeArgs(offspring, base, actualArgs);
        HashMap<String, org.robovm.compiler.util.generic.Type> flatResolvedArgs = new HashMap<String, org.robovm.compiler.util.generic.Type>();
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeVariable<?> t = typeParameters[i];
            org.robovm.compiler.util.generic.Type argValue = resolvedArgs[i];
            flatResolvedArgs.put(t.getName(), ObjCBlockPlugin.resolveMethodType(blockMethod, -2, argValue, null));
        }
        org.robovm.compiler.util.generic.Type[] result = new org.robovm.compiler.util.generic.Type[targetMethod.getParameterCount() + 1];
        SootMethodType targetMethodType = new SootMethodType(targetMethod);
        result[0] = ObjCBlockPlugin.resolveMethodType(blockMethod, -1, targetMethodType.getGenericReturnType(), flatResolvedArgs);
        org.robovm.compiler.util.generic.Type[] genericParameterTypes = targetMethodType.getGenericParameterTypes();
        for (int i = 1; i < result.length; ++i) {
            result[i] = ObjCBlockPlugin.resolveMethodType(blockMethod, i - 1, genericParameterTypes[i - 1], flatResolvedArgs);
        }
        return result;
    }

    private static org.robovm.compiler.util.generic.Type resolveMethodType(SootMethod blockMethod, int paramIndex, org.robovm.compiler.util.generic.Type t, Map<String, org.robovm.compiler.util.generic.Type> resolvedArgs) {
        if (t instanceof SootClassType) {
            return t;
        }
        if (t instanceof SootTypeType) {
            return t;
        }
        if (t instanceof TypeVariable) {
            if (resolvedArgs == null) {
                return ObjCBlockPlugin.resolveMethodType(blockMethod, paramIndex, ((TypeVariable)t).getBounds()[0], resolvedArgs);
            }
            org.robovm.compiler.util.generic.Type u = resolvedArgs.get(((TypeVariable)t).getName());
            if (u != null) {
                return u;
            }
            throw new CompilerException("Unresolved type variable " + t + " in " + (paramIndex == -1 ? "return type" : (paramIndex == -2 ? "argument" : "parameter " + (paramIndex + 1))) + " of @Block method " + blockMethod);
        }
        if (t instanceof WildcardType) {
            org.robovm.compiler.util.generic.Type[] upperBounds = ((WildcardType)t).getUpperBounds();
            return ObjCBlockPlugin.resolveMethodType(blockMethod, paramIndex, upperBounds[0], resolvedArgs);
        }
        if (t instanceof ParameterizedType) {
            ImplForType pType = (ImplForType)t;
            ListOfTypes types = new ListOfTypes(pType.getActualTypeArguments().length);
            for (org.robovm.compiler.util.generic.Type arg : pType.getActualTypeArguments()) {
                types.add(ObjCBlockPlugin.resolveMethodType(blockMethod, paramIndex, arg, resolvedArgs));
            }
            return new ImplForType((ImplForType)pType.getOwnerType(), pType.getRawType().getSootClass().getName(), types);
        }
        if (t instanceof GenericArrayType) {
            org.robovm.compiler.util.generic.Type componentType = ObjCBlockPlugin.resolveMethodType(blockMethod, paramIndex, ((GenericArrayType)t).getGenericComponentType(), resolvedArgs);
            return new ImplForArray(componentType);
        }
        throw new CompilerException("Unresolved type " + t + " in " + (paramIndex == -1 ? "return type" : (paramIndex == -2 ? "argument" : "parameter " + (paramIndex + 1))) + " of @Block method " + blockMethod);
    }

    private static soot.Type[] toRawTypes(org.robovm.compiler.util.generic.Type[] t) {
        soot.Type[] result = new soot.Type[t.length];
        for (int i = 0; i < t.length; ++i) {
            result[i] = ObjCBlockPlugin.toRawType(t[i]);
        }
        return result;
    }

    private static soot.Type toRawType(org.robovm.compiler.util.generic.Type t) {
        if (t instanceof SootClassType) {
            return ((SootClassType)t).getSootClass().getType();
        }
        if (t instanceof SootTypeType) {
            return ((SootTypeType)t).getSootType();
        }
        if (t instanceof WildcardType) {
            org.robovm.compiler.util.generic.Type[] upperBounds = ((WildcardType)t).getUpperBounds();
            return ObjCBlockPlugin.toRawType(upperBounds[0]);
        }
        if (t instanceof ParameterizedType) {
            return ObjCBlockPlugin.toRawType(((ParameterizedType)t).getRawType());
        }
        if (t instanceof GenericArrayType) {
            soot.Type componentType = ObjCBlockPlugin.toRawType(((GenericArrayType)t).getGenericComponentType());
            return componentType.makeArrayType();
        }
        throw new CompilerException("Failed to get the raw type from a " + t.getClass().getName() + " (" + t + ")");
    }

    private static int indexOf(String name, TypeVariable<?>[] typeParameters) {
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!name.equals(typeParameters[i].getName())) continue;
            return i;
        }
        return -1;
    }

    protected static org.robovm.compiler.util.generic.Type[] resolveActualTypeArgs(SootClassType offspring, SootClassType base, org.robovm.compiler.util.generic.Type ... actualArgs) {
        TypeVariable<?>[] typeParameters = offspring.getTypeParameters();
        if (actualArgs.length == 0) {
            actualArgs = typeParameters;
        }
        HashMap<String, org.robovm.compiler.util.generic.Type> typeVariables = new HashMap<String, org.robovm.compiler.util.generic.Type>();
        for (int i = 0; i < actualArgs.length; ++i) {
            org.robovm.compiler.util.generic.Type upper;
            TypeVariable<?> typeVariable = typeParameters[i];
            org.robovm.compiler.util.generic.Type t = actualArgs[i];
            if (t instanceof WildcardType && (upper = ((WildcardType)t).getUpperBounds()[0]) instanceof SootClassType && "java.lang.Object".equals(((SootClassType)upper).getSootClass().getName())) {
                actualArgs[i] = typeVariable.getBounds()[0];
            }
            typeVariables.put(typeVariable.getName(), actualArgs[i]);
        }
        LinkedList<org.robovm.compiler.util.generic.Type> ancestors = new LinkedList<org.robovm.compiler.util.generic.Type>();
        if (offspring.getGenericSuperclass() != null) {
            ancestors.add(offspring.getGenericSuperclass());
        }
        for (org.robovm.compiler.util.generic.Type t : offspring.getGenericInterfaces()) {
            ancestors.add(t);
        }
        for (org.robovm.compiler.util.generic.Type type : ancestors) {
            org.robovm.compiler.util.generic.Type[] result;
            SootClassType rawTypeClass;
            ParameterizedType parameterizedType;
            org.robovm.compiler.util.generic.Type rawType;
            org.robovm.compiler.util.generic.Type[] result2;
            SootClassType ancestorClass;
            if (type instanceof SootClassType && base.isAssignableFrom(ancestorClass = (SootClassType)type) && (result2 = ObjCBlockPlugin.resolveActualTypeArgs(ancestorClass, base, new org.robovm.compiler.util.generic.Type[0])) != null) {
                return result2;
            }
            if (!(type instanceof ParameterizedType) || !((rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof SootClassType) || !base.isAssignableFrom(rawTypeClass = (SootClassType)rawType) || (result = ObjCBlockPlugin.resolveActualTypeArgs(rawTypeClass, base, (parameterizedType = ObjCBlockPlugin.resolveParameterizedType(parameterizedType, typeVariables)).getActualTypeArguments())) == null) continue;
            return result;
        }
        return offspring.equals(base) ? actualArgs : null;
    }

    private static ParameterizedType resolveParameterizedType(ParameterizedType parameterizedType, Map<String, org.robovm.compiler.util.generic.Type> typeVariables) {
        LinkedList<org.robovm.compiler.util.generic.Type> resolvedTypes = new LinkedList<org.robovm.compiler.util.generic.Type>();
        for (org.robovm.compiler.util.generic.Type t : parameterizedType.getActualTypeArguments()) {
            if (t instanceof TypeVariable) {
                org.robovm.compiler.util.generic.Type resolvedType = typeVariables.get(((TypeVariable)t).getName());
                if (resolvedType instanceof ParameterizedType) {
                    resolvedType = ObjCBlockPlugin.resolveParameterizedType((ParameterizedType)resolvedType, typeVariables);
                }
                resolvedTypes.add(resolvedType != null ? resolvedType : t);
                continue;
            }
            if (t instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)t;
                resolvedTypes.add(ObjCBlockPlugin.resolveParameterizedType(pType, typeVariables));
                continue;
            }
            resolvedTypes.add(t);
        }
        ListOfTypes types = new ListOfTypes(resolvedTypes.toArray(new org.robovm.compiler.util.generic.Type[resolvedTypes.size()]));
        return new ImplForType(null, parameterizedType.getRawType().toString(), types);
    }

    static {
        BLOCK_ANNOTATIONS.put("@ByVal", "Lorg/robovm/rt/bro/annotation/ByVal;");
        BLOCK_ANNOTATIONS.put("@ByRef", "Lorg/robovm/rt/bro/annotation/ByRef;");
        BLOCK_ANNOTATIONS.put("@Pointer", "Lorg/robovm/rt/bro/annotation/Pointer;");
        BLOCK_ANNOTATIONS.put("@MachineSizedFloat", "Lorg/robovm/rt/bro/annotation/MachineSizedFloat;");
        BLOCK_ANNOTATIONS.put("@MachineSizedSInt", "Lorg/robovm/rt/bro/annotation/MachineSizedSInt;");
        BLOCK_ANNOTATIONS.put("@MachineSizedUInt", "Lorg/robovm/rt/bro/annotation/MachineSizedUInt;");
        BLOCK_ANNOTATIONS.put("@Block", BLOCK);
    }
}

