/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.objc;

import java.util.List;
import java.util.stream.Collectors;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;
import soot.Body;
import soot.PatchingChain;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.Unit;
import soot.jimple.InvokeStmt;
import soot.jimple.SpecialInvokeExpr;

public class ObjCProtocolToObjCObjectPlugin
extends AbstractCompilerPlugin {
    public static final String OBJC_PROTOCOL = "org.robovm.objc.ObjCProtocol";
    public static final String NS_OBJECT = "org.robovm.apple.foundation.NSObject";
    public static final String OBJC_OBJECT = "org.robovm.objc.ObjCObject";
    private SootClass org_robovm_apple_foundation_NSObject = null;
    private SootClass org_robovm_objc_ObjCObject = null;
    private SootClass org_robovm_objc_ObjCProtocol = null;
    private boolean initialized = false;

    private void init() {
        if (this.initialized) {
            return;
        }
        SootResolver r = SootResolver.v();
        this.org_robovm_objc_ObjCProtocol = r.makeClassRef(OBJC_PROTOCOL);
        this.org_robovm_apple_foundation_NSObject = r.makeClassRef(NS_OBJECT);
        this.org_robovm_objc_ObjCObject = r.resolveClass(OBJC_OBJECT, 1);
        this.initialized = true;
    }

    private boolean shouldReplaceSuper(SootClass cls) {
        if (this.org_robovm_objc_ObjCProtocol.isPhantom() || !cls.isConcrete()) {
            return false;
        }
        if (!cls.hasSuperclass() || !"java.lang.Object".equals(cls.getSuperclass().getName())) {
            return false;
        }
        return this.inheritsObjCProtocol(cls);
    }

    private boolean inheritsObjCProtocol(SootClass cls) {
        for (SootClass interfaze : cls.getInterfaces()) {
            if (interfaze != this.org_robovm_objc_ObjCProtocol && !this.inheritsObjCProtocol(interfaze)) continue;
            return true;
        }
        return false;
    }

    private SootClass getSuperReplacementCandidate(SootClass cls) {
        if (cls.getName().equals("org.robovm.apple.foundation.NSObjectProtocol")) {
            return this.org_robovm_apple_foundation_NSObject;
        }
        if (cls == this.org_robovm_objc_ObjCProtocol) {
            return this.org_robovm_objc_ObjCObject;
        }
        for (SootClass interfaze : cls.getInterfaces()) {
            SootClass superCls = this.getSuperReplacementCandidate(interfaze);
            if (superCls == null) continue;
            return superCls;
        }
        return null;
    }

    private boolean adjustSuperInitCall(Logger logger, SootClass cls, SootClass newSuper) {
        List constructors = cls.getMethods().stream().filter(m -> m.getName().equals("<init>")).collect(Collectors.toList());
        if (constructors.size() == 1) {
            SootMethod method = (SootMethod)constructors.get(0);
            Body body = method.retrieveActiveBody();
            PatchingChain units = body.getUnits();
            Unit unit = units.getFirst();
            while (unit != null) {
                SpecialInvokeExpr expr;
                InvokeStmt invoke;
                if (unit instanceof InvokeStmt && (invoke = (InvokeStmt)unit).getInvokeExpr() instanceof SpecialInvokeExpr && (expr = (SpecialInvokeExpr)invoke.getInvokeExpr()).getMethodRef().getSignature().equals("<java.lang.Object: void <init>()>")) {
                    expr.setMethodRef(newSuper.getMethod("void <init>()").makeRef());
                    return true;
                }
                unit = body.getUnits().getSuccOf(unit);
            }
            logger.warn("ObjCProtocol to NSObject failed: missing <java.lang.Object: void <init>()> call in %s", cls.getName());
        } else {
            logger.warn("ObjCProtocol to NSObject failed: too many public constructors", new Object[0]);
        }
        return false;
    }

    @Override
    public void beforeClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder) {
        SootClass superCandidate;
        this.init();
        SootClass sootClass = clazz.getSootClass();
        if (this.shouldReplaceSuper(sootClass) && (superCandidate = this.getSuperReplacementCandidate(sootClass)) != null && this.adjustSuperInitCall(config.getLogger(), sootClass, superCandidate)) {
            sootClass.setSuperclass(superCandidate);
        }
    }
}

