/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.robovm.compiler.Version;
import org.robovm.compiler.clazz.Path;
import org.robovm.compiler.config.AppExtension;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.CpuArch;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.config.Resource;
import org.robovm.compiler.config.StripArchivesConfig;
import org.robovm.compiler.config.WatchKitApp;
import org.robovm.compiler.target.LaunchParameters;
import org.robovm.compiler.target.Launcher;
import org.robovm.compiler.target.Target;
import org.robovm.compiler.target.ios.IOSTarget;
import org.robovm.compiler.util.ToolchainUtil;
import org.simpleframework.xml.Transient;

public abstract class AbstractTarget
implements Target {
    @Transient
    protected Config config;

    protected AbstractTarget() {
    }

    @Override
    public void init(Config config) {
        this.config = config;
    }

    @Override
    public boolean canLaunch() {
        return true;
    }

    @Override
    public void prepareLaunch() throws IOException {
    }

    @Override
    public LaunchParameters createLaunchParameters() {
        return new LaunchParameters();
    }

    @Override
    public String getInstallRelativeArchivePath(Path path) {
        String name = this.config.getArchiveName(path);
        if (path.isInBootClasspath()) {
            return "lib" + File.separator + "boot" + File.separator + name;
        }
        return "lib" + File.separator + name;
    }

    @Override
    public boolean canLaunchInPlace() {
        return true;
    }

    protected List<String> getTargetExportedSymbols() {
        return Collections.emptyList();
    }

    protected List<String> getTargetCcArgs() {
        return Collections.emptyList();
    }

    protected List<String> getTargetLibs() {
        return Collections.emptyList();
    }

    @Override
    public File build(List<File> objectFiles) throws IOException {
        File outFile = new File(this.config.getTmpDir(), this.config.getExecutableName());
        this.config.getLogger().info("Building %s binary %s", this.config.getTarget().getType(), outFile);
        LinkedList<String> ccArgs = new LinkedList<String>();
        LinkedList<String> libs = new LinkedList<String>();
        ccArgs.addAll(this.getTargetCcArgs());
        libs.addAll(this.getTargetLibs());
        String libSuffix = this.config.isUseDebugLibs() ? "-dbg" : "";
        libs.add("-lrobovm-bc" + libSuffix);
        if (this.config.getOs().getFamily() == OS.Family.darwin) {
            libs.add("-force_load");
            libs.add(new File(this.config.getOsArchDepLibDir(), "librobovm-rt" + libSuffix + ".a").getAbsolutePath());
        } else {
            libs.addAll(Arrays.asList("-Wl,--whole-archive", "-lrobovm-rt" + libSuffix, "-Wl,--no-whole-archive"));
        }
        if (this.config.isSkipInstall()) {
            libs.add("-lrobovm-debug" + libSuffix);
        }
        libs.addAll(Arrays.asList("-lrobovm-core" + libSuffix, "-lgc" + libSuffix, "-lpthread", "-ldl", "-lm", "-lz"));
        if (this.config.getOs().getFamily() == OS.Family.linux) {
            libs.add("-lrt");
        }
        if (this.config.getOs().getFamily() == OS.Family.darwin) {
            libs.add("-liconv");
            libs.add("-lsqlite3");
            libs.add("-framework");
            libs.add("Foundation");
        }
        ccArgs.add("-L");
        ccArgs.add(this.config.getOsArchDepLibDir().getAbsolutePath());
        ArrayList<String> exportedSymbols = new ArrayList<String>();
        exportedSymbols.addAll(this.getTargetExportedSymbols());
        exportedSymbols.add("JNI_OnLoad_*");
        exportedSymbols.addAll(this.config.getExportedSymbols());
        if (this.config.getOs().getFamily() == OS.Family.linux) {
            ccArgs.add("-Wl,-rpath=$ORIGIN");
            ccArgs.add("-Wl,--gc-sections");
            if (!exportedSymbols.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("{\n    ");
                sb.append(StringUtils.join(exportedSymbols, (String)";\n    "));
                sb.append(";\n};\n");
                File file = new File(this.config.getTmpDir(), "exported_symbols");
                FileUtils.writeStringToFile((File)file, (String)sb.toString());
                ccArgs.add("-Wl,--dynamic-list=" + file.getAbsolutePath());
            }
        } else if (this.config.getOs().getFamily() == OS.Family.darwin) {
            ccArgs.add("-ObjC");
            if (this.config.isSkipInstall()) {
                exportedSymbols.add("catch_exception_raise");
            }
            for (int i = 0; i < exportedSymbols.size(); ++i) {
                String string = (String)exportedSymbols.get(i);
                exportedSymbols.set(i, string.startsWith("*") ? string : "_" + string);
            }
            if (!this.config.getUnhideSymbols().isEmpty()) {
                ArrayList<String> aliasedSymbols = new ArrayList<String>();
                for (String symbol : this.config.getUnhideSymbols()) {
                    aliasedSymbols.add("_" + symbol + " __unhidden_" + symbol);
                }
                File file = new File(this.config.getTmpDir(), "aliased_symbols");
                FileUtils.writeLines((File)file, (String)"ASCII", aliasedSymbols);
                ccArgs.add("-Xlinker");
                ccArgs.add("-alias_list");
                ccArgs.add("-Xlinker");
                ccArgs.add(file.getAbsolutePath());
                exportedSymbols.add("__unhidden_*");
            }
            Iterator<File> exportedSymbolsFile = new File(this.config.getTmpDir(), "exported_symbols");
            FileUtils.writeLines(exportedSymbolsFile, (String)"ASCII", exportedSymbols);
            ccArgs.add("-exported_symbols_list");
            ccArgs.add(((File)((Object)exportedSymbolsFile)).getAbsolutePath());
            ccArgs.add("-Wl,-no_implicit_dylibs");
            ccArgs.add("-Wl,-dead_strip");
        }
        if (this.config.getOs().getFamily() == OS.Family.darwin && !this.config.getFrameworks().isEmpty()) {
            for (String string : this.config.getFrameworks()) {
                libs.add("-framework");
                libs.add(string);
            }
        }
        if (this.config.getOs().getFamily() == OS.Family.darwin && !this.config.getWeakFrameworks().isEmpty()) {
            for (String string : this.config.getWeakFrameworks()) {
                libs.add("-weak_framework");
                libs.add(string);
            }
        }
        if (this.config.getOs().getFamily() == OS.Family.darwin && !this.config.getFrameworkPaths().isEmpty()) {
            for (File file : this.config.getFrameworkPaths()) {
                ccArgs.add("-F" + file.getAbsolutePath());
            }
        }
        if (this.config.hasSwiftSupport()) {
            File[] swiftLibLocations;
            for (File dir : swiftLibLocations = this.getSwiftDirs(this.config)) {
                ccArgs.add("-L" + dir.getAbsolutePath());
            }
        }
        if (!this.config.getLibs().isEmpty()) {
            objectFiles = new ArrayList<File>(objectFiles);
            for (Config.Lib lib : this.config.getLibs()) {
                String p = lib.getValue();
                if (p.endsWith(".o")) {
                    objectFiles.add(new File(p));
                    continue;
                }
                if (p.endsWith(".a")) {
                    if (this.config.getOs().getFamily() == OS.Family.darwin) {
                        if (lib.isForce()) {
                            libs.add("-force_load");
                        }
                        libs.add(new File(p).getAbsolutePath());
                        continue;
                    }
                    if (lib.isForce()) {
                        libs.add("-Wl,--whole-archive");
                    }
                    libs.add(new File(p).getAbsolutePath());
                    if (!lib.isForce()) continue;
                    libs.add("-Wl,--no-whole-archive");
                    continue;
                }
                if (p.endsWith(".dylib") || p.endsWith(".so")) {
                    File f = new File(p);
                    libs.add(f.isAbsolute() ? f.getAbsolutePath() : p);
                    continue;
                }
                libs.add("-l" + p);
            }
        }
        ccArgs.add("-fPIC");
        if (this.config.getOs() == OS.macosx) {
            if (!this.config.getFrameworks().contains("CoreServices")) {
                libs.add("-framework");
                libs.add("CoreServices");
            }
        } else if (this.config.getOs() == OS.ios && !this.config.getFrameworks().contains("MobileCoreServices")) {
            libs.add("-framework");
            libs.add("MobileCoreServices");
        }
        this.doBuild(outFile, ccArgs, objectFiles, libs);
        return outFile;
    }

    protected void doBuild(File outFile, List<String> ccArgs, List<File> objectFiles, List<String> libs) throws IOException {
        ToolchainUtil.link(this.config, ccArgs, objectFiles, libs, outFile);
    }

    protected File getAppDir() {
        if (!this.config.isSkipInstall()) {
            return this.config.getInstallDir();
        }
        return this.config.getTmpDir();
    }

    protected String getExecutable() {
        return this.config.getExecutableName();
    }

    protected String getBundleId() {
        return this.config.getMainClass() != null ? this.config.getMainClass() : this.config.getExecutableName();
    }

    @Override
    public void buildFat(Map<Arch, File> slices) throws IOException {
        File destFile = new File(this.config.getTmpDir(), this.getExecutable());
        ArrayList<File> files = new ArrayList<File>(slices.values());
        if (slices.size() > 1) {
            if (this.config.getOs() == OS.linux) {
                throw new UnsupportedOperationException("Fat binaries are not supported when building linux binaries");
            }
            this.config.getLogger().info("Building fat binary for archs %s", StringUtils.join((Object[])new Set[]{slices.keySet()}));
            ToolchainUtil.lipo(this.config, destFile, files);
        } else if (!((File)files.get(0)).equals(destFile)) {
            FileUtils.copyFile((File)((File)files.get(0)), (File)destFile);
            destFile.setExecutable(true, false);
        }
    }

    protected void copyResources(File destDir) throws IOException {
        Resource.Walker walker = new Resource.Walker(){

            @Override
            public boolean processDir(Resource resource, File dir, File destDir) throws IOException {
                return true;
            }

            @Override
            public void processFile(Resource resource, File file, File destDir) throws IOException {
                AbstractTarget.this.copyFile(resource, file, destDir);
            }
        };
        for (Resource res : this.config.getResources()) {
            res.walk(walker, destDir);
        }
    }

    protected void copyDynamicFrameworks(File destDir, File appExecutable) throws IOException {
        final HashSet<String> swiftLibraries = new HashSet<String>();
        File frameworksDir = new File(destDir, "Frameworks");
        for (String framework : this.config.getFrameworks()) {
            boolean isCustomFramework = false;
            File frameworkDir = null;
            for (File path : this.config.getFrameworkPaths()) {
                frameworkDir = new File(path, framework + ".framework");
                if (!frameworkDir.exists() || !frameworkDir.isDirectory()) continue;
                isCustomFramework = true;
                break;
            }
            if (!isCustomFramework) continue;
            boolean isDynamicFramework = false;
            for (File file : frameworkDir.listFiles()) {
                if (!file.isFile() || !this.isDynamicLibrary(file)) continue;
                isDynamicFramework = true;
                break;
            }
            if (!isDynamicFramework) continue;
            this.config.getLogger().info("Copying framework %s from %s to %s", framework, frameworkDir, destDir);
            new Resource(frameworkDir).walk(new Resource.Walker(){

                @Override
                public boolean processDir(Resource resource, File dir, File destDir) throws IOException {
                    return !dir.getName().equals("Headers") && !dir.getName().equals("PrivateHeaders") && !dir.getName().equals("Modules") && !dir.getName().equals("Versions") && !dir.getName().equals("Documentation");
                }

                @Override
                public void processFile(Resource resource, File file, File destDir) throws IOException {
                    if (!AbstractTarget.this.isStaticLibrary(file)) {
                        AbstractTarget.this.copyFile(resource, file, destDir);
                        if (AbstractTarget.this.isDynamicLibrary(file)) {
                            if (AbstractTarget.this.config.getOs() == OS.ios && AbstractTarget.this.config.getArch().isArm()) {
                                File libFile = new File(destDir, file.getName());
                                AbstractTarget.this.stripExtraArches(libFile);
                                if (!AbstractTarget.this.config.isEnableBitcode()) {
                                    AbstractTarget.this.stripBitcode(libFile);
                                }
                            }
                            AbstractTarget.this.getSwiftDependencies(file, swiftLibraries);
                        }
                    }
                }
            }, frameworksDir);
        }
        if (this.config.hasSwiftSupport() && this.config.getSwiftSupport().shouldCopySwiftLibs()) {
            this.getSwiftDependencies(appExecutable, swiftLibraries);
            for (Config.Lib lib : this.config.getLibs()) {
                String p = lib.getValue();
                if (!p.startsWith("libswift") || !p.endsWith(".dylib") || new File(p).exists()) continue;
                swiftLibraries.add(p);
            }
            if (!swiftLibraries.isEmpty()) {
                this.copySwiftLibs(swiftLibraries, frameworksDir, true);
            }
        }
    }

    protected void getSwiftDependencies(File file, Collection<String> swiftLibraries) throws IOException {
        String dependencies = ToolchainUtil.otool(file);
        Pattern swiftLibraryPattern = Pattern.compile("@rpath/(libswift.+\\.dylib)");
        Matcher matcher = swiftLibraryPattern.matcher(dependencies);
        while (matcher.find()) {
            String library = matcher.group(1);
            swiftLibraries.add(library);
        }
    }

    protected void copyAppExtensions(File destDir) throws IOException {
        File pluginsDir = new File(destDir, "PlugIns");
        List<File> extPaths = this.config.getAppExtensionPaths();
        String appBundleId = this.getBundleId();
        for (AppExtension extensionVo : this.config.getAppExtensions()) {
            String extensionName = extensionVo.getNameWithExt(".appex");
            File extensionDir = this.findDirectoryInLocations(extensionName, extPaths);
            if (extensionDir == null) {
                throw new IllegalArgumentException(String.format("Specified app extension `%s` not found in ext paths", extensionVo.getName()));
            }
            this.config.getLogger().info("Copying app-extension %s from %s to %s", extensionName, extensionDir, pluginsDir);
            new Resource(extensionDir).walk(new Resource.Walker(){

                @Override
                public boolean processDir(Resource resource, File dir, File destDir) throws IOException {
                    return true;
                }

                @Override
                public void processFile(Resource resource, File file, File destDir) throws IOException {
                    AbstractTarget.this.copyFile(resource, file, destDir);
                    if (AbstractTarget.this.config.getOs() == OS.ios && AbstractTarget.this.config.getArch().isArm() && AbstractTarget.this.isAppExtension(file)) {
                        File libFile = new File(destDir, file.getName());
                        AbstractTarget.this.stripExtraArches(libFile);
                        if (!AbstractTarget.this.config.isEnableBitcode()) {
                            AbstractTarget.this.stripBitcode(libFile);
                        }
                    }
                }
            }, pluginsDir);
            this.updateAppExtensionBundleId(new File(pluginsDir, extensionName), extensionVo, appBundleId);
        }
    }

    protected File findDirectoryInLocations(String dirName, List<File> locations) {
        for (File path : locations) {
            File extPath = new File(path, dirName);
            if (!extPath.exists() || !extPath.isDirectory()) continue;
            return extPath;
        }
        return null;
    }

    protected String updateAppExtensionBundleId(File extensionPath, AppExtension config, String parentBundleId) {
        String appExBundleId;
        NSDictionary infoPlist;
        File infoPlistFile = new File(extensionPath, "Info.plist");
        try {
            infoPlist = (NSDictionary)PropertyListParser.parse((File)infoPlistFile);
            appExBundleId = infoPlist.get((Object)"CFBundleIdentifier").toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read bundle id of extension " + extensionPath);
        }
        if (config.getSuffix() == null) {
            if (!appExBundleId.startsWith(parentBundleId + ".")) {
                throw new RuntimeException(String.format("AppExtension (%s) shall extend parent bundle(%s) id while skipSigning!", extensionPath.getName(), parentBundleId));
            }
        } else if (config.getSuffix() != null) {
            appExBundleId = parentBundleId + "." + config.getSuffix();
            try {
                infoPlist = (NSDictionary)PropertyListParser.parse((File)infoPlistFile);
                infoPlist.put("CFBundleIdentifier", (Object)appExBundleId);
                PropertyListParser.saveAsXML((NSObject)infoPlist, (File)infoPlistFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to update bundle id of extension " + extensionPath);
            }
        }
        return appExBundleId;
    }

    protected void copyWatchApp(File installDir) throws IOException {
        WatchKitApp waConfig = this.config.getWatchKitApp();
        if (waConfig == null) {
            return;
        }
        String waName = waConfig.getWatchAppName();
        File waSrcDir = this.findDirectoryInLocations(waName, this.config.getAppExtensionPaths());
        if (waSrcDir == null) {
            throw new IllegalArgumentException("WatchApp with name " + waName + " not found in app extension paths!");
        }
        File waDestDir = new File(installDir, "Watch/" + waName);
        this.config.getLogger().info("Copying Watch App from %s to %s", waSrcDir, waDestDir);
        FileUtils.copyDirectory((File)waSrcDir, (File)waDestDir);
        String waKitBundleId = this.updateAppExtensionBundleId(waDestDir, waConfig.getApp(), this.getBundleId());
        HashMap extensionsMap = new HashMap();
        waConfig.getExtensions().forEach(e -> extensionsMap.put(e.getNameWithExt(".appex"), e));
        File pluginsDir = new File(waDestDir, "PlugIns");
        for (File extPath : pluginsDir.listFiles()) {
            if (!extPath.isDirectory() || !extPath.getName().endsWith(".appex")) {
                this.config.getLogger().info("Skipping not expected file/dir '%s' in PlugIns folder: %s", extPath.getName(), pluginsDir.getAbsolutePath());
                continue;
            }
            String name = extPath.getName();
            AppExtension extension = (AppExtension)extensionsMap.get(name);
            if (extension != null) continue;
            extension = AppExtension.DEFAULT_RULE;
            this.updateAppExtensionBundleId(extPath, extension, waKitBundleId);
        }
    }

    private File locateSwiftLib(File[] swiftDirs, String swiftLib) throws FileNotFoundException {
        for (File swiftDir : swiftDirs) {
            File f = new File(swiftDir, swiftLib);
            if (!f.exists()) continue;
            return f;
        }
        throw new FileNotFoundException(swiftLib + " is not found in swift paths");
    }

    private File[] getSwiftDirs(Config config) throws IOException {
        List<File> configPaths = config.getSwiftLibPaths();
        if (!configPaths.isEmpty()) {
            ArrayList<File> candidates = new ArrayList<File>(configPaths);
            return candidates.toArray(new File[0]);
        }
        return this.getDefaultSwiftDirs(config);
    }

    private String getSwiftSystemName(Config config) {
        String system = config.getOs() == OS.ios ? (IOSTarget.isDeviceArch(config.getArch()) ? "iphoneos" : "iphonesimulator") : "macos";
        return system;
    }

    private File[] getDefaultSwiftDirs(Config config) throws IOException {
        String system = this.getSwiftSystemName(config);
        return this.getDefaultSwiftDirs(system);
    }

    private void validateAndAddSwiftDir(List<File> dest, String xcodePath, String version, String system) {
        File candidate = new File(xcodePath, "Toolchains/XcodeDefault.xctoolchain/usr/lib/" + version + "/" + system);
        if (candidate.exists() && candidate.isDirectory()) {
            dest.add(candidate);
        }
    }

    private File[] getDefaultSwiftDirs(String system) throws IOException {
        ArrayList<File> swiftDirs = new ArrayList<File>();
        String xcodePath = ToolchainUtil.findXcodePath();
        swiftDirs.add(new File("/usr/lib/swift"));
        this.validateAndAddSwiftDir(swiftDirs, xcodePath, "swift", system);
        File rootDir = new File(xcodePath, "Toolchains/XcodeDefault.xctoolchain/usr/lib/");
        String swiftDirPrefix = "swift-";
        String[] dirNames = rootDir.list((dir, name) -> name.startsWith("swift-"));
        if (dirNames != null && dirNames.length > 0) {
            HashMap<String, Version> swiftVersions = new HashMap<String, Version>();
            for (String dirName : dirNames) {
                Version v = Version.parseOrNull(dirName.substring("swift-".length()));
                if (v != null) {
                    swiftVersions.put(dirName, v);
                    continue;
                }
                this.config.getLogger().warn("Failed to parse swift version: " + dirName, new Object[0]);
            }
            swiftVersions.entrySet().stream().sorted((o1, o2) -> ((Version)o2.getValue()).compareTo((Version)o1.getValue())).forEach(e -> {
                String version = (String)e.getKey();
                this.validateAndAddSwiftDir(swiftDirs, xcodePath, version, system);
            });
        }
        return swiftDirs.toArray(new File[0]);
    }

    protected void copySwiftLibs(Collection<String> swiftLibraries, File targetDir, boolean strip) throws IOException {
        File[] swiftDirs = this.getSwiftDirs(this.config);
        HashSet<String> libsToResolve = new HashSet<String>(swiftLibraries);
        HashMap<String, File> resolvedLibs = new HashMap<String, File>();
        while (!libsToResolve.isEmpty()) {
            for (String string : new HashSet<String>(libsToResolve)) {
                libsToResolve.remove(string);
                if (resolvedLibs.containsKey(string)) continue;
                File swiftLibrary = this.locateSwiftLib(swiftDirs, string);
                resolvedLibs.put(string, swiftLibrary);
                this.getSwiftDependencies(swiftLibrary, libsToResolve);
            }
        }
        for (Map.Entry entry : resolvedLibs.entrySet()) {
            String library = (String)entry.getKey();
            File swiftLibrary = (File)entry.getValue();
            this.config.getLogger().info("Copying swift lib %s from %s to %s", library, swiftLibrary.getParent(), targetDir);
            FileUtils.copyFileToDirectory((File)swiftLibrary, (File)targetDir);
            if (!strip || this.config.getOs() != OS.ios || !this.config.getArch().isArm()) continue;
            File libFile = new File(targetDir, swiftLibrary.getName());
            this.stripExtraArches(libFile);
            if (this.config.isEnableBitcode()) continue;
            this.stripBitcode(libFile);
        }
    }

    protected void stripExtraArches(File libFile) throws IOException {
        String archs = ToolchainUtil.lipoInfo(this.config, libFile);
        ArrayList<String> archesToRemove = new ArrayList<String>();
        if (archs.contains(CpuArch.x86.getClangName())) {
            archesToRemove.add(CpuArch.x86.getClangName());
        }
        if (archs.contains(CpuArch.x86_64.getClangName())) {
            archesToRemove.add(CpuArch.x86_64.getClangName());
        }
        if (archs.contains("arm64e")) {
            archesToRemove.add("arm64e");
        }
        if (!archesToRemove.isEmpty()) {
            File tmpFile = new File(libFile.getAbsolutePath() + ".tmp");
            ToolchainUtil.lipoRemoveArchs(this.config, libFile, tmpFile, archesToRemove.toArray(new String[0]));
            FileUtils.copyFile((File)tmpFile, (File)libFile);
            tmpFile.delete();
        }
    }

    protected void stripBitcode(File libFile) throws IOException {
        File tmpFile = new File(libFile.getAbsolutePath() + ".tmp");
        ToolchainUtil.bitcodeStrip(this.config, libFile, tmpFile);
        FileUtils.copyFile((File)tmpFile, (File)libFile);
        tmpFile.delete();
    }

    protected boolean isDynamicLibrary(File file) throws IOException {
        String result = ToolchainUtil.file(file);
        return result.contains("shared library");
    }

    protected boolean isStaticLibrary(File file) throws IOException {
        String result = ToolchainUtil.file(file);
        return result.contains("ar archive");
    }

    protected boolean isAppExtension(File file) throws IOException {
        String result = ToolchainUtil.file(file);
        return result.contains("Mach-O 64-bit executable") || result.contains("Mach-O executable");
    }

    protected void copyFile(Resource resource, File file, File destDir) throws IOException {
        this.config.getLogger().info("Copying resource %s to %s", file, destDir);
        FileUtils.copyFileToDirectory((File)file, (File)destDir, (boolean)true);
    }

    @Override
    public void install() throws IOException {
        this.config.getLogger().info("Installing %s binary to %s", this.config.getTarget().getType(), this.config.getInstallDir());
        this.config.getInstallDir().mkdirs();
        this.doInstall(this.config.getInstallDir(), this.config.getExecutableName(), this.config.getInstallDir());
    }

    @Override
    public List<Arch> getDefaultArchs() {
        return Collections.emptyList();
    }

    @Override
    public void archive() throws IOException {
        throw new UnsupportedOperationException("Archiving is not supported for this target");
    }

    protected void doInstall(File installDir, String image, File resourcesDir) throws IOException {
        File executable = new File(installDir, image);
        File f = new File(this.config.getTmpDir(), this.config.getExecutableName());
        if (!f.equals(executable)) {
            FileUtils.copyFile((File)f, (File)executable);
            executable.setExecutable(true, false);
        }
        this.doInstall(installDir, executable, resourcesDir);
    }

    protected void doInstall(File installDir, File executable, File resourcesDir) throws IOException {
        for (File f : this.config.getOsArchDepLibDir().listFiles()) {
            if (!f.getName().matches(".*\\.(so|dylib)(\\.1)?")) continue;
            FileUtils.copyFileToDirectory((File)f, (File)installDir);
        }
        this.stripArchives(installDir);
        this.copyResources(resourcesDir);
        this.copyDynamicFrameworks(installDir, executable);
        this.copyAppExtensions(installDir);
        this.copyWatchApp(installDir);
    }

    @Override
    public Process launch(LaunchParameters launchParameters) throws IOException {
        if (this.config.isSkipLinking()) {
            throw new IllegalStateException("Cannot skip linking if target should be run");
        }
        boolean add = true;
        for (String arg : launchParameters.getArguments()) {
            if (!arg.startsWith("-rvm:log=")) continue;
            add = false;
            break;
        }
        if (add) {
            ArrayList<String> args = new ArrayList<String>(launchParameters.getArguments());
            args.add(0, "-rvm:log=warn");
            launchParameters.setArguments(args);
        }
        HashMap<String, String> env = new HashMap<String, String>(launchParameters.getEnvironment() != null ? launchParameters.getEnvironment() : Collections.emptyMap());
        env.put("ROBOVM_LAUNCH_MODE", this.config.isDebug() ? "debug" : "release");
        launchParameters.setEnvironment(env);
        return this.doLaunch(launchParameters);
    }

    protected Process doLaunch(LaunchParameters launchParameters) throws IOException {
        return this.createLauncher(launchParameters).execAsync();
    }

    protected Launcher createLauncher(LaunchParameters launchParameters) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Target build(Config config) {
        return this;
    }

    protected void stripArchives(File installDir) throws IOException {
        ArrayList<Path> allPaths = new ArrayList<Path>();
        allPaths.addAll(this.config.getClazzes().getPaths());
        allPaths.addAll(this.config.getResourcesPaths());
        for (Path path : allPaths) {
            File destJar = new File(installDir, this.getInstallRelativeArchivePath(path));
            if (!destJar.getParentFile().exists()) {
                destJar.getParentFile().mkdirs();
            }
            this.stripArchive(path, destJar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stripArchive(Path path, File output) throws IOException {
        if (!this.config.isClean() && output.exists() && !path.hasChangedSince(output.lastModified())) {
            this.config.getLogger().info("Not creating stripped archive file %s for unchanged path %s", output, path.getFile());
            return;
        }
        this.config.getLogger().info("Creating stripped archive file %s", output);
        ZipOutputStream out = null;
        ArrayList<StripArchivesConfig.Pattern> patterns = this.config.getStripArchivesConfig().getPatterns();
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(output)));
            if (path.getFile().isFile()) {
                ZipFile archive = null;
                try {
                    archive = new ZipFile(path.getFile());
                    Enumeration<? extends ZipEntry> entries = archive.entries();
                    block17: while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (entry.getName().startsWith("META-INF/robovm/")) continue;
                        for (StripArchivesConfig.Pattern pattern : patterns) {
                            if (!pattern.matches(entry.getName())) continue;
                            if (!pattern.isInclude()) continue block17;
                            break;
                        }
                        ZipEntry newEntry = new ZipEntry(entry.getName());
                        newEntry.setTime(entry.getTime());
                        out.putNextEntry(newEntry);
                        InputStream in = null;
                        try {
                            in = archive.getInputStream(entry);
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                            out.closeEntry();
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)in);
                        }
                    }
                }
                finally {
                    try {
                        archive.close();
                    }
                    catch (Throwable entries) {}
                }
            }
            String basePath = path.getFile().getAbsolutePath();
            Collection files = FileUtils.listFiles((File)path.getFile(), null, (boolean)true);
            block19: for (File f : files) {
                String entryName = f.getAbsolutePath().substring(basePath.length() + 1);
                if (entryName.startsWith("META-INF/robovm/")) continue;
                for (StripArchivesConfig.Pattern pattern : patterns) {
                    if (!pattern.matches(entryName)) continue;
                    if (!pattern.isInclude()) continue block19;
                    break;
                }
                ZipEntry newEntry = new ZipEntry(entryName);
                newEntry.setTime(f.lastModified());
                out.putNextEntry(newEntry);
                FileInputStream in = null;
                try {
                    in = new FileInputStream(f);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.closeEntry();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(out);
            output.delete();
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }
}

