/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public abstract class FilteringStreamProxy
extends Thread {
    private final int bufferSize;
    protected final InputStream in;
    protected final OutputStream out;

    public FilteringStreamProxy(InputStream in, OutputStream out) {
        this(4096, in, out);
    }

    public FilteringStreamProxy(int bufferSize, InputStream in, OutputStream out) {
        this.bufferSize = bufferSize;
        this.in = in;
        this.out = out;
        this.setDaemon(true);
        this.setName(FilteringStreamProxy.class.getSimpleName() + "Thread[" + this.getClass().getSimpleName() + "]");
    }

    protected abstract boolean findPattern(byte[] var1, int var2, OutputStream var3) throws IOException;

    private byte[] ensureBufferSize(byte[] buffer, int requiredLength) {
        if (buffer.length < requiredLength) {
            byte[] newBuffer = new byte[buffer.length * 2];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            buffer = newBuffer;
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean eof = false;
            byte[] buffer = new byte[this.bufferSize];
            int pos = 0;
            while (!(eof || this.isInterrupted() || this.shouldStop())) {
                int b = this.in.read();
                if (b == -1) {
                    eof = true;
                    break;
                }
                buffer = this.ensureBufferSize(buffer, pos + 1);
                buffer[pos++] = (byte)b;
                if (!this.findPattern(buffer, pos, this.out)) continue;
                break;
            }
            while (!(eof || this.isInterrupted() || this.shouldStop())) {
                int n = this.in.read(buffer);
                if (n == -1) {
                    eof = true;
                    break;
                }
                if (n <= 0) continue;
                this.out.write(buffer, 0, n);
                this.out.flush();
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        finally {
            this.closeStreams();
        }
    }

    protected void closeStreams() {
        IOUtils.closeQuietly((OutputStream)this.out);
        IOUtils.closeQuietly((InputStream)this.in);
    }

    protected void handleException(Throwable t) {
        t.printStackTrace();
    }

    protected boolean shouldStop() {
        return false;
    }
}

