/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.Types;
import soot.PrimType;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationTag;

public abstract class Bro {
    public static boolean needsMarshaler(Type t) {
        return !t.equals(VoidType.v()) && !(t instanceof PrimType);
    }

    public static int getStructMemberOffset(SootMethod method) {
        AnnotationTag annotation = Annotations.getStructMemberAnnotation(method);
        if (annotation == null) {
            return -1;
        }
        return ((AnnotationIntElem)annotation.getElemAt(0)).getValue();
    }

    public static int[] getArrayDimensions(SootMethod method) {
        return Bro.getArrayDimensions(method, -1);
    }

    public static int[] getArrayDimensions(SootMethod method, int paramIndex) {
        AnnotationTag annotation;
        AnnotationTag annotationTag = annotation = paramIndex == -1 ? Annotations.getArrayAnnotation(method) : Annotations.getArrayAnnotation(method, paramIndex);
        if (annotation == null) {
            return null;
        }
        ArrayList values = ((AnnotationArrayElem)annotation.getElemAt(0)).getValues();
        int[] dims = new int[values.size()];
        for (int i = 0; i < dims.length; ++i) {
            dims[i] = ((AnnotationIntElem)values.get(i)).getValue();
        }
        return dims;
    }

    public static boolean isPassByValue(SootMethod method) {
        Type sootType = method.getReturnType();
        return Types.isStruct(sootType) && (Annotations.hasByValAnnotation(method) || Annotations.hasByValAnnotation(((RefType)sootType).getSootClass()));
    }

    public static boolean isPassByValue(SootMethod method, int paramIndex) {
        Type sootType = method.getParameterType(paramIndex);
        return Types.isStruct(sootType) && (Annotations.hasByValAnnotation(method, paramIndex) || Annotations.hasByValAnnotation(((RefType)sootType).getSootClass()));
    }

    public static boolean isStructRet(SootMethod method, int paramIndex) {
        Type sootType = method.getParameterType(paramIndex);
        return paramIndex == 0 && Types.isStruct(sootType) && Annotations.hasStructRetAnnotation(method, paramIndex);
    }

    public static class MarshalerFlags {
        public static final long CALL_TYPE_BRIDGE = 0L;
        public static final long CALL_TYPE_CALLBACK = 1L;
        public static final long CALL_TYPE_STRUCT_MEMBER = 2L;
        public static final long CALL_TYPE_GLOBAL_VALUE = 3L;
        public static final long CALL_TYPE_PTR = 4L;
    }
}

