/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.clazz;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.Clazzes;
import org.robovm.compiler.clazz.DirectoryPath;
import org.robovm.compiler.clazz.Path;

public abstract class AbstractPath
implements Path {
    protected final File file;
    protected final Clazzes clazzes;
    protected final int index;
    protected Set<Clazz> clazzSet = null;
    protected boolean disposed = false;
    protected boolean inBootclasspath;
    protected Map<String, Clazz> generatedClasses = new HashMap<String, Clazz>();
    protected final File generatedClassDir;

    AbstractPath(File file, Clazzes clazzes, int index, boolean inBootclasspath) {
        this.file = file;
        this.clazzes = clazzes;
        this.index = index;
        this.inBootclasspath = inBootclasspath;
        this.generatedClassDir = clazzes.getConfig().getGeneratedClassDir(this);
    }

    @Override
    public boolean isInBootClasspath() {
        return this.inBootclasspath;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Set<Clazz> listClasses() {
        if (this.disposed) {
            throw new IllegalStateException("Path was disposed!");
        }
        if (this.clazzSet == null) {
            this.clazzSet = this.doListClasses();
        }
        return Collections.unmodifiableSet(this.clazzSet);
    }

    @Override
    public File getGeneratedClassFile(String internalName) {
        return new File(this.generatedClassDir, internalName.replace('/', File.separatorChar) + ".class");
    }

    @Override
    public Clazz loadGeneratedClass(String internalName) {
        Clazz clazz = this.generatedClasses.get(internalName);
        if (clazz == null) {
            File classFile = this.getGeneratedClassFile(internalName);
            if (classFile.exists() && classFile.isFile()) {
                clazz = new DirectoryPath.DirectoryPathClazz(this.clazzes, this, this.generatedClassDir, classFile);
            }
            if (clazz != null) {
                this.generatedClasses.put(internalName, clazz);
            }
        }
        return clazz;
    }

    protected abstract Set<Clazz> doListClasses();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPath other = (AbstractPath)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    public String toString() {
        return this.file.toString();
    }

    @Override
    public void disposeBuildData() {
        this.disposed = true;
        this.clazzSet = null;
        this.generatedClasses = null;
    }
}

