/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.config;

public enum Environment {
    Native(""),
    Simulator("simulator");

    private final String llvmName;

    private Environment(String llvmName) {
        this.llvmName = llvmName;
    }

    public String getLlvmName() {
        return this.llvmName;
    }

    public String asLlvmSuffix(String delimiter) {
        return this.llvmName != null && !this.llvmName.isEmpty() ? delimiter + this.llvmName : "";
    }

    public static Environment parse(String s) {
        for (Environment e : Environment.values()) {
            if (!e.llvmName.equals(s)) continue;
            return e;
        }
        throw new IllegalArgumentException("Failed to parse Environment with llvmName=" + s);
    }
}

