/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import org.robovm.compiler.llvm.AggregateType;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;

public class Getelementptr
extends Instruction {
    private final Variable result;
    private final Value ptr;
    private final Value[] idx;

    public Getelementptr(Variable result, Value ptr, int ... idx) {
        if (!ptr.isPointer()) {
            throw new IllegalArgumentException("PointerType expected");
        }
        if (idx.length > 1 && !(((PointerType)ptr.getType()).getBase() instanceof AggregateType)) {
            throw new IllegalArgumentException("PointerType should point to AggregateType");
        }
        if (idx == null || idx.length == 0) {
            throw new IllegalArgumentException("No indexes");
        }
        this.result = result;
        this.ptr = ptr;
        this.idx = new Value[idx.length];
        for (int i = 0; i < idx.length; ++i) {
            this.idx[i] = new IntegerConstant(idx[i]);
        }
    }

    public Getelementptr(Variable result, Value ptr, Value ... idx) {
        if (!ptr.isPointer()) {
            throw new IllegalArgumentException("PointerType expected");
        }
        if (idx.length > 1 && !(((PointerType)ptr.getType()).getBase() instanceof AggregateType)) {
            throw new IllegalArgumentException("PointerType should point to AggregateType");
        }
        if (idx == null || idx.length == 0) {
            throw new IllegalArgumentException("No indexes");
        }
        this.result = result;
        this.ptr = ptr;
        this.idx = idx;
    }

    @Override
    public Set<Variable> getWritesTo() {
        return Collections.singleton(this.result);
    }

    @Override
    public Set<VariableRef> getReadsFrom() {
        if (this.ptr instanceof VariableRef) {
            return Collections.singleton((VariableRef)this.ptr);
        }
        return super.getReadsFrom();
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.result.toString());
        writer.write(" = getelementptr ");
        this.ptr.getType().write(writer);
        writer.write(32);
        this.ptr.write(writer);
        for (Value value : this.idx) {
            writer.write(", ");
            value.getType().write(writer);
            writer.write(" ");
            value.write(writer);
        }
    }

    public String toString() {
        return this.toString(this::write);
    }
}

