/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.BinaryOpInstruction;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;

public class Icmp
extends BinaryOpInstruction {
    private final Condition cond;

    public Icmp(Variable result, Condition cond, Value op1, Value op2) {
        super(result, op1, op2);
        if (result.getType() != Type.I1) {
            throw new IllegalArgumentException("i1 type expected as result");
        }
        if (!op1.getType().equals(op2.getType())) {
            throw new IllegalArgumentException("Type mismatch");
        }
        if (!op1.isInteger() && !op1.isPointer()) {
            throw new IllegalArgumentException("Integer or pointer type expected");
        }
        this.cond = cond;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.append(this.result.toString()).append(" = icmp ").append(this.cond.toString()).append(' ');
        this.op1.getType().write(writer);
        writer.write(32);
        this.op1.write(writer);
        writer.write(", ");
        this.op2.write(writer);
    }

    public String toString() {
        return this.toString(this::write);
    }

    public static enum Condition {
        eq,
        ne,
        ugt,
        uge,
        ult,
        ule,
        sgt,
        sge,
        slt,
        sle;

    }
}

