/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.Argument;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.FunctionCallInstruction;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;

public class Invoke
extends FunctionCallInstruction {
    private final BasicBlockRef to;
    private final BasicBlockRef unwind;

    public Invoke(Value function, BasicBlockRef to, BasicBlockRef unwind, Value ... args) {
        super("invoke", function, args);
        this.to = to;
        this.unwind = unwind;
    }

    public Invoke(Variable result, Value function, BasicBlockRef to, BasicBlockRef unwind, Value ... args) {
        super("invoke", result, function, args);
        this.to = to;
        this.unwind = unwind;
    }

    public Invoke(Value function, BasicBlockRef to, BasicBlockRef unwind, Argument ... args) {
        super("invoke", function, args);
        this.to = to;
        this.unwind = unwind;
    }

    public Invoke(Variable result, Value function, BasicBlockRef to, BasicBlockRef unwind, Argument ... args) {
        super("invoke", result, function, args);
        this.to = to;
        this.unwind = unwind;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        result = 31 * result + (this.unwind == null ? 0 : this.unwind.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Invoke other = (Invoke)obj;
        if (this.to == null ? other.to != null : !this.to.equals(other.to)) {
            return false;
        }
        return !(this.unwind == null ? other.unwind != null : !this.unwind.equals(other.unwind));
    }

    @Override
    public void write(Writer writer) throws IOException {
        super.write(writer);
        writer.append(" to label %").append(this.to.toString()).append(" unwind label %").append(this.unwind.toString());
    }

    @Override
    public String toString() {
        return this.toString(this::write);
    }
}

