/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.Ordering;
import org.robovm.compiler.llvm.UnaryOpInstruction;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;

public class Load
extends UnaryOpInstruction {
    private final boolean _volatile;
    private final Ordering ordering;
    private final int alignment;

    public Load(Variable result, Value op) {
        this(result, op, false, null, -1);
    }

    public Load(Variable result, Value op, boolean _volatile) {
        this(result, op, _volatile, null, -1);
    }

    public Load(Variable result, Value op, boolean _volatile, Ordering ordering, int alignment) {
        super(result, op);
        this._volatile = _volatile;
        this.ordering = ordering;
        this.alignment = alignment;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.result.toString());
        writer.write(" = load ");
        if (this._volatile) {
            writer.write("volatile ");
        }
        if (this.ordering != null) {
            writer.write("atomic ");
        }
        this.op.getType().write(writer);
        writer.write(" ");
        this.op.write(writer);
        if (this.ordering != null) {
            writer.write(" ");
            writer.write(this.ordering.toString());
        }
        if (this.alignment > 0) {
            writer.write(", align ");
            writer.write(Integer.toString(this.alignment));
        }
    }

    public String toString() {
        return this.toString(this::write);
    }
}

