/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.robovm.compiler.llvm.Alias;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionDeclaration;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.NamedMetadata;
import org.robovm.compiler.llvm.UnnamedMetadata;
import org.robovm.compiler.llvm.UserType;
import org.robovm.compiler.llvm.Writable;

public class Module
implements Writable {
    private final Collection<URL> includes;
    private final Collection<Global> globals;
    private final Collection<Alias> aliases;
    private final Collection<Function> functions;
    private final Collection<FunctionDeclaration> functionDeclarations;
    private final Collection<UserType> types;
    private final Collection<String> asm;
    private final Collection<NamedMetadata> namedMetadata;
    private final Collection<UnnamedMetadata> unnamedMetadata;

    public Module(Collection<URL> includes, Collection<UserType> types, Collection<Global> globals, Collection<Alias> aliases, Collection<FunctionDeclaration> functionDeclarations, Collection<String> asm, Collection<Function> functions, Collection<NamedMetadata> namedMetadata, Collection<UnnamedMetadata> unnamedMetadata) {
        this.includes = includes;
        this.types = types;
        this.globals = globals;
        this.aliases = aliases;
        this.functionDeclarations = functionDeclarations;
        this.asm = asm;
        this.functions = functions;
        this.namedMetadata = namedMetadata;
        this.unnamedMetadata = unnamedMetadata;
    }

    @Override
    public void write(Writer writer) throws IOException {
        for (URL uRL : this.includes) {
            InputStream in = null;
            try {
                in = uRL.openStream();
                IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            writer.write("\n");
        }
        writer.write("\n");
        for (String string : this.asm) {
            writer.write("module asm \"");
            writer.write(string);
            writer.write("\"\n");
        }
        writer.write("\n");
        for (UserType userType : this.types) {
            writer.write(userType.getAlias());
            writer.write(" = type ");
            userType.writeDefinition(writer);
            writer.write("\n");
        }
        writer.write("\n");
        for (FunctionDeclaration functionDeclaration : this.functionDeclarations) {
            functionDeclaration.write(writer);
            writer.write("\n");
        }
        writer.write("\n");
        for (Global global : this.globals) {
            global.writeDefinition(writer);
            writer.write("\n");
        }
        writer.write("\n");
        for (Alias alias : this.aliases) {
            alias.writeDefinition(writer);
            writer.write("\n");
        }
        writer.write("\n");
        for (Function function : this.functions) {
            function.write(writer);
            writer.write("\n");
        }
        writer.write("\n");
        for (NamedMetadata namedMetadata : this.namedMetadata) {
            namedMetadata.write(writer);
            writer.write("\n");
        }
        writer.write("\n");
        for (UnnamedMetadata unnamedMetadata : this.unnamedMetadata) {
            unnamedMetadata.writeDefinition(writer);
            writer.write("\n");
        }
    }

    public String toString() {
        return this.toString(this::write);
    }
}

