/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Type;

public class VectorStructureType
extends StructureType {
    public VectorStructureType(int ownMembersOffset, Type ... types) {
        super(ownMembersOffset, 0, types);
    }

    public VectorStructureType(Type ... types) {
        super(types);
    }

    public VectorStructureType(String alias, Type ... types) {
        super(alias, types);
    }

    public boolean isVectorArray() {
        return this.types[0] instanceof StructureType;
    }

    @Override
    public void writeDefinition(Writer writer) throws IOException {
        if (this.types[0] instanceof StructureType) {
            StructureType st = (StructureType)this.types[0];
            writer.write("{ [");
            writer.write(Integer.toString(this.types.length));
            writer.write(" x ");
            st.writeDefinition(writer);
            writer.write("] }");
        } else {
            writer.write("<");
            writer.write(Integer.toString(this.types.length));
            writer.write(" x ");
            this.types[0].write(writer);
            writer.write(">");
        }
    }

    @Override
    public String getDefinition() {
        return this.toString(this::writeDefinition);
    }
}

