/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.PluginArguments;

public abstract class Plugin {
    public abstract PluginArguments getArguments();

    protected Map<String, String> parseArguments(Config config) {
        if (config.getPluginArguments() == null) {
            return Collections.emptyMap();
        }
        PluginArguments declaredArgs = this.getArguments();
        HashMap<String, String> args = new HashMap<String, String>();
        for (String arg : config.getPluginArguments()) {
            String[] tokens = arg.split("=");
            String[] argNameParts = tokens[0].split(":");
            String prefix = argNameParts[0];
            String argName = argNameParts[1];
            String value = "";
            if (tokens.length == 2) {
                value = tokens[1];
            }
            if (!declaredArgs.getPrefix().equals(prefix) || !declaredArgs.hasArgument(argName)) continue;
            args.put(argName, value);
        }
        return args;
    }

    protected String argumentValue(Map<String, String> arguments, String key, String defaultValue) {
        String v = arguments.get(key);
        return v != null ? v : defaultValue;
    }

    protected int argumentValue(Map<String, String> arguments, String key, int defaultValue) {
        String v = arguments.get(key);
        return v != null ? Integer.parseInt(v) : defaultValue;
    }

    protected boolean argumentValue(Map<String, String> arguments, String key, boolean defaultValue) {
        String v = arguments.get(key);
        return v != null ? Boolean.parseBoolean(v) : defaultValue;
    }
}

