/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.ios;

import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.cms.CMSSignedData;
import org.robovm.compiler.target.ios.SigningIdentity;
import org.xml.sax.SAXParseException;

public class ProvisioningProfile
implements Comparable<ProvisioningProfile> {
    private static final String HEX_DIGITS = "0123456789ABCDEF";
    private final Type type;
    private final File file;
    private final NSDictionary dict;
    private final String uuid;
    private final String name;
    private final String appIdName;
    private final String appIdPrefix;
    private final String appId;
    private final Date creationDate;
    private final Date expirationDate;
    private final NSDictionary entitlements;
    private final Set<String> certFingerprints = new TreeSet<String>();

    ProvisioningProfile(File file, NSDictionary dict) {
        this.file = file;
        this.dict = dict;
        this.uuid = dict.objectForKey("UUID").toString();
        this.name = dict.objectForKey("Name").toString();
        this.appIdName = dict.objectForKey("AppIDName") != null ? dict.objectForKey("AppIDName").toString() : null;
        this.appIdPrefix = ((NSArray)dict.objectForKey("ApplicationIdentifierPrefix")).objectAtIndex(0).toString();
        this.creationDate = ((NSDate)dict.objectForKey("CreationDate")).getDate();
        this.expirationDate = ((NSDate)dict.objectForKey("ExpirationDate")).getDate();
        this.entitlements = (NSDictionary)dict.objectForKey("Entitlements");
        this.appId = this.entitlements.objectForKey("application-identifier").toString();
        for (NSObject o : ((NSArray)dict.objectForKey("DeveloperCertificates")).getArray()) {
            NSData data = (NSData)o;
            this.certFingerprints.add(ProvisioningProfile.getCertFingerprint(data.bytes()));
        }
        boolean getTaskAllow = ((NSNumber)this.entitlements.objectForKey("get-task-allow")).boolValue();
        NSArray provisionedDevices = (NSArray)dict.objectForKey("ProvisionedDevices");
        this.type = getTaskAllow ? Type.Development : (provisionedDevices != null ? Type.AdHoc : Type.AppStore);
    }

    @Override
    public int compareTo(ProvisioningProfile o) {
        return this.name.compareToIgnoreCase(o.name);
    }

    private static String getCertFingerprint(byte[] certData) {
        try {
            CertificateFactory x509CertFact = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)x509CertFact.generateCertificate(new ByteArrayInputStream(certData));
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return ProvisioningProfile.toHexString(md.digest(cert.getEncoded()));
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(HEX_DIGITS.charAt((bytes[i] & 0xF0) >> 4));
            buf.append(HEX_DIGITS.charAt(bytes[i] & 0xF));
        }
        return buf.toString();
    }

    public Type getType() {
        return this.type;
    }

    public File getFile() {
        return this.file;
    }

    public NSDictionary getDict() {
        return this.dict;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getAppIdName() {
        return this.appIdName;
    }

    public String getAppIdPrefix() {
        return this.appIdPrefix;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public NSDictionary getEntitlements() {
        return this.entitlements;
    }

    public Set<String> getCertFingerprints() {
        return this.certFingerprints;
    }

    private static ProvisioningProfile create(File file) {
        ProvisioningProfile provisioningProfile;
        BufferedInputStream in = null;
        try {
            NSDictionary dict;
            in = new BufferedInputStream(new FileInputStream(file));
            CMSSignedData data = new CMSSignedData((InputStream)in);
            byte[] content = (byte[])data.getSignedContent().getContent();
            try {
                dict = (NSDictionary)PropertyListParser.parse((byte[])content);
            }
            catch (SAXParseException ignored) {
                dict = (NSDictionary)PropertyListParser.parse((byte[])ProvisioningProfile.fixInvalidXmlChars(content));
            }
            provisioningProfile = new ProvisioningProfile(file, dict);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return provisioningProfile;
    }

    public static List<ProvisioningProfile> list() {
        File dir = new File(new File(System.getProperty("user.home")), "Library/MobileDevice/Provisioning Profiles");
        if (!dir.exists() || !dir.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<ProvisioningProfile> result = new ArrayList<ProvisioningProfile>();
        for (File f : dir.listFiles()) {
            if (!f.getName().endsWith(".mobileprovision")) continue;
            try {
                ProvisioningProfile p = ProvisioningProfile.create(f);
                if (!p.expirationDate.after(new Date())) continue;
                result.add(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Collections.sort(result);
        return result;
    }

    public static ProvisioningProfile find(List<ProvisioningProfile> profiles, String search) {
        for (ProvisioningProfile p : profiles) {
            if (!p.uuid.equals(search) && !p.appIdPrefix.equals(search) && (p.appIdName == null || !p.appIdName.equals(search)) && !p.name.equals(search)) continue;
            return p;
        }
        throw new IllegalArgumentException("No provisioning profile found matching '" + search + "'");
    }

    public static ProvisioningProfile find(List<ProvisioningProfile> profiles, SigningIdentity signingIdentity, String bundleId) {
        Pair<SigningIdentity, ProvisioningProfile> pair = ProvisioningProfile.find(profiles, Collections.singletonList(signingIdentity), bundleId, true);
        return (ProvisioningProfile)pair.getRight();
    }

    public static Pair<SigningIdentity, ProvisioningProfile> find(List<ProvisioningProfile> profiles, List<SigningIdentity> identities, String bundleId) {
        return ProvisioningProfile.find(profiles, identities, bundleId, false);
    }

    private static Pair<SigningIdentity, ProvisioningProfile> find(List<ProvisioningProfile> profiles, List<SigningIdentity> identities, String bundleId, boolean exactIdentityMatch) {
        HashSet<String> knownFingerprints = new HashSet<String>();
        for (SigningIdentity i : identities) {
            knownFingerprints.add(i.getFingerprint());
        }
        ProvisioningProfile longestWildCard = null;
        ProvisioningProfile exactProfile = null;
        for (ProvisioningProfile p : profiles) {
            String bundleIdWithPrefix = p.appIdPrefix + "." + bundleId;
            if (p.appId.equals(bundleIdWithPrefix)) {
                if (Collections.disjoint(knownFingerprints, p.certFingerprints)) continue;
                exactProfile = p;
                break;
            }
            if (!p.appId.endsWith(".*") || longestWildCard != null && p.appId.length() <= longestWildCard.appId.length() || !bundleIdWithPrefix.startsWith(p.appId.substring(0, p.appId.length() - 1)) || Collections.disjoint(knownFingerprints, p.certFingerprints)) continue;
            longestWildCard = p;
        }
        if (exactProfile == null) {
            exactProfile = longestWildCard;
        }
        if (exactProfile == null) {
            if (exactIdentityMatch) {
                throw new IllegalArgumentException("No provisioning profile found matching signing identity '" + identities.get(0).getName() + "' and app bundle ID '" + bundleId + "'");
            }
            throw new IllegalArgumentException("No provisioning profile and signing identity found that matches bundle ID '" + bundleId + "'");
        }
        for (SigningIdentity identity : identities) {
            if (!exactProfile.certFingerprints.contains(identity.getFingerprint())) continue;
            return new ImmutablePair((Object)identity, (Object)exactProfile);
        }
        throw new Error("Shell never happen");
    }

    private static byte[] fixInvalidXmlChars(byte[] content) {
        boolean broken = false;
        String str = new String(content);
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c >= '\u0001' && c <= '\b' || c == '\u000b' || c == '\f' || c >= '\u000e' && c <= '\u001f' || c >= '\u007f' && c <= '\u0084' || c >= '\u0086' && c <= '\u009f') {
                broken = true;
                continue;
            }
            sb.append(c);
        }
        if (broken) {
            return sb.toString().getBytes();
        }
        return content;
    }

    public String toString() {
        return "ProvisioningProfile [type=" + this.type + ", file=" + this.file + ", uuid=" + this.uuid + ", name=" + this.name + ", appIdName=" + this.appIdName + ", appIdPrefix=" + this.appIdPrefix + ", appId=" + this.appId + ", creationDate=" + this.creationDate + ", expirationDate=" + this.expirationDate + ", certFingerprints=" + this.certFingerprints + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisioningProfile other = (ProvisioningProfile)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(ProvisioningProfile.list());
        } else if (args.length == 1) {
            System.out.println(ProvisioningProfile.find(ProvisioningProfile.list(), args[0]));
        } else {
            System.out.println(ProvisioningProfile.find(ProvisioningProfile.list(), SigningIdentity.find(SigningIdentity.list(), args[0]), args[1]));
        }
    }

    public static enum Type {
        Development,
        AppStore,
        AdHoc;

    }
}

