/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.trampoline;

import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.trampoline.FieldAccessor;
import org.robovm.compiler.trampoline.Trampoline;

public class PutField
extends FieldAccessor {
    private static final long serialVersionUID = 1L;
    private final String runtimeClass;

    public PutField(String callingClass, String targetClass, String fieldName, String fieldDesc, String runtimeClass) {
        super(callingClass, targetClass, fieldName, fieldDesc);
        this.runtimeClass = runtimeClass;
    }

    @Override
    public boolean isGetter() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    public String getRuntimeClass() {
        return this.runtimeClass;
    }

    @Override
    public FunctionType getFunctionType() {
        return new FunctionType((Type)Type.VOID, Types.ENV_PTR, Types.OBJECT_PTR, Types.getType(this.fieldDesc));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.runtimeClass == null ? 0 : this.runtimeClass.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PutField other = (PutField)obj;
        return !(this.runtimeClass == null ? other.runtimeClass != null : !this.runtimeClass.equals(other.runtimeClass));
    }

    @Override
    public int compareTo(Trampoline o) {
        int c = super.compareTo(o);
        if (c == 0) {
            c = this.runtimeClass.compareTo(((PutField)o).runtimeClass);
        }
        return c;
    }

    @Override
    public String toString() {
        return Symbols.trampolineFieldSymbol(this, this.getCallingClass(), this.getTarget(), this.getFieldName(), this.getFieldDesc(), this.runtimeClass);
    }
}

