/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.XMLPropertyListParser;
import java.io.File;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PList {
    private final File file;
    protected NSDictionary dictionary;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([^}]+)\\}");

    public PList(File file) {
        this.file = file;
    }

    public PList parse(Properties props) {
        return this.parse(props, true);
    }

    public PList parse(Properties props, boolean includeSystemProperties) {
        try {
            this.dictionary = (NSDictionary)PList.parsePropertyList(this.file, props, includeSystemProperties);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to parse Info.plist XML file: " + this.file, t);
        }
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public NSDictionary getDictionary() {
        return this.dictionary;
    }

    static void replacePropertyRefs(Node node, BiFunction<String, String, String> props) {
        Text el;
        String value;
        if (node instanceof Text && (value = (el = (Text)node).getNodeValue()) != null && value.trim().length() > 0) {
            Matcher matcher = VARIABLE_PATTERN.matcher(value);
            StringBuilder sb = new StringBuilder();
            int pos = 0;
            while (matcher.find()) {
                if (pos < matcher.start()) {
                    sb.append(value, pos, matcher.start());
                }
                String key = matcher.group(1);
                sb.append(props.apply(key, matcher.group()));
                pos = matcher.end();
            }
            if (pos < value.length()) {
                sb.append(value.substring(pos));
            }
            el.setNodeValue(sb.toString());
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            PList.replacePropertyRefs(children.item(i), props);
        }
    }

    static NSObject parsePropertyList(File file, Properties props, boolean includeSystemProperties) throws Exception {
        Properties sysProps = System.getProperties();
        BiFunction<String, String, String> propSupplier = !includeSystemProperties ? props::getProperty : (key, defValue) -> {
            String v = props.getProperty((String)key);
            if (v == null) {
                v = sysProps.getProperty((String)key, (String)defValue);
            }
            return v;
        };
        DocumentBuilder docBuilder = XMLPropertyListParser.getDocBuilder();
        Document doc = docBuilder.parse(file);
        PList.replacePropertyRefs(doc, propSupplier);
        return XMLPropertyListParser.parse((Document)doc);
    }
}

