/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.config.tools.ActoolOptions;
import org.robovm.compiler.config.tools.TextureAtlas;
import org.robovm.compiler.log.ConsoleLogger;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.target.ios.IOSTarget;
import org.robovm.compiler.util.Executor;

public class ToolchainUtil {
    private static String IOS_DEV_CLANG;
    private static String IOS_SIM_CLANG;
    private static String PNGCRUSH;
    private static String PLUTIL;
    private static String LIPO;
    private static String BITCODE_STRIP;
    private static String PACKAGE_APPLICATION;
    private static String TEXTUREATLAS;
    private static String ACTOOL;
    private static String IBTOOL;
    private static String NM;
    private static String OTOOL;
    private static String FILE;
    private static String DSYMUTIL;
    private static String SYMBOLS;

    private static String getIOSDevClang() throws IOException {
        if (IOS_DEV_CLANG == null) {
            IOS_DEV_CLANG = ToolchainUtil.findXcodeCommand("clang++", "iphoneos");
        }
        return IOS_DEV_CLANG;
    }

    private static String getIOSSimClang() throws IOException {
        if (IOS_SIM_CLANG == null) {
            IOS_SIM_CLANG = ToolchainUtil.findXcodeCommand("clang++", "iphonesimulator");
        }
        return IOS_SIM_CLANG;
    }

    private static String getPngCrush() throws IOException {
        if (PNGCRUSH == null) {
            PNGCRUSH = ToolchainUtil.findXcodeCommand("pngcrush", "iphoneos");
        }
        return PNGCRUSH;
    }

    private static String getTextureAtlas() throws IOException {
        if (TEXTUREATLAS == null) {
            TEXTUREATLAS = ToolchainUtil.findXcodeCommand("TextureAtlas", "iphoneos");
        }
        return TEXTUREATLAS;
    }

    private static String getACTool() throws IOException {
        if (ACTOOL == null) {
            ACTOOL = ToolchainUtil.findXcodeCommand("actool", "iphoneos");
        }
        return ACTOOL;
    }

    private static String getIBTool() throws IOException {
        if (IBTOOL == null) {
            IBTOOL = ToolchainUtil.findXcodeCommand("ibtool", "iphoneos");
        }
        return IBTOOL;
    }

    private static String getPlutil() throws IOException {
        if (PLUTIL == null) {
            PLUTIL = ToolchainUtil.findXcodeCommand("plutil", "iphoneos");
        }
        return PLUTIL;
    }

    private static String getLipo() throws IOException {
        if (LIPO == null) {
            LIPO = ToolchainUtil.findXcodeCommand("lipo", "iphoneos");
        }
        return LIPO;
    }

    private static String getBitcodeStrip() throws IOException {
        if (BITCODE_STRIP == null) {
            BITCODE_STRIP = ToolchainUtil.findXcodeCommand("bitcode_strip", "iphoneos");
        }
        return BITCODE_STRIP;
    }

    private static String getNm() throws IOException {
        if (NM == null) {
            NM = ToolchainUtil.findXcodeCommand("nm", "iphoneos");
        }
        return NM;
    }

    private static String getOtool() throws IOException {
        if (OTOOL == null) {
            OTOOL = ToolchainUtil.findXcodeCommand("otool", "iphoneos");
        }
        return OTOOL;
    }

    private static String getFile() throws IOException {
        if (FILE == null) {
            FILE = ToolchainUtil.findXcodeCommand("file", "iphoneos");
        }
        return FILE;
    }

    private static String getPackageApplication() throws IOException {
        if (PACKAGE_APPLICATION == null) {
            PACKAGE_APPLICATION = ToolchainUtil.findXcodeCommand("PackageApplication", "iphoneos");
        }
        return PACKAGE_APPLICATION;
    }

    private static String getDsymutil() throws IOException {
        if (DSYMUTIL == null) {
            DSYMUTIL = ToolchainUtil.findXcodeCommand("dsymutil", "iphoneos");
        }
        return DSYMUTIL;
    }

    private static String getSymbols() throws IOException {
        if (SYMBOLS == null) {
            SYMBOLS = ToolchainUtil.findXcodeCommand("symbols", "iphoneos");
        }
        return SYMBOLS;
    }

    private static void handleExecuteException(ExecuteException e) {
        if (e.getExitValue() == 2) {
            throw new IllegalArgumentException("No Xcode is selected. Is Xcode installed? If yes, use 'sudo xcode-select -switch <path-to-xcode>' from a Terminal to switch to the correct Xcode path.");
        }
        if (e.getExitValue() == 69) {
            throw new IllegalArgumentException("You must agree to the Xcode/iOS license. Please open Xcode once or run 'sudo xcrun clang' from a Terminal to agree to the terms.");
        }
        throw new IllegalArgumentException(e.getMessage());
    }

    public static String findXcodePath() throws IOException {
        try {
            String path = new Executor(Logger.NULL_LOGGER, "xcode-select").args("--print-path").execCapture();
            File f = new File(path);
            if (f.exists() && f.isDirectory() && new File(f, "Platforms").exists() && new File(f, "Toolchains").exists()) {
                return path;
            }
            throw new IllegalArgumentException(String.format("The path '%s' does not appear to be a valid Xcode path. Use 'sudo xcode-select -switch <path-to-xcode>' from a Terminal to switch to the correct Xcode path.", path));
        }
        catch (ExecuteException e) {
            ToolchainUtil.handleExecuteException(e);
            return null;
        }
    }

    public static boolean isXcodeInstalled() {
        try {
            ToolchainUtil.findXcodePath();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String findXcodeCommand(String cmd, String sdk) throws IOException {
        try {
            return new Executor(Logger.NULL_LOGGER, "xcrun").args("-sdk", sdk, "-f", cmd).execCapture();
        }
        catch (ExecuteException e) {
            ToolchainUtil.handleExecuteException(e);
            return null;
        }
    }

    public static void pngcrush(Config config, File inFile, File outFile) throws IOException {
        new Executor(config.getLogger(), ToolchainUtil.getPngCrush()).args("-q", "-iphone", "-f", "0", inFile, outFile).exec();
    }

    public static void textureatlas(Config config, File inDir, File outDir) throws IOException {
        ArrayList<String> opts = new ArrayList<String>();
        int outputFormat = 1;
        int maxTextureDimension = 1;
        if (config.getTools() != null && config.getTools().getTextureAtlas() != null) {
            TextureAtlas atlasConfig = config.getTools().getTextureAtlas();
            outputFormat = 1 + atlasConfig.getOutputFormat().ordinal();
            maxTextureDimension = 1 + atlasConfig.getMaximumTextureDimension().ordinal();
            if (atlasConfig.usePowerOfTwo()) {
                opts.add("-p");
            }
        }
        new Executor(config.getLogger(), ToolchainUtil.getTextureAtlas()).args(opts, "-f", outputFormat, "-s", maxTextureDimension, inDir, outDir).exec();
    }

    public static void actool(Config config, File partialInfoPlist, File outDir, File inDir) throws IOException {
        ToolchainUtil.actool(config, partialInfoPlist, outDir, Collections.singletonList(inDir));
    }

    public static void actool(Config config, File partialInfoPlist, File outDir, List<File> inDirs) throws IOException {
        String v;
        ArrayList<String> availableImages;
        ArrayList<Object> opts = new ArrayList<Object>();
        String appIconSetName = null;
        boolean appIconSetNameByArgs = false;
        String launchImagesName = null;
        boolean launchImagesNameByArgs = false;
        boolean includeAllAppIcons = false;
        if (config.getTools() != null && config.getTools().getActool() != null) {
            ActoolOptions options = config.getTools().getActool();
            opts.addAll(options.getArguments());
            appIconSetNameByArgs = opts.contains("--app-icon");
            launchImagesNameByArgs = opts.contains("--launch-image");
            includeAllAppIcons = options.shouldIncludeAllAppIcons();
            appIconSetName = appIconSetNameByArgs ? null : options.getAppIconName();
            launchImagesName = launchImagesNameByArgs ? null : options.getLaunchImageName();
        }
        ArrayList<String> availableIcons = appIconSetName == null && !appIconSetNameByArgs ? new ArrayList<String>() : null;
        ArrayList<String> arrayList = availableImages = launchImagesName == null && !launchImagesNameByArgs ? new ArrayList<String>() : null;
        if (availableIcons != null || availableImages != null) {
            String appiconset = "appiconset";
            String launchimage = "launchimage";
            for (File inDir : inDirs) {
                for (String fileName : inDir.list()) {
                    String ext = FilenameUtils.getExtension((String)fileName);
                    if (ext.equals("appiconset")) {
                        if (availableIcons == null) continue;
                        availableIcons.add(FilenameUtils.getBaseName((String)fileName));
                        continue;
                    }
                    if (!ext.equals("launchimage") || availableImages == null) continue;
                    availableImages.add(FilenameUtils.getBaseName((String)fileName));
                }
            }
            if (availableIcons != null && availableIcons.size() >= 1) {
                appIconSetName = (String)availableIcons.get(0);
                if (availableIcons.size() > 1) {
                    config.getLogger().error("actool: multiple .appiconset found but %s will be used", appIconSetName);
                }
            }
            if (availableImages != null && availableImages.size() >= 1) {
                launchImagesName = (String)availableImages.get(0);
                if (availableImages.size() > 1) {
                    config.getLogger().error("actool: multiple .launchimage found but %s will be used", launchImagesName);
                }
            }
        }
        if (appIconSetName != null) {
            opts.add("--app-icon");
            opts.add(appIconSetName);
            appIconSetNameByArgs = true;
        }
        if (launchImagesName != null) {
            opts.add("--launch-image");
            opts.add(launchImagesName);
            launchImagesNameByArgs = true;
        }
        if (appIconSetNameByArgs || launchImagesNameByArgs) {
            opts.add("--output-partial-info-plist");
            opts.add(partialInfoPlist);
        }
        if (includeAllAppIcons) {
            opts.add("--include-all-app-icons");
        }
        opts.add("--platform");
        if (IOSTarget.isDeviceArch(config.getArch())) {
            opts.add("iphoneos");
        } else if (IOSTarget.isSimulatorArch(config.getArch())) {
            opts.add("iphonesimulator");
        }
        String minOSVersion = config.getOs().getMinVersion();
        if (config.getIosInfoPList() != null && (v = config.getIosInfoPList().getMinimumOSVersion()) != null) {
            minOSVersion = v;
        }
        opts.add("--export-dependency-info");
        opts.add(config.getTmpDir().getAbsolutePath() + "/assetcatalog_dependencies");
        new Executor(config.getLogger(), ToolchainUtil.getACTool()).args("--output-format", "human-readable-text", opts, "--minimum-deployment-target", minOSVersion, "--target-device", "iphone", "--target-device", "ipad", "--compress-pngs", "--compile", outDir, inDirs).exec();
    }

    public static void ibtool(Config config, File partialInfoPlist, File inFile, File outFile) throws IOException {
        String v;
        String minOSVersion = config.getOs().getMinVersion();
        if (config.getIosInfoPList() != null && (v = config.getIosInfoPList().getMinimumOSVersion()) != null) {
            minOSVersion = v;
        }
        Executor executor = new Executor(config.getLogger(), ToolchainUtil.getIBTool()).args("--target-device", "iphone", "--target-device", "ipad", "--minimum-deployment-target", minOSVersion, "--output-partial-info-plist", partialInfoPlist, "--auto-activate-custom-fonts", "--output-format", "human-readable-text");
        if (outFile.isDirectory()) {
            executor.args("--compilation-directory", outFile);
        } else {
            executor.args("--compile", outFile);
        }
        executor.args(inFile).exec();
    }

    public static void compileStrings(Config config, File inFile, File outFile) throws IOException {
        new Executor(config.getLogger(), ToolchainUtil.getPlutil()).args("-convert", "binary1", inFile, "-o", outFile).exec();
    }

    public static void decompileXml(Config config, File inFile, File outFile) throws IOException {
        new Executor(Logger.NULL_LOGGER, ToolchainUtil.getPlutil()).args("-convert", "xml1", inFile, "-o", outFile).exec();
    }

    public static String nm(File file) throws IOException {
        return new Executor(Logger.NULL_LOGGER, ToolchainUtil.getNm()).args(file.getAbsolutePath()).execCapture();
    }

    public static String otool(File file) throws IOException {
        return new Executor((Logger)new ConsoleLogger(false), ToolchainUtil.getOtool()).args("-L", file.getAbsolutePath()).execCapture();
    }

    public static void lipo(Config config, File outFile, List<File> inFiles) throws IOException {
        new Executor(config.getLogger(), ToolchainUtil.getLipo()).args(inFiles, "-create", "-output", outFile).exec();
    }

    public static void lipoRemoveArchs(Config config, File inFile, File outFile, String ... archs) throws IOException {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(inFile);
        for (String arch : archs) {
            args.add("-remove");
            args.add(arch);
        }
        args.add("-output");
        args.add(outFile);
        new Executor(config.getLogger(), ToolchainUtil.getLipo()).args(args).exec();
    }

    public static void bitcodeStrip(Config config, File inFile, File outFile) throws IOException {
        new Executor(config.getLogger(), ToolchainUtil.getBitcodeStrip()).args(inFile, "-r", "-o", outFile).exec();
    }

    public static String lipoInfo(Config config, File inFile) throws IOException {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("-info");
        args.add(inFile);
        return new Executor(Logger.NULL_LOGGER, ToolchainUtil.getLipo()).args(args).execCapture();
    }

    public static String file(File file) throws IOException {
        return new Executor(Logger.NULL_LOGGER, ToolchainUtil.getFile()).args(file).execCapture();
    }

    public static void packageApplication(Config config, File appDir, File outFile) throws IOException {
        new Executor(config.getLogger(), ToolchainUtil.getPackageApplication()).args(appDir, "-o", outFile).exec();
    }

    public static void generateDsym(Config config, File dsymDir, File exePath) throws IOException {
        new Executor(config.getLogger(), ToolchainUtil.getDsymutil()).args("-o", dsymDir, exePath).exec();
    }

    public static void dsymToSymbols(Config config, File dsymExecutable, File outDir) throws IOException {
        new Executor(config.getLogger(), ToolchainUtil.getSymbols()).args("-noTextInSOD", "-noDaemon", "-arch", "all", "-symbolsPackageDir", outDir, dsymExecutable).exec();
    }

    private static List<File> writeObjectsFiles(Config config, List<File> objectFiles, int maxObjectsPerFile, boolean quote) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        int i = 0;
        for (int start = 0; start < objectFiles.size(); start += maxObjectsPerFile) {
            List<File> partition = objectFiles.subList(start, Math.min(objectFiles.size(), start + maxObjectsPerFile));
            ArrayList<CallSite> paths = new ArrayList<CallSite>();
            for (File f : partition) {
                paths.add((CallSite)((Object)((quote ? "\"" : "") + f.getAbsolutePath() + (quote ? "\"" : ""))));
            }
            File objectsFile = new File(config.getTmpDir(), "objects" + i);
            FileUtils.writeLines((File)objectsFile, paths, (String)"\n");
            files.add(objectsFile);
            ++i;
        }
        return files;
    }

    public static void link(Config config, List<String> args, List<File> objectFiles, List<String> libs, File outFile) throws IOException {
        boolean isDarwin = config.getOs().getFamily() == OS.Family.darwin;
        List<File> objectsFiles = ToolchainUtil.writeObjectsFiles(config, objectFiles, isDarwin ? 65535 : Integer.MAX_VALUE, !isDarwin);
        ArrayList<Object> opts = new ArrayList<Object>();
        if (config.isDebug()) {
            opts.add("-g");
        }
        if (isDarwin) {
            for (File objectsFile : objectsFiles) {
                opts.add("-Wl,-filelist," + objectsFile.getAbsolutePath());
            }
        } else {
            opts.add(config.getArch().is32Bit() ? "-m32" : "-m64");
            for (File objectsFile : objectsFiles) {
                opts.add("@" + objectsFile.getAbsolutePath());
            }
        }
        opts.addAll(args);
        new Executor(config.getLogger(), ToolchainUtil.getCcPath(config)).args("-o", outFile, opts, libs).exec();
    }

    private static String getCcPath(Config config) throws IOException {
        String ccPath;
        String string = ccPath = config.getOs().getFamily() == OS.Family.darwin ? "clang++" : "g++";
        if (config.getCcBinPath() != null) {
            ccPath = config.getCcBinPath().getAbsolutePath();
        } else if (config.getOs() == OS.ios) {
            ccPath = ToolchainUtil.getIOSDevClang();
        }
        return ccPath;
    }
}

