/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.Bro;
import org.robovm.compiler.BroMethodCompiler;
import org.robovm.compiler.Functions;
import org.robovm.compiler.MarshalerLookup;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.llvm.Alloca;
import org.robovm.compiler.llvm.Argument;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.Bitcast;
import org.robovm.compiler.llvm.Br;
import org.robovm.compiler.llvm.DataLayout;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionDeclaration;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.Icmp;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.Inttoptr;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.Load;
import org.robovm.compiler.llvm.NullConstant;
import org.robovm.compiler.llvm.ParameterAttribute;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.PrimitiveType;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Unreachable;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;
import org.robovm.compiler.trampoline.Invokestatic;
import soot.LongType;
import soot.SootMethod;
import soot.tagkit.AnnotationTag;
import soot.tagkit.Host;

public class BridgeMethodCompiler
extends BroMethodCompiler {
    public BridgeMethodCompiler(Config config) {
        super(config);
    }

    private void validateBridgeMethod(SootMethod method) {
        if (!method.isNative()) {
            throw new IllegalArgumentException("@Bridge annotated method " + method + " must be native");
        }
        AnnotationTag bridgeAnnotation = Annotations.getAnnotation((Host)method, "Lorg/robovm/rt/bro/annotation/Bridge;");
        if (!(!Annotations.readBooleanElem(bridgeAnnotation, "dynamic", false) || method.isStatic() && method.getParameterCount() != 0 && method.getParameterType(0) == LongType.v() && Annotations.hasParameterAnnotation(method, 0, "Lorg/robovm/rt/bro/annotation/Pointer;"))) {
            throw new IllegalArgumentException("Dynamic @Bridge annotated method " + method + " must be static and take a @Pointer long as first parameter");
        }
        if (Annotations.hasVariadicAnnotation(method)) {
            int first = Annotations.getVariadicParameterIndex(method);
            if (first < 0) {
                throw new IllegalArgumentException("Invalid @Variadic index on @Bridge annotated method " + method + ". Index must be 0 or greater.");
            }
            if (method.isStatic() && first == 0) {
                throw new IllegalArgumentException("At least 1 parameter must come before the first va_arg parameter on static @Bridge annotated method " + method);
            }
            for (int i = first; i < method.getParameterCount(); ++i) {
                if (!Bro.isPassByValue(method, i)) continue;
                throw new IllegalArgumentException("Parameter " + (i + 1) + " of @Bridge annotated method " + method + " cannot be passed @ByVal when part of a va_arg parameter list");
            }
        }
    }

    protected static FunctionRef getBridgeCWrapperRef(FunctionType functionType, String name) {
        Type returnType = functionType.getReturnType();
        Type wrapperReturnType = returnType instanceof StructureType ? Type.VOID : returnType;
        ArrayList<Type> wrapperParamTypes = new ArrayList<Type>();
        wrapperParamTypes.add(Type.I8_PTR);
        if (returnType instanceof StructureType) {
            wrapperParamTypes.add(Type.I8_PTR);
        }
        for (Type t : functionType.getParameterTypes()) {
            if (t instanceof StructureType || t instanceof PointerType) {
                wrapperParamTypes.add(Type.I8_PTR);
                continue;
            }
            wrapperParamTypes.add(t);
        }
        FunctionType wrapperFnType = new FunctionType(wrapperReturnType, wrapperParamTypes.toArray(new Type[wrapperParamTypes.size()]));
        return new FunctionRef(name, wrapperFnType);
    }

    protected static String createBridgeCWrapper(Type returnType, Type[] hiParameterTypes, Type[] loParameterTypes, String name) {
        if (hiParameterTypes.length != loParameterTypes.length) {
            if (hiParameterTypes.length < loParameterTypes.length) {
                throw new IllegalArgumentException("For va_arg functions lo's types parameter types must be a prefix of the hi type's parameters");
            }
            if (!Arrays.asList(hiParameterTypes).subList(0, loParameterTypes.length).equals(Arrays.asList(loParameterTypes))) {
                throw new IllegalArgumentException("For va_arg functions lo's types parameter types must be a prefix of the hi type's parameters");
            }
        } else if (!Arrays.equals(hiParameterTypes, loParameterTypes)) {
            throw new IllegalArgumentException("hi and lo parameter types must be equal");
        }
        TreeMap<String, String> typedefs = new TreeMap<String, String>(Collections.reverseOrder());
        String hiReturnType = returnType instanceof StructureType ? "void" : BridgeMethodCompiler.getHiType(returnType);
        StringBuilder hiSignature = new StringBuilder();
        hiSignature.append(hiReturnType).append(' ').append(name).append("(void* target");
        if (returnType instanceof StructureType) {
            hiSignature.append(", void* ret");
        }
        StringBuilder loSignature = new StringBuilder();
        String loReturnType = BridgeMethodCompiler.getLoType(returnType, name, 0, typedefs);
        loSignature.append(loReturnType).append(' ').append("(*)(");
        StringBuilder body = new StringBuilder(" {\n");
        StringBuilder args = new StringBuilder();
        for (int i = 0; i < hiParameterTypes.length; ++i) {
            String arg = "p" + i;
            if (i > 0) {
                args.append(", ");
            }
            String hiParamType = BridgeMethodCompiler.getHiType(hiParameterTypes[i]);
            hiSignature.append(", ");
            hiSignature.append(hiParamType).append(' ').append(arg);
            if (i < loParameterTypes.length) {
                String loParamType = BridgeMethodCompiler.getLoType(hiParameterTypes[i], name, i + 1, typedefs);
                if (i > 0) {
                    loSignature.append(", ");
                }
                loSignature.append(loParamType);
                if (hiParameterTypes[i] instanceof StructureType) {
                    args.append("*((").append(loParamType).append("*)").append(arg).append(')');
                    continue;
                }
                args.append(arg);
                continue;
            }
            args.append(arg);
        }
        hiSignature.append(')');
        if (loParameterTypes.length == 0) {
            loSignature.append("void");
        } else if (loParameterTypes.length < hiParameterTypes.length) {
            loSignature.append(", ...");
        }
        loSignature.append(')');
        String intend = "    ";
        for (String typedef : typedefs.values()) {
            body.append("    " + typedef.replace("\n", "\n    ") + "\n");
        }
        if (returnType instanceof StructureType) {
            body.append("    *((" + loReturnType + "*)ret) = ((" + loSignature + ") target)(" + args + ");\n");
        } else if (returnType != Type.VOID) {
            body.append("    return ((" + loSignature + ") target)(" + args + ");\n");
        } else {
            body.append("    ((" + loSignature + ") target)(" + args + ");\n");
        }
        body.append("}\n");
        return hiSignature.toString() + body.toString();
    }

    @Override
    protected Function doCompile(ModuleBuilder moduleBuilder, SootMethod method) {
        Variable tmp;
        this.validateBridgeMethod(method);
        AnnotationTag bridgeAnnotation = Annotations.getAnnotation((Host)method, "Lorg/robovm/rt/bro/annotation/Bridge;");
        boolean dynamic = Annotations.readBooleanElem(bridgeAnnotation, "dynamic", false);
        boolean optional = Annotations.readBooleanElem(bridgeAnnotation, "optional", false);
        boolean useCWrapper = this.requiresCWrapper(method);
        Function fn = this.createMethodFunction(method);
        moduleBuilder.addFunction(fn);
        Type[] parameterTypes = fn.getType().getParameterTypes();
        String[] parameterNames = fn.getParameterNames();
        ArrayList<Argument> args = new ArrayList<Argument>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            args.add(new Argument(new VariableRef(parameterNames[i], parameterTypes[i]), new ParameterAttribute[0]));
        }
        VariableRef env = fn.getParameterRef(0);
        Variable targetFn = fn.newVariable(Type.I8_PTR);
        if (!dynamic) {
            Global targetFnPtr = new Global(Symbols.bridgePtrSymbol(method), Linkage._private, new NullConstant(Type.I8_PTR));
            moduleBuilder.addGlobal(targetFnPtr);
            fn.add(new Load(targetFn, targetFnPtr.ref()));
            Label nullLabel = new Label();
            Label notNullLabel = new Label();
            Variable nullCheck = fn.newVariable(Type.I1);
            fn.add(new Icmp(nullCheck, Icmp.Condition.eq, targetFn.ref(), new NullConstant(Type.I8_PTR)));
            fn.add(new Br(nullCheck.ref(), fn.newBasicBlockRef(nullLabel), fn.newBasicBlockRef(notNullLabel)));
            fn.newBasicBlock(nullLabel);
            Functions.call(fn, (Value)(optional ? Functions.BC_THROW_UNSATISIFED_LINK_ERROR_OPTIONAL_BRIDGE_NOT_BOUND : Functions.BC_THROW_UNSATISIFED_LINK_ERROR_BRIDGE_NOT_BOUND), env, moduleBuilder.getString(this.className), moduleBuilder.getString(method.getName()), moduleBuilder.getString(Types.getDescriptor(method)));
            fn.add(new Unreachable());
            fn.newBasicBlock(notNullLabel);
        } else {
            fn.add(new Inttoptr(targetFn, fn.getParameterRef(1), targetFn.getType()));
            args.remove(1);
        }
        args.remove(0);
        ArrayList<BroMethodCompiler.MarshaledArg> marshaledArgs = new ArrayList<BroMethodCompiler.MarshaledArg>();
        FunctionType targetFnType = this.getBridgeFunctionType(method, dynamic, false);
        Type[] targetParameterTypes = targetFnType.getParameterTypes();
        if (!method.isStatic()) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, -2));
            Type nativeType = targetParameterTypes[0];
            if (nativeType instanceof PrimitiveType) {
                Value nativeValue = this.marshalValueObjectToNative(fn, marshalerMethod, nativeType, env, ((Argument)args.get(0)).getValue(), 0L);
                args.set(0, new Argument(nativeValue, new ParameterAttribute[0]));
            } else {
                BroMethodCompiler.MarshaledArg marshaledArg = new BroMethodCompiler.MarshaledArg();
                marshaledArg.paramIndex = -2;
                marshaledArgs.add(marshaledArg);
                Value nativeValue = this.marshalObjectToNative(fn, marshalerMethod, marshaledArg, useCWrapper ? Type.I8_PTR : nativeType, env, ((Argument)args.get(0)).getValue(), 0L);
                args.set(0, new Argument(nativeValue, new ParameterAttribute[0]));
            }
        }
        int argIdx = 0;
        for (int i = 0; i < method.getParameterCount(); ++i) {
            soot.Type type;
            if (dynamic && i == 0) continue;
            if (!method.isStatic() && argIdx == 0) {
                ++argIdx;
            }
            if (Bro.needsMarshaler(type = method.getParameterType(i))) {
                MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, i));
                Type nativeType = targetParameterTypes[argIdx];
                if (nativeType instanceof PrimitiveType) {
                    Value nativeValue = this.marshalValueObjectToNative(fn, marshalerMethod, nativeType, env, ((Argument)args.get(argIdx)).getValue(), 0L);
                    args.set(argIdx, new Argument(nativeValue, new ParameterAttribute[0]));
                } else {
                    ParameterAttribute[] parameterAttributes = new ParameterAttribute[]{};
                    if (Bro.isPassByValue(method, i) || Bro.isStructRet(method, i)) {
                        Functions.call(fn, (Value)Functions.CHECK_NULL, env, ((Argument)args.get(argIdx)).getValue());
                    }
                    BroMethodCompiler.MarshaledArg marshaledArg = new BroMethodCompiler.MarshaledArg();
                    marshaledArg.paramIndex = i;
                    marshaledArgs.add(marshaledArg);
                    Value nativeValue = this.marshalObjectToNative(fn, marshalerMethod, marshaledArg, useCWrapper ? Type.I8_PTR : nativeType, env, args.get(argIdx).getValue(), 0L);
                    args.set(argIdx, new Argument(nativeValue, parameterAttributes));
                }
            } else {
                args.set(argIdx, new Argument(this.marshalPrimitiveToNative(fn, method, i, ((Argument)args.get(argIdx)).getValue()), new ParameterAttribute[0]));
            }
            ++argIdx;
        }
        Variable structResult = null;
        Value targetFnRef = null;
        if (useCWrapper) {
            args.add(0, new Argument(targetFn.ref(), new ParameterAttribute[0]));
            if (targetFnType.getReturnType() instanceof StructureType) {
                tmp = fn.newVariable(new PointerType(targetFnType.getReturnType()));
                fn.add(new Alloca(tmp, targetFnType.getReturnType()));
                structResult = fn.newVariable(Type.I8_PTR);
                fn.add(new Bitcast(structResult, tmp.ref(), Type.I8_PTR));
                args.add(1, new Argument(structResult.ref(), new ParameterAttribute[0]));
            }
            String wrapperName = Symbols.bridgeCSymbol(method);
            FunctionType wrapperFnType = this.getBridgeFunctionType(method, dynamic, true);
            this.getCWrapperFunctions().add(BridgeMethodCompiler.createBridgeCWrapper(targetFnType.getReturnType(), targetFnType.getParameterTypes(), wrapperFnType.getParameterTypes(), wrapperName));
            FunctionRef wrapperFnRef = BridgeMethodCompiler.getBridgeCWrapperRef(targetFnType, wrapperName);
            moduleBuilder.addFunctionDeclaration(new FunctionDeclaration(wrapperFnRef));
            targetFnRef = wrapperFnRef;
        } else {
            tmp = fn.newVariable(targetFnType);
            fn.add(new Bitcast(tmp, targetFn.ref(), targetFnType));
            targetFnRef = tmp.ref();
        }
        BasicBlockRef bbSuccess = fn.newBasicBlockRef(new Label("success"));
        BasicBlockRef bbFailure = fn.newBasicBlockRef(new Label("failure"));
        Functions.pushNativeFrame(fn);
        Functions.trycatchAllEnter(fn, env, bbSuccess, bbFailure);
        fn.newBasicBlock(bbSuccess.getLabel());
        Value result = Functions.callWithArguments(fn, targetFnRef, args);
        Functions.trycatchLeave(fn, env);
        Functions.popNativeFrame(fn);
        this.updateObject(method, fn, env, 0L, marshaledArgs);
        if (Bro.needsMarshaler(method.getReturnType())) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method));
            String targetClassName = Types.getInternalName(method.getReturnType());
            if (structResult != null) {
                DataLayout dataLayout = this.config.getDataLayout();
                Value heapCopy = Functions.call(fn, (Value)Functions.BC_COPY_STRUCT, env, structResult.ref(), new IntegerConstant(dataLayout.getAllocSize(targetFnType.getReturnType())));
                result = this.marshalNativeToObject(fn, marshalerMethod, null, env, targetClassName, heapCopy, 0L);
            } else {
                result = targetFnType.getReturnType() instanceof PrimitiveType ? this.marshalNativeToValueObject(fn, marshalerMethod, env, targetClassName, result, 0L) : this.marshalNativeToObject(fn, marshalerMethod, null, env, targetClassName, result, 0L);
            }
        } else {
            result = this.marshalNativeToPrimitive(fn, method, result);
        }
        fn.add(new Ret(result));
        fn.newBasicBlock(bbFailure.getLabel());
        Functions.trycatchLeave(fn, env);
        Functions.popNativeFrame(fn);
        Value ex = Functions.call(fn, (Value)Functions.BC_EXCEPTION_CLEAR, env);
        this.updateObject(method, fn, env, 0L, marshaledArgs);
        Functions.call(fn, (Value)Functions.BC_THROW, env, ex);
        fn.add(new Unreachable());
        return fn;
    }

    private void updateObject(SootMethod method, Function fn, Value env, long flags, List<BroMethodCompiler.MarshaledArg> marshaledArgs) {
        for (BroMethodCompiler.MarshaledArg value : marshaledArgs) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, value.paramIndex));
            SootMethod afterMethod = ((MarshalerLookup.PointerMarshalerMethod)marshalerMethod).getAfterBridgeCallMethod();
            if (afterMethod == null) continue;
            Invokestatic invokestatic = new Invokestatic(Types.getInternalName(method.getDeclaringClass()), Types.getInternalName(afterMethod.getDeclaringClass()), afterMethod.getName(), Types.getDescriptor(afterMethod));
            this.trampolines.add(invokestatic);
            Functions.call(fn, (Value)invokestatic.getFunctionRef(), env, value.object, value.handle, new IntegerConstant(flags));
        }
    }
}

