/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.clazz;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.ClassDependency;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.Dependency;
import org.robovm.compiler.clazz.InvokeMethodDependency;
import org.robovm.compiler.clazz.MethodInfo;
import org.robovm.compiler.clazz.SuperMethodDependency;
import soot.SootClass;
import soot.SootMethod;
import soot.tagkit.Host;

public class ClazzInfo
implements Serializable {
    private static final long serialVersionUID = 99L;
    private int modifiers;
    private String name;
    private String internalName;
    private String superclassName;
    private final List<String> interfaceNames = new ArrayList<String>();
    private final List<MethodInfo> methods = new ArrayList<MethodInfo>();
    private final Set<String> catchNames = new HashSet<String>();
    private Map<String, Dependency> dependencies = new HashMap<String, Dependency>();
    private final Set<String> checkcasts = new HashSet<String>();
    private final Set<String> instanceofs = new HashSet<String>();
    private final Set<String> invokes = new HashSet<String>();
    private boolean isStruct;
    private boolean isEnum;
    private transient Clazz clazz;

    ClazzInfo() {
    }

    ClazzInfo(Clazz clazz, SootClass sootClass) {
        this.clazz = clazz;
        this.modifiers = sootClass.getModifiers();
        this.name = sootClass.getName();
        this.internalName = Types.getInternalName(sootClass);
    }

    private ClazzInfo(String internalName) {
        this.internalName = internalName;
        this.name = internalName.replace('/', '.');
    }

    public void initClassInfo() {
        if (this.isPhantom()) {
            return;
        }
        SootClass sootClass = this.clazz.getSootClass();
        this.isStruct = Types.isStruct(sootClass);
        this.isEnum = Types.isEnum(sootClass);
        if (sootClass.hasSuperclass()) {
            this.superclassName = Types.getInternalName(sootClass.getSuperclass());
        }
        this.interfaceNames.clear();
        for (SootClass ifs : sootClass.getInterfaces()) {
            this.interfaceNames.add(Types.getInternalName(ifs));
        }
        this.methods.clear();
        boolean classWeaklyLinked = Annotations.hasWeaklyLinkedAnnotation((Host)sootClass);
        boolean classStronglyLinked = Annotations.hasStronglyLinkedAnnotation((Host)sootClass);
        for (SootMethod method : sootClass.getMethods()) {
            boolean methodWeaklyLinked = Annotations.hasWeaklyLinkedAnnotation((Host)method);
            boolean methodStronglyLinked = Annotations.hasStronglyLinkedAnnotation((Host)method);
            this.methods.add(new MethodInfo(this, method.getModifiers(), method.getName(), Types.getDescriptor(method), Annotations.hasCallbackAnnotation(method), methodWeaklyLinked || classWeaklyLinked && !methodStronglyLinked, methodStronglyLinked || classStronglyLinked && !methodWeaklyLinked));
        }
    }

    public boolean isPhantom() {
        return this.clazz == null;
    }

    void setClazz(Clazz clazz) {
        this.clazz = clazz;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public boolean isStruct() {
        return this.isStruct;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public String getPackageName() {
        int idx = this.name.lastIndexOf(46);
        if (idx == -1) {
            return "";
        }
        return this.name.substring(0, idx);
    }

    public String getSuperclassName() {
        return this.superclassName;
    }

    public void setSuperclassName(String superclassName) {
        this.superclassName = superclassName;
    }

    public boolean hasSuperclass() {
        return this.superclassName != null;
    }

    private ClazzInfo loadClazzInfo(String n) {
        ClazzInfo ci;
        Clazz c;
        if (n != null && (c = this.clazz.clazzes.load(n)) != null && (ci = c.getClazzInfo()) != null) {
            return ci;
        }
        return new ClazzInfo(n);
    }

    public ClazzInfo getSuperclass() {
        return this.loadClazzInfo(this.superclassName);
    }

    public List<String> getInterfaceNames() {
        return Collections.unmodifiableList(this.interfaceNames);
    }

    public void setInterfaceNames(List<String> interfaceNames) {
        this.interfaceNames.clear();
        this.interfaceNames.addAll(interfaceNames);
    }

    public List<ClazzInfo> getInterfaces() {
        ArrayList<ClazzInfo> result = new ArrayList<ClazzInfo>();
        for (String ifname : this.interfaceNames) {
            result.add(this.loadClazzInfo(ifname));
        }
        return result;
    }

    public Set<String> getCatchNames() {
        return this.catchNames;
    }

    public void setCatchNames(Set<String> catchNames) {
        this.catchNames.clear();
        this.catchNames.addAll(catchNames);
    }

    public List<ClazzInfo> getCatches() {
        ArrayList<ClazzInfo> result = new ArrayList<ClazzInfo>();
        for (String n : this.catchNames) {
            result.add(this.loadClazzInfo(n));
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    public MethodInfo getMethod(String name, String desc) {
        for (MethodInfo m : this.methods) {
            if (!m.getName().equals(name) || !m.getDesc().equals(desc)) continue;
            return m;
        }
        return null;
    }

    public List<MethodInfo> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public void addClassDependency(String className, boolean weak) {
        if (!this.dependencies.containsKey(className)) {
            Clazz clazz = this.clazz.clazzes.load(className);
            String path = clazz != null ? clazz.getPath().getFile().getAbsolutePath() : null;
            boolean inBootClasspath = clazz != null ? clazz.isInBootClasspath() : false;
            this.dependencies.put(className, new ClassDependency(className, path, inBootClasspath, weak));
        }
    }

    public void addClassDependencies(Collection<String> classNames, boolean weak) {
        for (String className : classNames) {
            this.addClassDependency(className, weak);
        }
    }

    public void addInvokeMethodDependency(String owner, String name, String desc, boolean weak) {
        String key = "Invoke." + owner + "." + name + desc;
        if (!this.dependencies.containsKey(key)) {
            Clazz clazz = this.clazz.clazzes.load(owner);
            String path = clazz != null ? clazz.getPath().getFile().getAbsolutePath() : null;
            boolean inBootClasspath = clazz != null ? clazz.isInBootClasspath() : false;
            this.dependencies.put(key, new InvokeMethodDependency(owner, name, desc, path, inBootClasspath, weak));
        }
    }

    public void addSuperMethodDependency(String owner, String name, String desc, boolean weak) {
        String key = "Super." + owner + "." + name + desc;
        if (!this.dependencies.containsKey(key)) {
            Clazz clazz = this.clazz.clazzes.load(owner);
            String path = clazz != null ? clazz.getPath().getFile().getAbsolutePath() : null;
            boolean inBootClasspath = clazz != null ? clazz.isInBootClasspath() : false;
            this.dependencies.put(key, new SuperMethodDependency(owner, name, desc, path, inBootClasspath, weak));
        }
    }

    public void clearDependencies() {
        this.dependencies = new HashMap<String, Dependency>();
    }

    public Set<Dependency> getDependencies() {
        return new HashSet<Dependency>(this.dependencies.values());
    }

    public Set<Dependency> getAllDependencies() {
        HashSet<Dependency> result = new HashSet<Dependency>(this.dependencies.values());
        for (MethodInfo mi : this.methods) {
            result.addAll(mi.getDependencies());
        }
        return result;
    }

    public Set<String> getCheckcasts() {
        return this.checkcasts;
    }

    public void addCheckcast(String className) {
        this.checkcasts.add(className);
    }

    public Set<String> getInstanceofs() {
        return this.instanceofs;
    }

    public void addInstanceof(String className) {
        this.instanceofs.add(className);
    }

    public Set<String> getInvokes() {
        return this.invokes;
    }

    public void addInvoke(String className) {
        this.invokes.add(className);
    }

    public boolean isPublic() {
        return (this.modifiers & 1) > 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x10) > 0;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) > 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        result = 31 * result + (this.internalName == null ? 0 : this.internalName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClazzInfo other = (ClazzInfo)obj;
        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
            return false;
        }
        return !(this.internalName == null ? other.internalName != null : !this.internalName.equals(other.internalName));
    }

    public void dropDependencyData() {
        for (MethodInfo mi : this.getMethods()) {
            mi.dropDependencyData();
        }
        this.dependencies = null;
    }
}

