/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.config;

import java.util.List;
import org.robovm.compiler.clazz.ClazzInfo;
import org.robovm.compiler.util.AntPathMatcher;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Text;

public class ForceLinkMethodsConfig {
    @ElementList(entry="method")
    private List<String> methods;
    @ElementList(entry="pattern")
    private List<MethodOwner> owners;

    public List<String> getMethods() {
        return this.methods;
    }

    public List<MethodOwner> getOwners() {
        return this.owners;
    }

    public boolean matchesClass(ClazzInfo ci) {
        for (MethodOwner owner : this.owners) {
            AntPathMatcher matcher = new AntPathMatcher(owner.getPattern(), ".");
            if (!owner.isExtendable()) {
                if (!matcher.matches(ci.getName())) continue;
                return true;
            }
            ClazzInfo dci = ci;
            while (dci != null) {
                if (matcher.matches(dci.getName())) {
                    return true;
                }
                for (ClazzInfo ici : dci.getInterfaces()) {
                    if (!matcher.matches(ici.getName())) continue;
                    return true;
                }
                dci = dci.getSuperclassName() != null ? dci.getSuperclass() : null;
            }
        }
        return false;
    }

    public static class MethodOwner {
        @Attribute(name="extendable", required=false)
        boolean extendable;
        @Text
        String pattern;

        public boolean isExtendable() {
            return this.extendable;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

