/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.config;

import java.util.ArrayList;
import org.robovm.compiler.util.AntPathMatcher;

public class StripArchivesConfig {
    private final ArrayList<Pattern> patterns;
    private static final Pattern EXCLUDE_CLASS_FILES = new Pattern("**/*.class", false);
    private static final Pattern INCLUDE_ALL = new Pattern("**/*", true);
    public static final StripArchivesConfig DEFAULT = new StripArchivesBuilder().build();

    public StripArchivesConfig(ArrayList<Pattern> patterns) {
        this.patterns = patterns;
    }

    public ArrayList<Pattern> getPatterns() {
        return this.patterns;
    }

    public static class Pattern {
        private AntPathMatcher matcher;
        private final boolean isInclude;
        private final String pattern;

        public Pattern(String pattern, boolean isInclude) {
            this.matcher = new AntPathMatcher(pattern);
            this.isInclude = isInclude;
            this.pattern = pattern;
        }

        public boolean matches(String path) {
            return this.matcher.matches(path);
        }

        public boolean isInclude() {
            return this.isInclude;
        }

        public String getPatternAsString() {
            return this.pattern;
        }
    }

    public static class StripArchivesBuilder {
        private ArrayList<Pattern> patterns = new ArrayList();
        private boolean hasBeenUsed;

        public void add(boolean include, String ... patterns) {
            if (this.hasBeenUsed) {
                throw new IllegalStateException("This builder has already been used and can't be reused.");
            }
            for (String pattern : patterns) {
                this.patterns.add(new Pattern(pattern, include));
            }
        }

        public void addInclude(String ... patterns) {
            this.add(true, patterns);
        }

        public void addExclude(String ... patterns) {
            this.add(false, patterns);
        }

        public StripArchivesConfig build() {
            this.patterns.add(EXCLUDE_CLASS_FILES);
            this.patterns.add(INCLUDE_ALL);
            this.hasBeenUsed = true;
            return new StripArchivesConfig(this.patterns);
        }
    }
}

