/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;

public abstract class BinaryOpInstruction
extends Instruction {
    protected final Variable result;
    protected final Value op1;
    protected final Value op2;

    protected BinaryOpInstruction(Variable result, Value op1, Value op2) {
        this.result = result;
        this.op1 = op1;
        this.op2 = op2;
    }

    @Override
    public Set<Variable> getWritesTo() {
        return Collections.singleton(this.result);
    }

    @Override
    public Set<VariableRef> getReadsFrom() {
        HashSet<VariableRef> refs = new HashSet<VariableRef>();
        if (this.op1 instanceof VariableRef) {
            refs.add((VariableRef)this.op1);
        }
        if (this.op2 instanceof VariableRef) {
            refs.add((VariableRef)this.op2);
        }
        return refs;
    }
}

