/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.ArrayConstant;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.Writable;

public class Landingpad
extends Instruction {
    private final Variable result;
    private final Constant personalityFn;
    private final boolean cleanup;
    private final Clause[] clauses;

    public Landingpad(Variable result, Constant personalityFn, Clause ... clauses) {
        this(result, personalityFn, false, clauses);
    }

    public Landingpad(Variable result, Constant personalityFn, boolean cleanup, Clause ... clauses) {
        this.result = result;
        this.personalityFn = personalityFn;
        this.cleanup = cleanup;
        this.clauses = new Clause[clauses.length];
        System.arraycopy(clauses, 0, this.clauses, 0, clauses.length);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.result.toString());
        writer.write(" = landingpad ");
        this.result.getType().write(writer);
        writer.write(" personality ");
        this.personalityFn.getType().write(writer);
        writer.write(32);
        this.personalityFn.write(writer);
        if (this.cleanup) {
            writer.write(" cleanup");
        }
        for (Clause clause : this.clauses) {
            writer.write(32);
            clause.write(writer);
        }
    }

    public String toString() {
        return this.toString(this::write);
    }

    public static interface Clause
    extends Writable {
    }

    public static class Filter
    implements Clause {
        private final ArrayConstant value;

        public Filter(ArrayConstant value) {
            this.value = value;
        }

        @Override
        public void write(Writer writer) throws IOException {
            writer.write("filter ");
            this.value.getType().write(writer);
            writer.write(32);
            this.value.write(writer);
        }

        public String toString() {
            return this.toString(this::write);
        }
    }

    public static class Catch
    implements Clause {
        private final Value value;

        public Catch(Value value) {
            this.value = value;
        }

        @Override
        public void write(Writer writer) throws IOException {
            writer.write("catch ");
            this.value.getType().write(writer);
            writer.write(32);
            this.value.write(writer);
        }

        public String toString() {
            return this.toString(this::write);
        }
    }
}

