/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.Ordering;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.VariableRef;

public class Store
extends Instruction {
    private final Value value;
    private final Value pointer;
    private final boolean _volatile;
    private final Ordering ordering;
    private final int alignment;

    public Store(Value value, Value pointer) {
        this(value, pointer, false, null, -1);
    }

    public Store(Value value, Value pointer, boolean _volatile) {
        this(value, pointer, _volatile, null, -1);
    }

    public Store(Value value, Value pointer, boolean _volatile, Ordering ordering, int alignment) {
        this.value = value;
        this.pointer = pointer;
        this._volatile = _volatile;
        this.ordering = ordering;
        this.alignment = alignment;
    }

    public Value getValue() {
        return this.value;
    }

    public Value getPointer() {
        return this.pointer;
    }

    @Override
    public Set<VariableRef> getReadsFrom() {
        HashSet<VariableRef> result = new HashSet<VariableRef>();
        if (this.value instanceof VariableRef) {
            result.add((VariableRef)this.value);
        }
        if (this.pointer instanceof VariableRef) {
            result.add((VariableRef)this.pointer);
        }
        return result;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write("store ");
        if (this._volatile) {
            writer.write("volatile ");
        }
        if (this.ordering != null) {
            writer.write("atomic ");
        }
        this.value.getType().write(writer);
        writer.write(" ");
        this.value.write(writer);
        writer.write(", ");
        this.pointer.getType().write(writer);
        writer.write(" ");
        this.pointer.write(writer);
        if (this.ordering != null) {
            writer.write(" ");
            writer.write(this.ordering.toString());
        }
        if (this.alignment > 0) {
            writer.write(", align ");
            writer.write(Integer.toString(this.alignment));
        }
    }

    public String toString() {
        return this.toString(this::write);
    }
}

