/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.framework;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.robovm.compiler.clazz.Path;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.CpuArch;
import org.robovm.compiler.config.Environment;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.target.AbstractTarget;
import org.robovm.compiler.target.ios.IOSTarget;
import org.robovm.compiler.target.ios.SDK;
import org.robovm.compiler.util.Executor;
import org.robovm.compiler.util.ToolchainUtil;
import org.robovm.compiler.util.XCFrameworkPlist;

public class FrameworkTarget
extends AbstractTarget {
    private static final String TYPE = "framework";
    private static final String XC_TYPE = "xcframework";
    private OS os;
    private Arch arch;
    private SDK sdk;
    private boolean xcframework;
    private Arch[][] xcFrameworkArches;

    public static boolean matches(String candidate) {
        return candidate.matches(TYPE) || candidate.matches(XC_TYPE);
    }

    public FrameworkTarget(String targetType) {
        this.xcframework = targetType.equals(XC_TYPE);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public OS getOs() {
        return this.os;
    }

    @Override
    public Arch getArch() {
        return this.arch;
    }

    @Override
    public boolean canLaunch() {
        return false;
    }

    public List<SDK> getSDKs() {
        if (IOSTarget.isSimulatorArch(this.arch)) {
            return SDK.listSimulatorSDKs();
        }
        return SDK.listDeviceSDKs();
    }

    @Override
    public void init(Config paramConfig) {
        Set duplicateCpuArches;
        super.init(paramConfig);
        this.os = this.config.getOs();
        if (this.os == null) {
            this.os = OS.getDefaultOS();
        }
        this.arch = this.config.getArch();
        if (this.arch == null) {
            this.arch = new Arch(CpuArch.getDefaultArch(), Environment.Native);
        }
        if (this.os.getFamily() != OS.Family.darwin) {
            throw new IllegalArgumentException("Frameworks can only be built for Darwin platforms");
        }
        if (paramConfig.getInfoPList() == null) {
            throw new IllegalArgumentException("Frameworks must have a Info.plist file");
        }
        paramConfig.getIosInfoPList().parse(paramConfig.getProperties());
        String sdkVersion = this.config.getIosSdkVersion();
        List<SDK> sdks = this.getSDKs();
        if (sdkVersion == null) {
            if (sdks.isEmpty()) {
                throw new IllegalArgumentException("No " + (IOSTarget.isDeviceArch(this.arch) ? "device" : "simulator") + " SDKs installed");
            }
            Collections.sort(sdks);
            this.sdk = sdks.get(sdks.size() - 1);
        } else {
            for (SDK sdk : sdks) {
                if (!sdk.getVersion().equals(sdkVersion)) continue;
                this.sdk = sdk;
                break;
            }
            if (this.sdk == null) {
                throw new IllegalArgumentException("No SDK found matching version string " + sdkVersion);
            }
        }
        if (!this.xcframework && !(duplicateCpuArches = this.config.getArchs().stream().collect(Collectors.groupingBy(Arch::getCpuArch, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet())).isEmpty()) {
            List duplicateArches = this.config.getArchs().stream().filter(a -> duplicateCpuArches.contains((Object)a.getCpuArch())).sorted().collect(Collectors.toList());
            throw new IllegalArgumentException("Wrong configuration: unable to create fat framework due duplicate CPU architectures: " + duplicateArches.stream().map(Arch::toString).collect(Collectors.joining(", ")) + ". Use xcframework instead.");
        }
    }

    @Override
    public String getInstallRelativeArchivePath(Path path) {
        return this.config.getImageName() + ".bundle/Resources/" + super.getInstallRelativeArchivePath(path);
    }

    @Override
    protected List<String> getTargetExportedSymbols() {
        return Arrays.asList("JNI_*", "rvmInstantiateFramework", "rvmInitializeFrameworkWithJVM", "OBJC_CLASS_$_*");
    }

    private String getMinimumOSVersion() {
        String minimumOSVersion = this.config.getInfoPList().getMinimumOSVersion();
        if (minimumOSVersion != null) {
            return minimumOSVersion;
        }
        return this.config.getOs().getMinVersion();
    }

    @Override
    protected List<String> getTargetCcArgs() {
        ArrayList<String> ccArgs = new ArrayList<String>();
        ccArgs.add("-stdlib=libc++");
        ccArgs.add("--target=" + this.config.getClangTriple(this.getMinimumOSVersion()));
        if (IOSTarget.isDeviceArch(this.arch) && this.config.isEnableBitcode()) {
            ccArgs.add("-fembed-bitcode");
        }
        ccArgs.add("-isysroot");
        ccArgs.add(this.sdk.getRoot().getAbsolutePath());
        ccArgs.add("-dynamiclib");
        ccArgs.add("-single_module");
        ccArgs.add("-compatibility_version");
        ccArgs.add("1");
        ccArgs.add("-current_version");
        ccArgs.add("1");
        ccArgs.add("-install_name");
        ccArgs.add(String.format("@rpath/%s.framework/%s", this.config.getImageName(), this.config.getImageName()));
        return ccArgs;
    }

    @Override
    protected List<String> getTargetLibs() {
        String libSuffix = this.config.isUseDebugLibs() ? "-dbg" : "";
        return Collections.singletonList("-lrobovm-frameworksupport" + libSuffix);
    }

    private Arch[][] getXCFrameworkArches() {
        if (this.xcFrameworkArches == null) {
            List<Arch> configArches = this.config.getArchs();
            this.xcFrameworkArches = configArches.size() == 1 ? new Arch[][]{{configArches.get(0)}} : (Arch[][])configArches.stream().collect(Collectors.groupingBy(Arch::getEnv, Collectors.toList())).values().stream().map(arches -> (Arch[])arches.stream().sorted().toArray(Arch[]::new)).toArray(x$0 -> new Arch[x$0][]);
        }
        return this.xcFrameworkArches;
    }

    @Override
    public void buildFat(Map<Arch, File> slices) throws IOException {
        if (this.xcframework) {
            Arch[][] archesInBinaries = this.getXCFrameworkArches();
            HashMap<Arch, File> slicesToConsume = new HashMap<Arch, File>(slices);
            for (Arch[] archesInBinary : archesInBinaries) {
                ArrayList<File> filesForLipo = new ArrayList<File>(archesInBinary.length);
                for (Arch arch : archesInBinary) {
                    File f = (File)slicesToConsume.remove(arch);
                    if (f == null) {
                        throw new IllegalStateException("Required arch " + arch + " is missing in slices!");
                    }
                    filesForLipo.add(f);
                }
                if (archesInBinary.length == 1) {
                    File f = (File)filesForLipo.get(0);
                    String archDir = archesInBinary[0].toString();
                    File destDir = new File(this.config.getTmpDir(), archDir);
                    destDir.mkdirs();
                    File destFile = new File(destDir, this.getExecutable());
                    if (f.equals(destFile)) continue;
                    FileUtils.copyFile((File)f, (File)destFile);
                    destFile.setExecutable(true, false);
                    continue;
                }
                Object archDir = Arrays.stream(archesInBinary).map(Arch::getCpuArch).map(CpuArch::getClangName).collect(Collectors.joining("_"));
                archDir = (String)archDir + archesInBinary[0].getEnv().asLlvmSuffix("-");
                this.config.getLogger().info("Building fat binary for archs " + (String)archDir, new Object[0]);
                File destDir = new File(this.config.getTmpDir(), (String)archDir);
                destDir.mkdirs();
                File destFile = new File(destDir, this.getExecutable());
                ToolchainUtil.lipo(this.config, destFile, filesForLipo);
            }
        } else {
            super.buildFat(slices);
        }
    }

    @Override
    protected void doInstall(File installDir, String image, File resourcesDir) throws IOException {
        if (this.xcframework) {
            Arch[][] archesInBinaries;
            File xcFrameworkDir = new File(installDir, image + ".xcframework");
            if (xcFrameworkDir.exists()) {
                FileUtils.deleteDirectory((File)xcFrameworkDir);
            }
            xcFrameworkDir.mkdirs();
            XCFrameworkPlist.Builder builder = new XCFrameworkPlist.Builder();
            this.config.getLogger().info("Creating framework: %s", xcFrameworkDir);
            for (Arch[] archesInBinary : archesInBinaries = this.getXCFrameworkArches()) {
                Object identifier;
                if (archesInBinary.length == 1) {
                    identifier = archesInBinary[0].toString();
                } else {
                    identifier = Arrays.stream(archesInBinary).map(Arch::getCpuArch).map(CpuArch::getClangName).collect(Collectors.joining("_"));
                    identifier = (String)identifier + archesInBinary[0].getEnv().asLlvmSuffix("-");
                }
                File frameworkArchDir = new File(xcFrameworkDir, (String)identifier);
                File frameworkDir = new File(frameworkArchDir, image + ".framework");
                File dsymDir = new File(frameworkArchDir, "dSYMs/" + image + ".dSYM");
                File executable = this.config.getArchs().size() == 1 ? new File(this.config.getTmpDir(), this.getExecutable()) : new File(new File(this.config.getTmpDir(), (String)identifier), this.getExecutable());
                this.config.getLogger().info("Installing " + (String)identifier + "framework slice: %s", frameworkDir);
                this.installFramework(frameworkDir, dsymDir, executable, image);
                XCFrameworkPlist.Library library = new XCFrameworkPlist.Library((String)identifier, image + ".framework", this.config.getOs(), (CpuArch[])Arrays.stream(archesInBinary).map(Arch::getCpuArch).toArray(CpuArch[]::new), archesInBinary[0].getEnv(), "dSYMs");
                builder.addLibrary(library);
            }
            XCFrameworkPlist plist = builder.build();
            File infoPlist = new File(xcFrameworkDir, "Info.plist");
            this.config.getLogger().info("Installing XCFramework/Info.plist to: %s", infoPlist);
            plist.writeTo(infoPlist);
        } else {
            File executable = new File(this.config.getTmpDir(), this.getExecutable());
            File frameworkDir = new File(installDir, image + ".framework");
            File dsymDir = new File(installDir, image + ".dSYM");
            this.config.getLogger().info("Creating framework: %s", frameworkDir);
            this.installFramework(frameworkDir, dsymDir, executable, image);
        }
    }

    private void installFramework(File frameworkDir, File dsymDir, File binary, String image) throws IOException {
        NSDictionary infoPlist;
        if (frameworkDir.exists()) {
            FileUtils.deleteDirectory((File)frameworkDir);
        }
        frameworkDir.mkdirs();
        File executable = new File(frameworkDir, image);
        if (!binary.equals(executable)) {
            FileUtils.copyFile((File)binary, (File)executable);
            executable.setExecutable(true, false);
        }
        File bundleDir = new File(frameworkDir, image + ".bundle");
        bundleDir.mkdirs();
        File bundleResourcesDir = new File(bundleDir, "Resources");
        bundleResourcesDir.mkdirs();
        super.doInstall(frameworkDir, executable, bundleResourcesDir);
        this.config.getLogger().info("Creating framework symbol directory: %s", dsymDir);
        if (dsymDir.exists()) {
            FileUtils.deleteDirectory((File)dsymDir);
        }
        dsymDir.mkdirs();
        ToolchainUtil.generateDsym(this.config, dsymDir, executable);
        if (!this.config.isDebug()) {
            this.config.getLogger().info("Striping framework binary: %s", executable);
            new Executor(this.config.getLogger(), "xcrun").args("strip", "-x", executable).exec();
        }
        if (!this.config.isEnableBitcode()) {
            this.config.getLogger().info("Striping bitcode from binary: %s", executable);
            this.stripBitcode(executable);
        }
        if ((infoPlist = this.config.getInfoPList().getDictionary()).objectForKey("MinimumOSVersion") == null) {
            infoPlist.put("MinimumOSVersion", (Object)this.config.getOs().getMinVersion());
        }
        File infoPlistBin = new File(frameworkDir, "Info.plist");
        this.config.getLogger().info("Installing Info.plist to: %s", infoPlistBin);
        PropertyListParser.saveAsBinary((NSObject)infoPlist, (File)infoPlistBin);
    }
}

