/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.trampoline;

import org.robovm.compiler.Symbols;
import org.robovm.compiler.trampoline.Invoke;
import org.robovm.compiler.trampoline.Trampoline;

public class Invokevirtual
extends Invoke {
    private static final long serialVersionUID = 1L;
    private final String runtimeClass;

    public Invokevirtual(String callingClass, String targetClass, String methodName, String methodDesc, String runtimeClass) {
        super(callingClass, targetClass, methodName, methodDesc);
        this.runtimeClass = runtimeClass;
    }

    public String getRuntimeClass() {
        return this.runtimeClass;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.runtimeClass == null ? 0 : this.runtimeClass.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Invokevirtual other = (Invokevirtual)obj;
        return !(this.runtimeClass == null ? other.runtimeClass != null : !this.runtimeClass.equals(other.runtimeClass));
    }

    @Override
    public int compareTo(Trampoline o) {
        int c = super.compareTo(o);
        if (c == 0) {
            c = this.runtimeClass.compareTo(((Invokevirtual)o).runtimeClass);
        }
        return c;
    }

    @Override
    public String toString() {
        return Symbols.trampolineMethodSymbol(this, this.getCallingClass(), this.getTarget(), this.getMethodName(), this.getMethodDesc(), this.runtimeClass);
    }
}

