/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.robovm.compiler.config.CpuArch;
import org.robovm.compiler.config.Environment;
import org.robovm.compiler.config.OS;

public class XCFrameworkPlist {
    private static final String KEY_AVAILABLE_LIBRARIES = "AvailableLibraries";
    private static final String KEY_LIBRARY_IDENTIFIER = "LibraryIdentifier";
    private static final String KEY_LIBRARY_PATH = "LibraryPath";
    private static final String KEY_SUPPORTED_ARCHITECTURES = "SupportedArchitectures";
    private static final String KEY_SUPPORTED_PLATFORM = "SupportedPlatform";
    private static final String KEY_SUPPORTED_PLATFORM_VARIANT = "SupportedPlatformVariant";
    private static final String KEY_DEBUG_SYMBOLS_PATH = "DebugSymbolsPath";
    private static final String KEY_CFBUNDLE_PACKAGE_TYPE = "CFBundlePackageType";
    private static final String KEY_XCFRAMEWORK_FORMAT_VERSION = "XCFrameworkFormatVersion";
    private final Library[] availableLibraries;

    public XCFrameworkPlist(Library[] availableLibraries) {
        this.availableLibraries = availableLibraries;
    }

    public Library[] getAvailableLibraries() {
        return this.availableLibraries;
    }

    public void writeTo(File infoPlistFile) throws IOException {
        NSDictionary plist = new NSDictionary();
        if (this.availableLibraries.length > 0) {
            NSArray arrayLibs = new NSArray(this.availableLibraries.length);
            for (int libIdx = 0; libIdx < this.availableLibraries.length; ++libIdx) {
                Library lib = this.availableLibraries[libIdx];
                NSDictionary dictLib = new NSDictionary();
                dictLib.put(KEY_LIBRARY_IDENTIFIER, (Object)lib.identifier);
                dictLib.put(KEY_LIBRARY_PATH, (Object)lib.path);
                dictLib.put(KEY_SUPPORTED_PLATFORM, (Object)lib.platform.toString());
                if (lib.variant != Environment.Native) {
                    dictLib.put(KEY_SUPPORTED_PLATFORM_VARIANT, (Object)lib.variant.getLlvmName());
                }
                if (lib.debugSymbolPath != null) {
                    dictLib.put(KEY_DEBUG_SYMBOLS_PATH, (Object)lib.debugSymbolPath);
                }
                NSArray arrayArches = new NSArray(lib.supportedArchitectures.length);
                for (int archIdx = 0; archIdx < lib.supportedArchitectures.length; ++archIdx) {
                    arrayArches.setValue(archIdx, (Object)lib.supportedArchitectures[archIdx].getClangName());
                }
                dictLib.put(KEY_SUPPORTED_ARCHITECTURES, (NSObject)arrayArches);
                arrayLibs.setValue(libIdx, (Object)dictLib);
            }
            plist.put(KEY_AVAILABLE_LIBRARIES, (NSObject)arrayLibs);
            plist.put(KEY_CFBUNDLE_PACKAGE_TYPE, (Object)"XFWK");
            plist.put(KEY_XCFRAMEWORK_FORMAT_VERSION, (Object)"1.0");
        }
        PropertyListParser.saveAsXML((NSObject)plist, (File)infoPlistFile);
    }

    public static XCFrameworkPlist loadPlist(File f) throws IOException {
        try {
            ArrayList<Library> libraries = new ArrayList<Library>();
            NSDictionary plist = (NSDictionary)PropertyListParser.parse((File)f);
            NSArray arrayLibs = (NSArray)plist.get((Object)KEY_AVAILABLE_LIBRARIES);
            for (NSObject o : arrayLibs.getArray()) {
                try {
                    NSDictionary dictLib = (NSDictionary)o;
                    String identifier = dictLib.get((Object)KEY_LIBRARY_IDENTIFIER).toString();
                    String libraryPath = dictLib.get((Object)KEY_LIBRARY_PATH).toString();
                    String supportedPlatform = dictLib.get((Object)KEY_SUPPORTED_PLATFORM).toString();
                    String supportedPlatformVariant = XCFrameworkPlist.toStringOrNull(dictLib.get((Object)KEY_SUPPORTED_PLATFORM_VARIANT));
                    String debugSymbolsPath = XCFrameworkPlist.toStringOrNull(dictLib.get((Object)KEY_DEBUG_SYMBOLS_PATH));
                    NSArray arrayArches = (NSArray)dictLib.get((Object)KEY_SUPPORTED_ARCHITECTURES);
                    OS os = OS.valueOf(supportedPlatform);
                    Environment env = supportedPlatformVariant != null ? Environment.parse(supportedPlatformVariant) : Environment.Native;
                    LinkedHashSet<CpuArch> arches = new LinkedHashSet<CpuArch>();
                    for (NSObject archO : arrayArches.getArray()) {
                        CpuArch arch = XCFrameworkPlist.parse(archO.toString());
                        if (arch == null) continue;
                        arches.add(arch);
                    }
                    if (arches.isEmpty()) continue;
                    libraries.add(new Library(identifier, libraryPath, os, arches.toArray(new CpuArch[0]), env, debugSymbolsPath));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return new XCFrameworkPlist(libraries.toArray(new Library[0]));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    public static XCFrameworkPlist load(File xcFramework) throws IOException {
        return XCFrameworkPlist.loadPlist(new File(xcFramework, "Info.plist"));
    }

    private static CpuArch parse(String s) {
        for (CpuArch v : CpuArch.values()) {
            if (!s.equals(v.getClangName())) continue;
            return v;
        }
        return null;
    }

    private static String toStringOrNull(Object o) {
        return o != null ? o.toString() : null;
    }

    public static class Library {
        private final String identifier;
        private final String path;
        private final OS platform;
        private final CpuArch[] supportedArchitectures;
        private final Environment variant;
        private final String debugSymbolPath;

        public Library(String identifier, String path, OS platform, CpuArch[] supportedArchitectures, Environment variant, String debugSymbolPath) {
            this.identifier = identifier;
            this.path = path;
            this.platform = platform;
            this.supportedArchitectures = supportedArchitectures;
            this.variant = variant;
            this.debugSymbolPath = debugSymbolPath;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getPath() {
            return this.path;
        }

        public OS getPlatform() {
            return this.platform;
        }

        public CpuArch[] getSupportedArchitectures() {
            return this.supportedArchitectures;
        }

        public Environment getVariant() {
            return this.variant;
        }

        public boolean supportCpuArch(CpuArch cpuArch) {
            for (CpuArch c : this.supportedArchitectures) {
                if (c != cpuArch) continue;
                return true;
            }
            return false;
        }
    }

    public static class Builder {
        private final List<Library> libraries = new ArrayList<Library>();

        public Builder addLibrary(Library lib) {
            this.libraries.add(lib);
            return this;
        }

        public XCFrameworkPlist build() {
            return new XCFrameworkPlist(this.libraries.toArray(new Library[0]));
        }
    }
}

