/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.generic;

import soot.SootClass;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.InnerClassTag;
import soot.tagkit.Tag;

public final class SootClassUtils {
    private SootClassUtils() {
    }

    public static String getDeclaringClassName(SootClass sootClass) {
        for (Tag tag : sootClass.getTags()) {
            InnerClassTag icTag;
            if (!(tag instanceof InnerClassTag) || (icTag = (InnerClassTag)tag).getInnerClass() == null || icTag.getOuterClass() == null) continue;
            String innerName = icTag.getInnerClass().replace('/', '.');
            if (!sootClass.getName().equals(innerName)) continue;
            return icTag.getOuterClass().replace('/', '.');
        }
        return null;
    }

    public static String getEnclosingClassName(SootClass sootClass) {
        EnclosingMethodTag emTag = (EnclosingMethodTag)sootClass.getTag("EnclosingMethodTag");
        if (emTag != null) {
            return emTag.getEnclosingClass();
        }
        return null;
    }

    public static boolean isAssignableFrom(SootClass subSootClass, SootClass sootClass) {
        if (sootClass.equals(subSootClass)) {
            return true;
        }
        if (subSootClass.hasSuperclass()) {
            return SootClassUtils.isAssignableFrom(subSootClass.getSuperclass(), sootClass);
        }
        return false;
    }
}

