/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.clazz;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.tuple.Triple;
import org.robovm.compiler.clazz.ClassDependency;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.ClazzInfo;
import org.robovm.compiler.clazz.Dependency;
import org.robovm.compiler.clazz.InvokeMethodDependency;
import org.robovm.compiler.clazz.SuperMethodDependency;

public class MethodInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ClazzInfo ci;
    private int modifiers;
    private String name;
    private String desc;
    private boolean callback;
    private boolean weaklyLinked;
    private boolean stronglyLinked;
    private Map<String, Dependency> dependencies = new HashMap<String, Dependency>();

    MethodInfo(ClazzInfo ci, int modifiers, String name, String desc, boolean callback, boolean weaklyLinked, boolean strongyLinked) {
        this.ci = ci;
        this.modifiers = modifiers;
        this.name = name;
        this.desc = desc;
        this.callback = callback;
        this.weaklyLinked = weaklyLinked;
        this.stronglyLinked = strongyLinked;
    }

    public void addClassDependency(String className, boolean weak) {
        if (!this.dependencies.containsKey(className)) {
            Clazz clazz = this.ci.getClazz().clazzes.load(className);
            String path = clazz != null ? clazz.getPath().getFile().getAbsolutePath() : null;
            boolean inBootClasspath = clazz != null ? clazz.isInBootClasspath() : false;
            this.dependencies.put(className, new ClassDependency(className, path, inBootClasspath, weak));
        }
    }

    public void addClassDependencies(Collection<String> classNames, boolean weak) {
        for (String className : classNames) {
            this.addClassDependency(className, weak);
        }
    }

    public void addInvokeMethodDependency(String owner, String name, String desc, boolean weak) {
        String key = "Invoke." + owner + "." + name + desc;
        if (!this.dependencies.containsKey(key)) {
            Clazz clazz = this.ci.getClazz().clazzes.load(owner);
            String path = clazz != null ? clazz.getPath().getFile().getAbsolutePath() : null;
            boolean inBootClasspath = clazz != null ? clazz.isInBootClasspath() : false;
            this.dependencies.put(key, new InvokeMethodDependency(owner, name, desc, path, inBootClasspath, weak));
        }
    }

    public void addInvokeMethodDependencies(Collection<Triple<String, String, String>> deps, boolean weak) {
        for (Triple<String, String, String> d : deps) {
            this.addInvokeMethodDependency((String)d.getLeft(), (String)d.getMiddle(), (String)d.getRight(), weak);
        }
    }

    public void addSuperMethodDependency(String owner, String name, String desc, boolean weak) {
        String key = "Super." + owner + "." + name + desc;
        if (!this.dependencies.containsKey(key)) {
            Clazz clazz = this.ci.getClazz().clazzes.load(owner);
            String path = clazz != null ? clazz.getPath().getFile().getAbsolutePath() : null;
            boolean inBootClasspath = clazz != null ? clazz.isInBootClasspath() : false;
            this.dependencies.put(key, new SuperMethodDependency(owner, name, desc, path, inBootClasspath, weak));
        }
    }

    public void addSuperMethodDependencies(Collection<Triple<String, String, String>> deps, boolean weak) {
        for (Triple<String, String, String> d : deps) {
            this.addSuperMethodDependency((String)d.getLeft(), (String)d.getMiddle(), (String)d.getRight(), weak);
        }
    }

    public Set<Dependency> getDependencies() {
        return new HashSet<Dependency>(this.dependencies.values());
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) > 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & 2) > 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 4) > 0;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) > 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x10) > 0;
    }

    public boolean isSynchronized() {
        return (this.modifiers & 0x20) > 0;
    }

    public boolean isNative() {
        return (this.modifiers & 0x100) > 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) > 0;
    }

    public boolean isCallback() {
        return this.callback;
    }

    public boolean isWeaklyLinked() {
        return this.weaklyLinked;
    }

    public boolean isStronglyLinked() {
        return this.stronglyLinked;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ci == null ? 0 : this.ci.hashCode());
        result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
        result = 31 * result + this.modifiers;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        if (this.ci == null ? other.ci != null : !this.ci.equals(other.ci)) {
            return false;
        }
        if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
            return false;
        }
        if (this.modifiers != other.modifiers) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

