/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.robovm.compiler.config.Config;
import soot.ArrayType;
import soot.Body;
import soot.Local;
import soot.LocalVariable;
import soot.NullType;
import soot.PatchingChain;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.coffi.Util;
import soot.jimple.IdentityStmt;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.RoboVmLiveSlotLocals;

public class DebuggerDebugVariableSlicer {
    final Map<Unit, Integer> unitToSlice = new HashMap<Unit, Integer>();
    final List<UnitVariableSlice> slices = new ArrayList<UnitVariableSlice>();
    final SootMethod method;
    final Config config;

    public DebuggerDebugVariableSlicer(Config config, SootMethod method) {
        this.config = config;
        this.method = method;
        this.build(method);
    }

    private void build(SootMethod method) {
        Body body = method.getActiveBody();
        List variables = body.getLocalVariables();
        if (variables == null || variables.isEmpty()) {
            return;
        }
        HashMap<Unit, Map<Integer, LocalVariable>> variablesOfUnit = new HashMap<Unit, Map<Integer, LocalVariable>>();
        DebuggerDebugVariableSlicer.mapUnitsToVariables(method, variablesOfUnit);
        DebuggerDebugVariableSlicer.buildSlices(this.config, body, variablesOfUnit, this.unitToSlice, this.slices);
    }

    static void mapUnitsToVariables(SootMethod method, Map<Unit, Map<Integer, LocalVariable>> variablesOfUnit) {
        Body body = method.getActiveBody();
        int parameterCount = method.getParameterCount();
        if (!method.isStatic()) {
            ++parameterCount;
        }
        PatchingChain units = body.getUnits();
        for (LocalVariable v : body.getLocalVariables()) {
            Unit endUnit;
            if (v.getName().contains("$")) continue;
            Unit startUnit = v.getStartUnit();
            if (v.getEndUnit() != null) {
                endUnit = v.getEndUnit();
                if (endUnit != startUnit) {
                    endUnit = (Unit)units.getPredOf((Object)v.getEndUnit());
                }
            } else {
                endUnit = (Unit)units.getLast();
            }
            Iterator it = units.iterator((Object)startUnit, (Object)endUnit);
            while (it.hasNext()) {
                Unit u = (Unit)it.next();
                Map vars = variablesOfUnit.computeIfAbsent(u, k -> new HashMap());
                vars.put(v.getIndex(), v);
            }
        }
    }

    static void buildSlices(Config config, Body body, Map<Unit, Map<Integer, LocalVariable>> variablesOfUnit, Map<Unit, Integer> unitToVariableSlices, List<UnitVariableSlice> slices) {
        HashMap<UnitVariableSlice, Integer> slicesHash = new HashMap<UnitVariableSlice, Integer>();
        RoboVmLiveSlotLocals liveLocals = new RoboVmLiveSlotLocals((UnitGraph)new ExceptionalUnitGraph(body));
        for (Unit u : body.getUnits()) {
            Map<Integer, LocalVariable> visibleVariables;
            int idx;
            Map visibleLocals;
            if (u instanceof IdentityStmt || (visibleLocals = liveLocals.getLocalsBeforUnit(u)) == null || visibleLocals.isEmpty() || (idx = DebuggerDebugVariableSlicer.getSliceForUnit(config, visibleLocals, visibleVariables = variablesOfUnit.get(u), slicesHash, slices)) < 0) continue;
            unitToVariableSlices.put(u, idx);
        }
    }

    static int getSliceForUnit(Config config, Map<Integer, Local> visibleLocals, Map<Integer, LocalVariable> visibleVariables, Map<UnitVariableSlice, Integer> slicesHash, List<UnitVariableSlice> slices) {
        int idx;
        TreeMap<Integer, LocalVariable> confirmedVariables = new TreeMap<Integer, LocalVariable>();
        TreeMap<Integer, Local> confirmedLocals = new TreeMap<Integer, Local>();
        for (Map.Entry<Integer, Local> e : visibleLocals.entrySet()) {
            Integer index = e.getKey();
            Local local = e.getValue();
            LocalVariable variable = null;
            if (visibleVariables != null) {
                variable = visibleVariables.get(index);
            }
            if (variable == null) continue;
            Type variableType = Util.v().jimpleTypeOfFieldDescriptor(variable.getDescriptor());
            if (DebuggerDebugVariableSlicer.isAssignable(variableType, local.getType())) {
                confirmedVariables.put(index, variable);
                confirmedLocals.put(index, local);
                continue;
            }
            if (config == null || !config.getHome().isDev()) continue;
            config.getLogger().error("Variable and local type missmatch " + variable.getDescriptor() + " != " + local.getType(), new Object[0]);
        }
        if (confirmedVariables.size() == 0) {
            return -1;
        }
        UnitVariableSlice slice = new UnitVariableSlice((List<LocalVariable>)new ArrayList<LocalVariable>(confirmedVariables.values()), (List<Local>)new ArrayList<Local>(confirmedLocals.values()));
        if (slicesHash.containsKey(slice)) {
            idx = slicesHash.get(slice);
        } else {
            idx = slices.size();
            slices.add(slice);
            slicesHash.put(slice, idx);
        }
        return idx;
    }

    boolean containsVariableSliceForUnit(Unit unit) {
        return this.unitToSlice.containsKey(unit);
    }

    int getVariableSliceIndexForUnit(Unit unit) {
        Integer v = this.unitToSlice.get(unit);
        if (v == null) {
            return -1;
        }
        return v;
    }

    UnitVariableSlice getVariableSliceForUnit(Unit unit) {
        return this.slices.get(this.getVariableSliceIndexForUnit(unit));
    }

    UnitVariableSlice getVariableSlice(int idx) {
        return this.slices.get(idx);
    }

    public SootMethod getMethod() {
        return this.method;
    }

    static boolean listEquals(List a, List a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.size();
        if (a2.size() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a.get(i) == a2.get(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(Type to, Type from) {
        boolean assignable;
        if (to instanceof RefType && from instanceof RefType) {
            SootClass t = ((RefType)to).getSootClass();
            SootClass f = ((RefType)from).getSootClass();
            assignable = DebuggerDebugVariableSlicer.isAssignable(t, f);
        } else if (to instanceof ArrayType && from instanceof ArrayType) {
            ArrayType t = (ArrayType)to;
            ArrayType f = (ArrayType)from;
            assignable = t.numDimensions == f.numDimensions && DebuggerDebugVariableSlicer.isAssignable(t.baseType, f.baseType);
        } else {
            assignable = (to instanceof RefType || to instanceof ArrayType) && from instanceof NullType ? true : to.equals(from);
        }
        return assignable;
    }

    private static boolean isAssignable(SootClass to, SootClass from) {
        if (to.equals(from)) {
            return true;
        }
        if (to.isInterface()) {
            SootClass c = from;
            while (c != null) {
                for (SootClass ifs : c.getInterfaces()) {
                    if (!DebuggerDebugVariableSlicer.isAssignable(to, ifs)) continue;
                    return true;
                }
                c = c.hasSuperclass() ? c.getSuperclass() : null;
            }
        } else if (from.hasSuperclass()) {
            return DebuggerDebugVariableSlicer.isAssignable(to, from.getSuperclass());
        }
        return false;
    }

    static class VariablesSlice<T1, T2> {
        final List<T1> variables;
        final List<T2> locals;
        private final int hashCode;

        VariablesSlice(List<T1> variables, List<T2> locals) {
            if (variables == null || locals == null || variables.size() != locals.size()) {
                throw new IllegalArgumentException();
            }
            this.variables = variables;
            this.locals = locals;
            this.hashCode = Objects.hash(variables, locals);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariablesSlice that = (VariablesSlice)o;
            return DebuggerDebugVariableSlicer.listEquals(this.variables, that.variables) && DebuggerDebugVariableSlicer.listEquals(this.locals, that.locals);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    static class UnitVariableSlice
    extends VariablesSlice<LocalVariable, Local> {
        UnitVariableSlice(List<LocalVariable> variables, List<Local> locals) {
            super(variables, locals);
        }
    }
}

