/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.ios;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.util.StringUtils;
import org.apache.commons.lang3.Validate;
import org.robovm.compiler.util.ToolchainUtil;

public class SDK
implements Comparable<SDK> {
    private static final String ADDITIONAL_SDK_LOCATION = "/Library/Developer/CoreSimulator/Profiles/Runtimes";
    private static final String IOS_SIMULATOR_MAJOR_MINOR_VERSION_REGEX = "iOS ([0-9]{1,2}).([0-9]{1,2}).simruntime";
    private static final Pattern IOS_SIMULATOR_MAJOR_MINOR_VERSION_REGEX_PATTERN = Pattern.compile("iOS ([0-9]{1,2}).([0-9]{1,2}).simruntime");
    private String displayName;
    private String minimalDisplayName;
    private String canonicalName;
    private String version;
    private File root;
    private NSDictionary defaultProperties;
    private int major;
    private int minor;
    private int revision;
    private String build;
    private String platformBuild;
    private String platformVersion;
    private String platformName;

    public static SDK create(File root) throws Exception {
        File sdkSettingsFile = new File(root, "SDKSettings.plist");
        File sdkSysVersionFile = new File(root, "System/Library/CoreServices/SystemVersion.plist");
        File platformVersionFile = new File(root, "../../../version.plist");
        File platformInfoFile = new File(root, "../../../Info.plist");
        if (sdkSettingsFile.exists() && platformInfoFile.exists()) {
            NSDictionary sdkSettingsDict = (NSDictionary)PropertyListParser.parse((File)sdkSettingsFile);
            NSDictionary sdkSysVersionDict = (NSDictionary)PropertyListParser.parse((File)sdkSysVersionFile);
            NSDictionary platformInfoDict = (NSDictionary)PropertyListParser.parse((File)platformInfoFile);
            SDK sdk = new SDK();
            sdk.root = root;
            sdk.displayName = SDK.toString(sdkSettingsDict.objectForKey("DisplayName"));
            sdk.minimalDisplayName = SDK.toString(sdkSettingsDict.objectForKey("MinimalDisplayName"));
            sdk.canonicalName = SDK.toString(sdkSettingsDict.objectForKey("CanonicalName"));
            sdk.version = SDK.toString(sdkSettingsDict.objectForKey("Version"));
            sdk.defaultProperties = (NSDictionary)sdkSettingsDict.objectForKey("DefaultProperties");
            sdk.build = SDK.toString(sdkSysVersionDict.objectForKey("ProductBuildVersion"));
            if (platformVersionFile.exists()) {
                NSDictionary platformVersionDict = (NSDictionary)PropertyListParser.parse((File)platformVersionFile);
                sdk.platformBuild = SDK.toString(platformVersionDict.objectForKey("ProductBuildVersion"));
            } else {
                sdk.platformBuild = sdk.build;
            }
            NSDictionary additionalInfo = (NSDictionary)platformInfoDict.objectForKey("AdditionalInfo");
            sdk.platformVersion = SDK.toString(additionalInfo.objectForKey("DTPlatformVersion"));
            sdk.platformName = SDK.toString(additionalInfo.objectForKey("DTPlatformName"));
            String[] parts = StringUtils.split((String)sdk.version, (String)".");
            sdk.major = Integer.parseInt(parts[0]);
            sdk.minor = parts.length >= 2 ? Integer.parseInt(parts[1]) : 0;
            sdk.revision = parts.length >= 3 ? Integer.parseInt(parts[2]) : 0;
            return sdk;
        }
        throw new IllegalArgumentException(root.getAbsolutePath() + " is not an SDK root path");
    }

    private static String toString(NSObject o) {
        return o != null ? o.toString() : null;
    }

    private static List<SDK> listSDKs(String platform) {
        ArrayList<SDK> allSdks = new ArrayList<SDK>(SDK.listBundledFileFormatSdks(platform));
        return allSdks;
    }

    private static Collection<? extends SDK> listAdditionalFileFormatSdks() {
        File sdksDir = new File(ADDITIONAL_SDK_LOCATION);
        if (!sdksDir.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<SDK> sdks = new ArrayList<SDK>();
        for (File sdkRoot : (File[])Validate.notNull((Object)sdksDir.listFiles())) {
            if (!sdkRoot.getName().matches(IOS_SIMULATOR_MAJOR_MINOR_VERSION_REGEX)) continue;
            sdks.add(SDK.createAdditionalFileFormatSdk(sdkRoot));
        }
        return sdks;
    }

    static SDK createAdditionalFileFormatSdk(File sdkRootDir) {
        Matcher matcher = IOS_SIMULATOR_MAJOR_MINOR_VERSION_REGEX_PATTERN.matcher(sdkRootDir.getName());
        Validate.isTrue((boolean)matcher.find());
        String majorVersion = matcher.group(1);
        String minorVersion = matcher.group(2);
        String name = sdkRootDir.getName();
        SDK sdk = new SDK();
        sdk.major = Integer.valueOf(majorVersion);
        sdk.minor = Integer.valueOf(minorVersion);
        sdk.minimalDisplayName = name;
        sdk.displayName = name;
        sdk.canonicalName = name;
        sdk.version = majorVersion + "." + minorVersion;
        sdk.root = sdkRootDir;
        return sdk;
    }

    private static Collection<? extends SDK> listBundledFileFormatSdks(String platform) {
        try {
            ArrayList<SDK> sdks = new ArrayList<SDK>();
            File sdksDir = new File(ToolchainUtil.findXcodePath() + "/Platforms/" + platform + ".platform/Developer/SDKs");
            if (sdksDir.exists() && sdksDir.isDirectory()) {
                for (File root : sdksDir.listFiles()) {
                    try {
                        sdks.add(SDK.create(root));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return sdks;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static List<SDK> listDeviceSDKs() {
        return SDK.listSDKs("iPhoneOS");
    }

    public static List<SDK> listSimulatorSDKs() {
        List<SDK> sdks = SDK.listSDKs("iPhoneSimulator");
        sdks.addAll(SDK.listAdditionalFileFormatSdks());
        return sdks;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMinimalDisplayName() {
        return this.minimalDisplayName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public String getVersion() {
        return this.version;
    }

    public File getRoot() {
        return this.root;
    }

    public NSDictionary getDefaultProperties() {
        return this.defaultProperties;
    }

    public NSObject getDefaultProperty(String key) {
        return this.defaultProperties.objectForKey(key);
    }

    public String getBuild() {
        return this.build;
    }

    public String getPlatformBuild() {
        return this.platformBuild;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getVersionCode() {
        return this.major << 16 | this.minor << 8 | this.revision;
    }

    @Override
    public int compareTo(SDK o) {
        int c;
        int n = this.major < o.major ? -1 : (c = this.major > o.major ? 1 : 0);
        if (c == 0) {
            int n2 = this.minor < o.minor ? -1 : (c = this.minor > o.minor ? 1 : 0);
            if (c == 0) {
                int n3 = this.revision < o.revision ? -1 : (c = this.revision > o.revision ? 1 : 0);
                if (c == 0) {
                    c = this.getRoot().getAbsolutePath().contains("iPhoneOS.sdk") ? 0 : 1;
                    c -= o.getRoot().getAbsolutePath().contains("iPhoneOS.sdk") ? 0 : 1;
                }
            }
        }
        return c;
    }

    public String toString() {
        return "SDK [displayName=" + this.displayName + ", minimalDisplayName=" + this.minimalDisplayName + ", canonicalName=" + this.canonicalName + ", version=" + this.version + ", root=" + this.root + ", major=" + this.major + ", minor=" + this.minor + ", revision=" + this.revision + ", build=" + this.build + ", platformBuild=" + this.platformBuild + ", platformVersion=" + this.platformVersion + ", platformName=" + this.platformName + "]";
    }
}

