/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.ios;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.target.ios.ProvisioningProfile;
import org.robovm.compiler.util.Executor;

public class SigningIdentity
implements Comparable<SigningIdentity> {
    private final String name;
    private final String fingerprint;
    public static final SigningIdentity ADHOC = new SigningIdentity("ad-hoc (simulator only)", "-");

    SigningIdentity(String name, String fingerprint) {
        this.name = name;
        this.fingerprint = fingerprint;
    }

    public String getName() {
        return this.name;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public int compareTo(SigningIdentity o) {
        return this.name.compareToIgnoreCase(o.name);
    }

    public String toString() {
        return "SigningIdentity [name=" + this.name + ", fingerprint=" + this.fingerprint + "]";
    }

    public static SigningIdentity find(List<SigningIdentity> ids, String search) {
        return SigningIdentity.find(ids, search, null);
    }

    public static SigningIdentity find(List<SigningIdentity> ids, String search, ProvisioningProfile profile) {
        if (search.startsWith("/") && search.endsWith("/")) {
            Pattern pattern = Pattern.compile(search.substring(1, search.length() - 1));
            for (SigningIdentity id : ids) {
                if (!pattern.matcher(id.name).find() || profile != null && !profile.getCertFingerprints().contains(id.getFingerprint())) continue;
                return id;
            }
        } else {
            for (SigningIdentity id : ids) {
                if (!id.name.startsWith(search) && !id.fingerprint.equals(search.toUpperCase()) || profile != null && !profile.getCertFingerprints().contains(id.getFingerprint())) continue;
                return id;
            }
        }
        throw new IllegalArgumentException("No signing identity found matching '" + search + "'");
    }

    protected static List<SigningIdentity> parse(String securityOutput) {
        ArrayList<SigningIdentity> ids = new ArrayList<SigningIdentity>();
        Pattern pattern = Pattern.compile("^\\d+\\)\\s+([0-9A-F]+)\\s+\"([^\"]*)\"\\s*(.*)");
        for (String line : securityOutput.split("\n")) {
            Matcher matcher = pattern.matcher(line = line.trim());
            if (!matcher.find()) continue;
            String name = matcher.group(2);
            String fingerprint = matcher.group(1);
            String flags = matcher.group(3);
            if (flags != null && flags.contains("CSSMERR_TP_CERT_")) continue;
            ids.add(new SigningIdentity(name, fingerprint));
        }
        Collections.sort(ids);
        return ids;
    }

    public static List<SigningIdentity> list() {
        try {
            return SigningIdentity.parse(new Executor(Logger.NULL_LOGGER, "security").args("find-identity", "-v", "-p", "codesigning").execCapture());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<SigningIdentity> list(String search) {
        List<SigningIdentity> unfiltered = SigningIdentity.list();
        ArrayList<SigningIdentity> filtered = new ArrayList<SigningIdentity>();
        if (search.startsWith("/") && search.endsWith("/")) {
            Pattern pattern = Pattern.compile(search.substring(1, search.length() - 1));
            for (SigningIdentity id : unfiltered) {
                if (!pattern.matcher(id.name).find()) continue;
                filtered.add(id);
            }
        } else {
            for (SigningIdentity id : unfiltered) {
                if (!id.name.startsWith(search) && !id.fingerprint.equals(search.toUpperCase())) continue;
                filtered.add(id);
            }
        }
        return filtered;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(SigningIdentity.list());
        } else {
            System.out.println(SigningIdentity.find(SigningIdentity.list(), args[0]));
        }
    }
}

