/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.XMLPropertyListParser;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class InfoPList {
    private File file;
    private NSDictionary dictionary;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([^}]+)\\}");

    public InfoPList(File file) {
        this.file = file;
    }

    public void parse(Properties props) {
        this.parse(props, true);
    }

    public void parse(Properties props, boolean includeSystemProperties) {
        try {
            this.dictionary = (NSDictionary)InfoPList.parsePropertyList(this.file, props, includeSystemProperties);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to parse Info.plist XML file: " + this.file, t);
        }
    }

    public String getBundleIdentifier() {
        NSObject object;
        if (this.dictionary != null && (object = this.dictionary.objectForKey("CFBundleIdentifier")) != null) {
            return object.toString();
        }
        return null;
    }

    public String getBundleExecutable() {
        NSObject object;
        if (this.dictionary != null && (object = this.dictionary.objectForKey("CFBundleExecutable")) != null) {
            return object.toString();
        }
        return null;
    }

    public String getMinimumOSVersion() {
        NSObject object;
        if (this.dictionary != null && (object = this.dictionary.objectForKey("MinimumOSVersion")) != null) {
            return object.toString();
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public NSDictionary getDictionary() {
        return this.dictionary;
    }

    static void replacePropertyRefs(Node node, Properties props) {
        Text el;
        String value;
        if (node instanceof Text && (value = (el = (Text)node).getNodeValue()) != null && value.trim().length() > 0) {
            Matcher matcher = VARIABLE_PATTERN.matcher(value);
            StringBuilder sb = new StringBuilder();
            int pos = 0;
            while (matcher.find()) {
                if (pos < matcher.start()) {
                    sb.append(value.substring(pos, matcher.start()));
                }
                String key = matcher.group(1);
                sb.append(props.getProperty(key, matcher.group()));
                pos = matcher.end();
            }
            if (pos < value.length()) {
                sb.append(value.substring(pos));
            }
            el.setNodeValue(sb.toString());
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            InfoPList.replacePropertyRefs(children.item(i), props);
        }
    }

    static NSObject parsePropertyList(File file, Properties props, boolean includeSystemProperties) throws Exception {
        Properties allProps = new Properties(includeSystemProperties ? System.getProperties() : new Properties());
        allProps.putAll((Map<?, ?>)props);
        Method getDocBuilder = XMLPropertyListParser.class.getDeclaredMethod("getDocBuilder", new Class[0]);
        getDocBuilder.setAccessible(true);
        Method parseDocument = XMLPropertyListParser.class.getDeclaredMethod("parseDocument", Document.class);
        parseDocument.setAccessible(true);
        DocumentBuilder docBuilder = (DocumentBuilder)getDocBuilder.invoke(null, new Object[0]);
        Document doc = docBuilder.parse(file);
        InfoPList.replacePropertyRefs(doc, allProps);
        return (NSObject)parseDocument.invoke(null, doc);
    }
}

